/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import weblogic.cluster.messaging.internal.AnonymousGroupImpl;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.Group;
import weblogic.cluster.messaging.internal.GroupImpl;
import weblogic.cluster.messaging.internal.GroupManager;
import weblogic.cluster.messaging.internal.GroupMember;
import weblogic.cluster.messaging.internal.GroupMemberImpl;
import weblogic.cluster.messaging.internal.Message;
import weblogic.cluster.messaging.internal.MessageListener;
import weblogic.cluster.messaging.internal.RemoteGroupImpl;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;
import weblogic.cluster.messaging.internal.ServerConfigurationInformationImpl;

public class GroupManagerImpl
implements GroupManager {
    private static final boolean DEBUG = Environment.DEBUG;
    private static final int MAX_GROUP_SIZE = 10;
    private final GroupMemberImpl localMember;
    private final ServerConfigurationInformation serverConfigForWire;
    private GroupImpl localGroup;
    private GroupImpl anonymousGroup = new AnonymousGroupImpl();
    private final Set remoteGroups = new HashSet();
    private MessageListener listener;

    public static GroupManager getInstance() {
        return Factory.THE_ONE;
    }

    private GroupManagerImpl() {
        this.localMember = new GroupMemberImpl(Environment.getConfiguredServersMonitor().getLocalServerConfiguration(), 1L);
        ServerConfigurationInformation serverConfigurationInformation = this.localMember.getConfiguration();
        this.serverConfigForWire = new ServerConfigurationInformationImpl(serverConfigurationInformation.getAddress(), serverConfigurationInformation.getPort(), serverConfigurationInformation.getServerName(), System.currentTimeMillis(), serverConfigurationInformation.isUsingSSL());
        this.initializeGroups(Environment.getConfiguredServersMonitor().getConfiguredServers());
        this.localGroup.start();
    }

    public ServerConfigurationInformation getServerConfigForWire() {
        return this.serverConfigForWire;
    }

    public void startRemoteGroups() {
        Iterator iterator = this.remoteGroups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            group.start();
        }
    }

    public void stopRemoteGroups() {
        Iterator iterator = this.remoteGroups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            group.stop();
        }
    }

    public void sendRemoteGroups(final Message message) {
        Environment.executeForwardMessage(new Runnable(){

            public void run() {
                Iterator iterator = GroupManagerImpl.this.remoteGroups.iterator();
                while (iterator.hasNext()) {
                    Group group = (Group)iterator.next();
                    try {
                        group.send(message);
                    }
                    catch (IOException iOException) {}
                }
                try {
                    GroupManagerImpl.this.anonymousGroup.send(message);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public GroupMember getLocalMember() {
        return this.localMember;
    }

    public Group getLocalGroup() {
        return this.localGroup;
    }

    public synchronized Group[] getRemoteGroups() {
        Group[] groupArray = new Group[this.remoteGroups.size()];
        this.remoteGroups.toArray(groupArray);
        return groupArray;
    }

    private void initializeGroups(SortedSet sortedSet) {
        Iterator iterator = sortedSet.iterator();
        ServerConfigurationInformation serverConfigurationInformation = Environment.getConfiguredServersMonitor().getLocalServerConfiguration();
        int n = 0;
        HashSet<ServerConfigurationInformation> hashSet = new HashSet<ServerConfigurationInformation>(10);
        boolean bl = false;
        while (iterator.hasNext()) {
            ServerConfigurationInformation serverConfigurationInformation2 = (ServerConfigurationInformation)iterator.next();
            if (DEBUG) {
                this.debug("initGroups: processing " + serverConfigurationInformation2);
            }
            if (serverConfigurationInformation.equals(serverConfigurationInformation2)) {
                bl = true;
            }
            if (DEBUG) {
                this.debug("initGroups: isLocal " + bl);
            }
            hashSet.add(serverConfigurationInformation2);
            if (++n % 10 != 0 && n != sortedSet.size()) continue;
            if (bl) {
                this.localGroup = new GroupImpl(hashSet);
                this.localGroup.addToRunningSet(this.localMember);
                bl = false;
            } else {
                this.remoteGroups.add(new RemoteGroupImpl(hashSet));
            }
            hashSet = new HashSet(10);
        }
        if (DEBUG) {
            this.debug("local group: " + this.localGroup);
        }
    }

    private void debug(String string) {
        Environment.getLogService().debug("[GroupManager] " + string);
    }

    public void handleMessage(Message message, Connection connection) {
        GroupMember groupMember;
        GroupMember groupMember2;
        if (this.localMember.getConfiguration().equals(message.getSenderConfiguration())) {
            if (DEBUG) {
                this.debug("squelching local message:" + message);
            }
            return;
        }
        if (DEBUG) {
            this.debug("received for dispatch:" + message + " from " + connection);
        }
        if ((groupMember2 = this.findOrCreateGroupMember(message)) != null) {
            groupMember2.setLastMessageArrivalTime(System.currentTimeMillis());
            if (DEBUG) {
                this.debug("updated LAT for " + groupMember2.getConfiguration().getServerName());
            }
        }
        if ((groupMember = this.findOrCreateGroupMember(connection)) != null) {
            groupMember.setLastMessageArrivalTime(System.currentTimeMillis());
            if (DEBUG) {
                this.debug("updated LAT for " + groupMember.getConfiguration().getServerName());
            }
            groupMember.addConnection(connection);
        }
        this.localMember.receive(message, connection);
        this.listener.onMessage(message);
    }

    public void setMessageListener(MessageListener messageListener) {
        this.listener = messageListener;
    }

    private GroupMember findOrCreateGroupMember(Message message) {
        Group group;
        String string = message.getServerName();
        ServerConfigurationInformation serverConfigurationInformation = this.localGroup.getConfigInformation(string);
        GroupImpl groupImpl = group = serverConfigurationInformation != null ? this.localGroup : null;
        if (group == null) {
            Iterator iterator = this.remoteGroups.iterator();
            while (iterator.hasNext()) {
                Group group2 = (Group)iterator.next();
                serverConfigurationInformation = group2.getConfigInformation(string);
                if (serverConfigurationInformation == null) continue;
                group = group2;
                break;
            }
        }
        if (group == null) {
            if (DEBUG) {
                this.debug(message + " associated with anonymous group");
            }
            group = this.anonymousGroup;
            serverConfigurationInformation = message.getSenderConfiguration();
        }
        return group.findOrCreateGroupMember(serverConfigurationInformation, message.getServerStartTime());
    }

    private GroupMember findOrCreateGroupMember(Connection connection) {
        Group group;
        String string = connection.getConfiguration().getServerName();
        ServerConfigurationInformation serverConfigurationInformation = this.localGroup.getConfigInformation(string);
        GroupImpl groupImpl = group = serverConfigurationInformation != null ? this.localGroup : null;
        if (group == null) {
            Iterator iterator = this.remoteGroups.iterator();
            while (iterator.hasNext()) {
                Group group2 = (Group)iterator.next();
                serverConfigurationInformation = group2.getConfigInformation(string);
                if (serverConfigurationInformation == null) continue;
                group = group2;
                break;
            }
        }
        if (group == null) {
            if (DEBUG) {
                this.debug(connection + " associated with anonymous group");
            }
            group = this.anonymousGroup;
            serverConfigurationInformation = connection.getConfiguration();
        }
        return group.findOrCreateGroupMember(serverConfigurationInformation, connection.getConfiguration().getCreationTime());
    }

    private static final class Factory {
        static final GroupManager THE_ONE = new GroupManagerImpl();

        private Factory() {
        }
    }
}

