/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.GroupManagerImpl;
import weblogic.cluster.messaging.internal.GroupMember;
import weblogic.cluster.messaging.internal.Message;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;

public final class GroupMemberImpl
implements GroupMember {
    private static final boolean DEBUG;
    private static final int RETRY_COUNT = 2;
    private long startTime;
    private final ServerConfigurationInformation configuration;
    private long lastArrivalTime;
    private Connection connection = null;
    private ReentrantLock lock = new ReentrantLock(true);
    ArrayList connectionList = new ArrayList();
    private static final int FIRST_LOCK_ACQUIRE_TIME_MILLIS;
    private static final int SECOND_LOCK_ACQUIRE_TIME_MILLIS;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static int initProperty(String string, int n) {
        try {
            return Integer.getInteger(string, n);
        }
        catch (SecurityException securityException) {
            return n;
        }
    }

    public GroupMemberImpl(ServerConfigurationInformation serverConfigurationInformation, long l) {
        this.configuration = serverConfigurationInformation;
        this.startTime = l;
    }

    public GroupMemberImpl(ServerConfigurationInformation serverConfigurationInformation) {
        this.configuration = serverConfigurationInformation;
    }

    public ServerConfigurationInformation getConfiguration() {
        return this.configuration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws IOException {
        block5: {
            boolean bl = false;
            try {
                bl = this.acquireLock(false);
                if (bl) {
                    this.sendMessage(message);
                    break block5;
                }
                throw new IOException("Timed out");
            }
            finally {
                if (bl) {
                    this.unLock();
                }
            }
        }
    }

    private void sendMessage(Message message) throws IOException {
        IOException iOException = null;
        for (int i = 0; i < 2; ++i) {
            try {
                Object object;
                if (this.connection == null || this.connection.isDead()) {
                    object = Environment.getConnectionManager();
                    this.connection = object.createConnection(this.configuration);
                }
                if (this.connection != null && !this.connection.isDead()) {
                    if (DEBUG) {
                        GroupMemberImpl.debug("Send message to " + this.configuration.getServerName() + ". Retry count " + i);
                    }
                    this.connection.send(message);
                }
                object = this.connectionList.iterator();
                while (object.hasNext()) {
                    Connection connection = (Connection)object.next();
                    if (!connection.isDead()) {
                        if (DEBUG) {
                            GroupMemberImpl.debug("Send message to " + connection.getServerId());
                        }
                        connection.send(message);
                        continue;
                    }
                    if (!DEBUG) continue;
                    GroupMemberImpl.debug("Connection for duplicate member: " + connection.getServerId() + " is dead.  Unable to deliver message");
                }
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                if (!DEBUG || !DEBUG) continue;
                GroupMemberImpl.debug("Failed to send message to " + this.configuration.getServerName() + "> Excpetion:" + iOException2);
                continue;
            }
        }
        throw iOException;
    }

    public void receive(Message message, Connection connection) {
        if (DEBUG) {
            GroupMemberImpl.debug("received message: " + message + " from " + connection.getConfiguration().getServerName());
        }
        if (DEBUG) {
            GroupMemberImpl.debug("local group: " + GroupManagerImpl.getInstance().getLocalGroup());
        }
        GroupManagerImpl.getInstance().getLocalGroup().forward(message, connection);
    }

    public void setLastMessageArrivalTime(long l) {
        this.lastArrivalTime = l;
    }

    public long getLastArrivalTime() {
        return this.lastArrivalTime;
    }

    private static void debug(String string) {
        Environment.getLogService().debug("[GroupMember] " + string);
    }

    public int compareTo(Object object) {
        if (!$assertionsDisabled && !(object instanceof GroupMemberImpl)) {
            throw new AssertionError();
        }
        GroupMemberImpl groupMemberImpl = (GroupMemberImpl)object;
        return this.configuration.compareTo(groupMemberImpl.configuration);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GroupMemberImpl)) {
            return false;
        }
        GroupMemberImpl groupMemberImpl = (GroupMemberImpl)object;
        return this.configuration.equals(groupMemberImpl.configuration);
    }

    public int hashCode() {
        return this.configuration.hashCode();
    }

    public String toString() {
        return this.configuration.getServerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnection(Connection connection) {
        if (DEBUG) {
            GroupMemberImpl.debug("Adding connection to " + this + " with conn: " + connection + " and serverId: " + connection.getServerId());
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.acquireLock(true);
            if (bl) {
                if (this.connection == null) {
                    this.connection = connection;
                    bl2 = true;
                } else if (this.connection.getServerId() == null && connection.getServerId() != null) {
                    this.connection = connection;
                    bl2 = true;
                } else if (this.connection.getServerId() != null && connection.getServerId() != null && !this.connection.getServerId().equals(connection.getServerId())) {
                    Iterator iterator = this.connectionList.iterator();
                    boolean bl3 = false;
                    while (iterator.hasNext()) {
                        Connection connection2 = (Connection)iterator.next();
                        if (connection2.getServerId() == null || !connection2.getServerId().equals(connection.getServerId())) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        if (DEBUG) {
                            GroupMemberImpl.debug("adding connection to the connectionList with serverId: " + connection.getServerId());
                        }
                        this.connectionList.add(connection);
                    }
                }
            }
        }
        finally {
            if (bl) {
                this.unLock();
            }
        }
        return bl2;
    }

    private boolean acquireLock(boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = this.lock.tryLock(FIRST_LOCK_ACQUIRE_TIME_MILLIS, TimeUnit.MILLISECONDS);
            if (!bl2) {
                if (bl) {
                    return bl2;
                }
                int n = this.lock.getQueueLength();
                if (n > 0) {
                    if (DEBUG) {
                        GroupMemberImpl.debug("Unable to acquirelock to write to " + this.configuration.getServerName() + ".Total threads waiting to acquire lock=" + n);
                    }
                } else {
                    bl2 = this.lock.tryLock(SECOND_LOCK_ACQUIRE_TIME_MILLIS, TimeUnit.MILLISECONDS);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return bl2;
    }

    private void unLock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    static {
        $assertionsDisabled = !GroupMemberImpl.class.desiredAssertionStatus();
        DEBUG = Environment.DEBUG;
        FIRST_LOCK_ACQUIRE_TIME_MILLIS = GroupMemberImpl.initProperty("weblogic.unicast.sendTimeoutMillis", 1000);
        SECOND_LOCK_ACQUIRE_TIME_MILLIS = GroupMemberImpl.initProperty("weblogic.unicast.sendBackoffTimeoutMillis", 10000);
    }
}

