/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import weblogic.cluster.messaging.internal.HttpPingRoutineImpl;
import weblogic.cluster.messaging.internal.Probe;
import weblogic.cluster.messaging.internal.ProbeContext;
import weblogic.cluster.messaging.internal.SuspectedMemberInfo;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class HttpPingProbe
implements Probe {
    private static final DebugCategory debugDisconnectMonitor = Debug.getCategory((String)"weblogic.cluster.leasing.DisconnectMonitor");
    private static final boolean DEBUG = HttpPingProbe.debugEnabled();

    public void invoke(ProbeContext probeContext) {
        boolean bl = this.doHttpPing(probeContext.getSuspectedMemberInfo());
        if (bl) {
            probeContext.setNextAction(0);
            probeContext.setResult(1);
        } else {
            probeContext.setNextAction(1);
            probeContext.setResult(-1);
        }
    }

    protected boolean doHttpPing(SuspectedMemberInfo suspectedMemberInfo) {
        HttpPingRoutineImpl httpPingRoutineImpl = HttpPingRoutineImpl.getInstance();
        return httpPingRoutineImpl.ping(suspectedMemberInfo.getServerConfigurationInformation()) > 0L;
    }

    private static boolean debugEnabled() {
        return debugDisconnectMonitor.isEnabled();
    }

    private static void debug(String string) {
        System.out.println("[HttpPingProbe] " + string);
    }
}

