/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.PingRoutine;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;
import weblogic.net.http.HttpURLConnection;
import weblogic.utils.collections.ConcurrentHashSet;

public class HttpPingRoutineImpl
implements PingRoutine {
    private static final boolean DEBUG;
    private static final int connectTimeout;
    private static final int readTimeout;
    private static final String http = "http";
    private static final String reqURI = "wls_does_not_exist_url";
    private static final HttpPingRoutineImpl THE_ONE;
    private static final ConcurrentHashSet pendingPings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static HttpPingRoutineImpl getInstance() {
        return THE_ONE;
    }

    public long ping(ServerConfigurationInformation serverConfigurationInformation) {
        if (pendingPings.contains((Object)serverConfigurationInformation)) {
            if (DEBUG) {
                HttpPingRoutineImpl.debug("There is already a ping pending for " + serverConfigurationInformation);
            }
            return 0L;
        }
        pendingPings.add((Object)serverConfigurationInformation);
        long l = this.httpPing(serverConfigurationInformation.getAddress().getHostName(), serverConfigurationInformation.getPort());
        pendingPings.remove((Object)serverConfigurationInformation);
        return l;
    }

    private long httpPing(String string, int n) {
        try {
            URL uRL = new URL(http, string, n, reqURI);
            HttpURLConnection httpURLConnection = new HttpURLConnection(uRL);
            httpURLConnection.setConnectTimeout(connectTimeout);
            httpURLConnection.setReadTimeout(readTimeout);
            httpURLConnection.connect();
            if (this.isError(httpURLConnection.getResponseCode())) {
                if (DEBUG) {
                    HttpPingRoutineImpl.debug("The http response code is an error (" + httpURLConnection.getResponseCode() + ") and this httpPing will return 0");
                }
                return 0L;
            }
            if (DEBUG) {
                HttpPingRoutineImpl.debug("The http response code was not an error (" + httpURLConnection.getResponseCode() + ") and this httpPing will return 1");
            }
            return 1L;
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)("Could not ping server at host: " + string + " and port: " + n));
        }
        catch (IOException iOException) {
            if (DEBUG) {
                HttpPingRoutineImpl.debug("HttpPing Caught IOException: " + iOException);
            }
            return 0L;
        }
    }

    private boolean isError(int n) {
        return 300 <= n && n < 400 || 500 <= n && n < 600;
    }

    public static void main(String[] stringArray) throws Exception {
        if (!$assertionsDisabled && stringArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray.length != 4) {
            throw new AssertionError();
        }
        if (!stringArray[0].equals("-host")) {
            System.out.println("ERROR: HttpPingRoutingImpl -host <host> -port <port>");
            return;
        }
        String string = stringArray[1];
        if (!stringArray[2].equals("-port")) {
            System.out.println("ERROR: HttpPingRoutingImpl -host <host> -port <port>");
            return;
        }
        String string2 = stringArray[3];
        int n = Integer.parseInt(string2);
        System.out.println("HttpPing returns: " + THE_ONE.httpPing(string, n));
    }

    private static void debug(String string) {
        Environment.getLogService().debug("[HttpPingRoutine] " + string);
    }

    static {
        $assertionsDisabled = !HttpPingRoutineImpl.class.desiredAssertionStatus();
        DEBUG = Environment.DEBUG;
        connectTimeout = Integer.valueOf(System.getProperty("httpPing.connectTimeout", "3000"));
        readTimeout = Integer.valueOf(System.getProperty("httpPing.readTimeout", "6000"));
        THE_ONE = new HttpPingRoutineImpl();
        pendingPings = new ConcurrentHashSet();
    }
}

