/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import weblogic.cluster.ClusterService;
import weblogic.cluster.messaging.internal.Probe;
import weblogic.cluster.messaging.internal.ProbeContext;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeasingException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class LeaseTableReachabilityProbe
implements Probe {
    private static final DebugCategory debugDisconnectMonitor = Debug.getCategory((String)"weblogic.cluster.leasing.DisconnectMonitor");
    private static final boolean DEBUG = LeaseTableReachabilityProbe.debugEnabled();
    private LeaseManager servicesLeaseManager = ClusterService.getClusterService().getDefaultLeaseManager("service");

    public void invoke(ProbeContext probeContext) {
        if (DEBUG) {
            LeaseTableReachabilityProbe.debug(" Checking Lease Table Reachability");
        }
        try {
            String string = this.servicesLeaseManager.findOwner("SINGLETON_MASTER");
        }
        catch (LeasingException leasingException) {
            String string = "Server cannot reach Lease table";
            probeContext.setMessage(string);
            probeContext.setNextAction(0);
            probeContext.setResult(-1);
            return;
        }
        probeContext.setNextAction(1);
        probeContext.setResult(1);
    }

    private static boolean debugEnabled() {
        return debugDisconnectMonitor.isEnabled();
    }

    private static void debug(String string) {
        System.out.println("[LeaseTableReachabilityProbe] " + string);
    }
}

