/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.SRMResultImpl;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.NumericValueHashMap;

public final class MachineState
implements Runnable {
    private static final DebugCategory debugMachineState;
    private static final boolean DEBUG;
    public static final boolean USE_NM_CONNECTION_TIMEOUT = true;
    static final boolean IGNORE_NM_CONNECTION_TIMEOUT = false;
    private static final int TIMEOUT_MULTIPLIER = 15;
    private static final AuthenticatedSubject kernelId;
    private static NumericValueHashMap machineRoundTripTimes;
    private final ArrayList configuredServerNamesInMachine = new ArrayList();
    private final HashSet configuredServerNamesInCluster = new HashSet();
    private final NodeManagerRuntime nodeManagerRuntime;
    private final SRMResultImpl result;
    private final MachineMBean machine;
    private boolean machineUnavailable;
    private boolean useConnectionTimeout;
    static final /* synthetic */ boolean $assertionsDisabled;

    MachineState(MachineMBean machineMBean, SRMResultImpl sRMResultImpl, boolean bl) {
        this.nodeManagerRuntime = NodeManagerRuntime.getInstance(machineMBean);
        this.result = sRMResultImpl;
        this.machine = machineMBean;
        this.useConnectionTimeout = bl;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ClusterMBean clusterMBean = runtimeAccess.getServer().getCluster();
        if (!$assertionsDisabled && clusterMBean == null) {
            throw new AssertionError();
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        if (!$assertionsDisabled && serverMBeanArray == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            this.configuredServerNamesInCluster.add(serverMBeanArray[i].getName());
            MachineMBean machineMBean2 = serverMBeanArray[i].getMachine();
            if (!machineMBean2.getName().equals(machineMBean.getName())) continue;
            this.configuredServerNamesInMachine.add(serverMBeanArray[i].getName());
        }
    }

    public static MachineState getMachineState(MachineMBean machineMBean, boolean bl) {
        MachineState machineState = new MachineState(machineMBean, new SRMResultImpl(), bl);
        machineState.run();
        return machineState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String string;
            Object object;
            long l = System.currentTimeMillis();
            if (DEBUG) {
                MachineState.debug("Invoking NodeManager.getStates() with timeout of " + this.getTimeout(this.machine) + "ms");
            }
            String string2 = this.nodeManagerRuntime.getStates(true, this.getTimeout(this.machine));
            MachineState.recordExecutionTime(l, System.currentTimeMillis(), this.machine);
            if (DEBUG) {
                MachineState.debug("consolidated states for machine " + this.machine.getName() + " returned by NM " + string2);
            }
            if (string2 == null || string2.length() == 0) {
                this.nullifyStates();
                return;
            }
            String[] stringArray = StringUtils.split((String)string2, (char)'=');
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (stringArray != null && stringArray.length >= 2 && stringArray[1].trim().length() != 0) {
                object = stringArray[0].trim();
                if ((stringArray = StringUtils.split((String)stringArray[1], (char)' ')) == null || stringArray.length < 2) break;
                string = stringArray[0].trim();
                if (this.configuredServerNamesInCluster.contains(object) && string.length() > 0) {
                    if (DEBUG) {
                        MachineState.debug("Server state for " + (String)object + " is " + string);
                    }
                    this.result.setServerState((String)object, this.machine.getName(), string);
                    if (this.configuredServerNamesInMachine.contains(object)) {
                        arrayList.add(object);
                    }
                }
                stringArray = StringUtils.split((String)stringArray[1], (char)'=');
            }
            if (arrayList.size() < this.configuredServerNamesInMachine.size()) {
                object = this.configuredServerNamesInMachine.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    if (arrayList.contains(string)) continue;
                    if (DEBUG) {
                        MachineState.debug("Server state for " + string + " is " + " set to UNKNOWN as the NM.getStates() did not return a result");
                    }
                    this.result.setServerState(string, this.machine.getName(), "UNKNOWN");
                }
            }
        }
        catch (IOException iOException) {
            this.nullifyStates();
        }
        finally {
            this.result.doneReporting(this.machine.getName());
        }
    }

    private static void recordExecutionTime(long l, long l2, MachineMBean machineMBean) {
        int n = (int)(l2 - l);
        int n2 = (int)machineRoundTripTimes.get((Object)machineMBean.getName());
        if (n > n2) {
            machineRoundTripTimes.put((Object)machineMBean.getName(), (long)n);
        }
    }

    private int getTimeout(MachineMBean machineMBean) {
        if (!this.useConnectionTimeout) {
            return 0;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ClusterMBean clusterMBean = runtimeAccess.getServer().getCluster();
        int n = clusterMBean.getDatabaseLessLeasingBasis().getNodeManagerTimeoutMillis();
        if (n == 0) {
            return 0;
        }
        int n2 = (int)(15L * machineRoundTripTimes.get((Object)machineMBean.getName()));
        return Math.min(n, n2);
    }

    public String getServerState(String string) {
        return this.result.getServerState(string);
    }

    public List getServersInState(String string) {
        return this.result.getServersInState(string);
    }

    public boolean isMachineUnavailable() {
        return this.machineUnavailable;
    }

    public List getServerNames() {
        return this.configuredServerNamesInMachine;
    }

    private static void debug(String string) {
        DebugLogger.debug("[MachineState] " + string);
    }

    void nullifyStates() {
        for (int i = 0; i < this.configuredServerNamesInMachine.size(); ++i) {
            this.result.setServerState((String)this.configuredServerNamesInMachine.get(i), this.machine.getName(), null);
        }
        this.machineUnavailable = true;
    }

    public String getMachineName() {
        return this.machine.getName();
    }

    public String toString() {
        return "MachineState for " + this.machine.getName() + " is " + this.result + " with machineUnavailable=" + this.machineUnavailable;
    }

    private static boolean debugEnabled() {
        return debugMachineState.isEnabled() || DebugLogger.isDebugEnabled();
    }

    static {
        $assertionsDisabled = !MachineState.class.desiredAssertionStatus();
        debugMachineState = Debug.getCategory((String)"weblogic.cluster.leasing.MachineState");
        DEBUG = MachineState.debugEnabled();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        machineRoundTripTimes = new NumericValueHashMap();
    }
}

