/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Iterator;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.cluster.messaging.internal.PingMessageListener;
import weblogic.cluster.messaging.internal.ProbeContextImpl;
import weblogic.cluster.messaging.internal.ProbeManager;
import weblogic.cluster.messaging.internal.RMIClusterMessageEndPointImpl;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.SuspectedMemberInfo;
import weblogic.cluster.messaging.internal.SuspectedMemberInfoImpl;
import weblogic.cluster.singleton.MemberDeathDetectorHeartbeatReceiverIntf;
import weblogic.health.HealthMonitorService;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class MemberDeathDetectorHeartbeatReceiver
implements MemberDeathDetectorHeartbeatReceiverIntf,
PingMessageListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory debugDisconnectMonitor = Debug.getCategory((String)"weblogic.cluster.leasing.DisconnectMonitor");
    private static final boolean DEBUG = MemberDeathDetectorHeartbeatReceiver.debugEnabled();
    private long lastHeartbeatReceived;
    private SuspectedMemberInfo leader;
    long healthCheckInterval;
    boolean timerStarted = false;
    private Timer heartbeatMonitorTimer;

    public static MemberDeathDetectorHeartbeatReceiver getInstance() {
        return SingletonMaker.THE_ONE;
    }

    private MemberDeathDetectorHeartbeatReceiver() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        this.healthCheckInterval = clusterMBean.getHealthCheckIntervalMillis();
    }

    public synchronized void pingReceived(ServerInformation serverInformation) {
        if (this.leader == null || !serverInformation.getServerName().equals(this.leader.getServerName())) {
            ClusterMemberInfo clusterMemberInfo = null;
            Collection collection = ClusterService.getClusterService().getAllRemoteMembers();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && !(clusterMemberInfo = (ClusterMemberInfo)iterator.next()).serverName().equals(serverInformation.getServerName())) {
            }
            if (clusterMemberInfo != null) {
                this.leader = new SuspectedMemberInfoImpl(clusterMemberInfo);
            }
        }
        this.lastHeartbeatReceived = System.currentTimeMillis();
        if (this.timerStarted) {
            return;
        }
        this.timerStarted = true;
        MemberDeathDetectorHeartbeatReceiver.debug("Starting Heartbeat Monitor");
        this.heartbeatMonitorTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new HeartbeatMonitor(), this.healthCheckInterval, this.healthCheckInterval);
    }

    public void stop() {
        if (this.heartbeatMonitorTimer != null) {
            this.heartbeatMonitorTimer.cancel();
        }
        this.timerStarted = false;
        if (DEBUG) {
            MemberDeathDetectorHeartbeatReceiver.debug("Halting Member Death Detector HeartbeatReceiver");
        }
    }

    public boolean isStarted() {
        return this.timerStarted;
    }

    public long getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    static void fatalError(String string) {
        MemberDeathDetectorHeartbeatReceiver.debug(" fatalError: " + string);
        HealthMonitorService.subsystemFailed("MemberDeathDetectorHeartbeatReceiver", string);
    }

    private static void debug(String string) {
        System.out.println("[MemberDeathDetectorHeartbeatReceiver] " + string);
    }

    private static boolean debugEnabled() {
        return debugDisconnectMonitor.isEnabled();
    }

    public static void enableHeartbeatReceiver() {
        RMIClusterMessageEndPointImpl rMIClusterMessageEndPointImpl = RMIClusterMessageEndPointImpl.getInstance();
        MemberDeathDetectorHeartbeatReceiver memberDeathDetectorHeartbeatReceiver = MemberDeathDetectorHeartbeatReceiver.getInstance();
        rMIClusterMessageEndPointImpl.registerPingMessageListener(memberDeathDetectorHeartbeatReceiver);
        try {
            ServerHelper.exportObject((Remote)rMIClusterMessageEndPointImpl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    private class HeartbeatMonitor
    implements TimerListener {
        private HeartbeatMonitor() {
        }

        public void timerExpired(Timer timer) {
            if (System.currentTimeMillis() > MemberDeathDetectorHeartbeatReceiver.this.lastHeartbeatReceived + MemberDeathDetectorHeartbeatReceiver.this.healthCheckInterval) {
                ProbeContextImpl probeContextImpl = new ProbeContextImpl(MemberDeathDetectorHeartbeatReceiver.this.leader);
                ProbeManager.getClusterMemberProbeManager().invoke(probeContextImpl);
                if (probeContextImpl.getResult() == 1 || probeContextImpl.getResult() == 0) {
                    return;
                }
                MemberDeathDetectorHeartbeatReceiver.fatalError(probeContextImpl.getMessage());
            }
        }
    }

    private static final class SingletonMaker {
        static final MemberDeathDetectorHeartbeatReceiver THE_ONE = new MemberDeathDetectorHeartbeatReceiver();

        private SingletonMaker() {
        }
    }
}

