/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.messaging.internal.BaseClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.MemberDeathDetectorHeartbeatReceiver;
import weblogic.cluster.messaging.internal.MessageDeliveryFailureListener;
import weblogic.cluster.messaging.internal.ProbeContextImpl;
import weblogic.cluster.messaging.internal.ProbeManager;
import weblogic.cluster.messaging.internal.RMIClusterMessageSenderImpl;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;
import weblogic.cluster.messaging.internal.SuspectedMemberInfo;
import weblogic.cluster.messaging.internal.SuspectedMemberInfoImpl;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.MemberDeathDetector;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.collections.ConcurrentHashSet;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class MemberDeathDetectorImpl
implements MemberDeathDetector,
ClusterMembersChangeListener,
PeerGoneListener,
MessageDeliveryFailureListener {
    private static Map members = Collections.synchronizedMap(new LinkedHashMap());
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory debugDisconnectMonitor = Debug.getCategory((String)"weblogic.cluster.leasing.DisconnectMonitor");
    private static final boolean DEBUG = MemberDeathDetectorImpl.debugEnabled();
    private static final String WLS_SERVER_LEASE_TYPE = "wlsserver";
    private static long SUSPECT_TIMEOUT_INTERVAL = 300000L;
    private static long SUSPECTED_MEMBER_MONITOR_INTERVAL = 60000L;
    private SuspectedMemberInfo localServerInfo = new SuspectedMemberInfoImpl(ClusterService.getClusterService().getLocalMember());
    private LeaseManager servicesLeaseManager = ClusterService.getClusterService().getDefaultLeaseManager("service");
    private LeaseManager serverLeaseManager = ClusterService.getClusterService().getDefaultLeaseManager("wlsserver");
    private Timer heartbeatTimerManager;
    private HeartbeatTimer heartbeatTimer;
    private static final Map suspectedMembers = Collections.synchronizedMap(new LinkedHashMap());
    private boolean started = false;
    protected WorkManager workManager = WorkManagerFactory.getInstance().getDefault();
    private static final ClusterMessage HEARTBEAT_REQUEST = new BaseClusterMessage(MemberDeathDetectorImpl.createLocalServerInformation(), 9);
    private static int HEARTBEAT_INTERVAL;
    private static final ConcurrentHashSet pendingProbes;
    private Timer suspectedMemberTimer;

    public static MemberDeathDetectorImpl getInstance() {
        return SingletonMaker.THE_ONE;
    }

    private MemberDeathDetectorImpl() {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        HEARTBEAT_INTERVAL = clusterMBean.getDeathDetectorHeartbeatPeriod() * 1000;
    }

    private String getLocalServerName() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        return serverMBean.getName();
    }

    public void start() {
        Collection collection = ClusterService.getClusterService().getRemoteMembers();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)iterator.next();
            members.put(clusterMemberInfo.serverName(), new SuspectedMemberInfoImpl(clusterMemberInfo));
        }
        if (DEBUG) {
            MemberDeathDetectorImpl.debug(" initial set of members: " + members);
        }
        ClusterMessageFactory.getInstance().registerMessageDeliveryFailureListener(this);
        ClusterService.getClusterService().addClusterMembersListener(this);
        this.heartbeatTimer = new HeartbeatTimer();
        this.heartbeatTimerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this.heartbeatTimer, 0L, (long)HEARTBEAT_INTERVAL);
        this.suspectedMemberTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new SuspectedMemberListMonitor(), SUSPECTED_MEMBER_MONITOR_INTERVAL, SUSPECTED_MEMBER_MONITOR_INTERVAL);
        this.started = true;
    }

    public void stop() {
        if (this.heartbeatTimerManager != null) {
            this.heartbeatTimerManager.cancel();
        }
        if (this.suspectedMemberTimer != null) {
            this.suspectedMemberTimer.cancel();
        }
        this.started = false;
        if (DEBUG) {
            MemberDeathDetectorImpl.debug("Halting Member Death Detector");
        }
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        String string = clusterMembersChangeEvent.getClusterMemberInfo().serverName();
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(string);
        switch (clusterMembersChangeEvent.getAction()) {
            case 0: {
                this.removeSuspect(string);
                members.put(string, new SuspectedMemberInfoImpl(clusterMembersChangeEvent.getClusterMemberInfo()));
                if (!DEBUG) break;
                MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.clusterMembersChanged: Adding member: " + LeaseManager.getOwnerIdentity(clusterMembersChangeEvent.getClusterMemberInfo().identity()));
                break;
            }
            case 1: {
                SuspectedMemberInfo suspectedMemberInfo = (SuspectedMemberInfo)members.remove(string);
                if (suspectedMemberInfo == null || suspectedMembers.containsKey(suspectedMemberInfo.getServerName())) break;
                suspectedMembers.put(suspectedMemberInfo.getServerName(), suspectedMemberInfo);
                suspectedMemberInfo.setSuspectedStartTime(System.currentTimeMillis());
                if (!DEBUG) break;
                MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.clusterMembersChanged: Suspecting member: " + LeaseManager.getOwnerIdentity(suspectedMemberInfo.getServerIdentity()));
                break;
            }
            case 3: {
                if (DEBUG) {
                    MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.clusterMembersChanged: Discover member: " + clusterMembersChangeEvent.getClusterMemberInfo().serverName());
                }
                return;
            }
            case 2: {
                this.removeSuspect(string);
                members.put(string, new SuspectedMemberInfoImpl(clusterMembersChangeEvent.getClusterMemberInfo()));
                if (!DEBUG) break;
                MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.clusterMembersChanged: Update member: " + clusterMembersChangeEvent.getClusterMemberInfo().serverName());
                break;
            }
            default: {
                if (DEBUG) {
                    MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.clusterMembersChanged: Unknown ClusterMembersChangeEvent: " + clusterMembersChangeEvent.getAction() + " for members: " + clusterMembersChangeEvent.getClusterMemberInfo().serverName());
                }
                return;
            }
        }
        if (DEBUG) {
            MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.clusterMembersChanged: members: " + members);
        }
    }

    public void peerGone(PeerGoneEvent peerGoneEvent) {
        if (DEBUG) {
            MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.peerGone event: " + peerGoneEvent);
        }
    }

    static boolean isServerMigratable(String string, ServerMBean serverMBean) {
        if (DEBUG) {
            MemberDeathDetectorImpl.debug("MemberDeathDetectorImpl.isServerDead serverstate for " + serverMBean + " is " + string);
        }
        return string != null && (string.equals("FAILED_NOT_RESTARTABLE") || string.equals("FAILED_MIGRATABLE"));
    }

    private static ServerInformation createLocalServerInformation() {
        return new ServerInformationImpl(ClusterService.getClusterService().getLocalMember());
    }

    public void onMessageDeliveryFailure(String string, RemoteException remoteException) {
        SuspectedMemberInfo suspectedMemberInfo;
        if (DEBUG) {
            MemberDeathDetectorImpl.debug("received onMessageDeliveryFailure for " + string + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)remoteException));
        }
        if ((suspectedMemberInfo = (SuspectedMemberInfo)suspectedMembers.get(string)) == null) {
            if (DEBUG) {
                MemberDeathDetectorImpl.debug(" Suspected member: " + string + " not found! Was probably suspended or shutdown");
            }
            return;
        }
        if (pendingProbes.contains((Object)suspectedMemberInfo)) {
            if (DEBUG) {
                MemberDeathDetectorImpl.debug("There is already a probe pending for " + suspectedMemberInfo);
            }
            return;
        }
        pendingProbes.add((Object)suspectedMemberInfo);
        WorkAdapter workAdapter = new WorkAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProbeContextImpl probeContextImpl = new ProbeContextImpl(suspectedMemberInfo);
                try {
                    ProbeManager.getClusterMasterProbeManager().invoke(probeContextImpl);
                }
                finally {
                    pendingProbes.remove((Object)suspectedMemberInfo);
                }
                if (DEBUG) {
                    MemberDeathDetectorImpl.debug("Probe of server: " + LeaseManager.getOwnerIdentity(suspectedMemberInfo.getServerIdentity()) + " returned result: " + probeContextImpl.getResult());
                }
                if (probeContextImpl.getResult() == 1) {
                    MemberDeathDetectorImpl.this.removeSuspect(probeContextImpl.getSuspectedMemberInfo().getServerName());
                    return;
                }
                if (probeContextImpl.getResult() == 0) {
                    return;
                }
                probeContextImpl = new ProbeContextImpl(MemberDeathDetectorImpl.this.localServerInfo);
                try {
                    if (pendingProbes.contains((Object)MemberDeathDetectorImpl.this.localServerInfo)) {
                        if (DEBUG) {
                            MemberDeathDetectorImpl.debug("There is already a probe pending for " + MemberDeathDetectorImpl.this.localServerInfo);
                        }
                        return;
                    }
                    pendingProbes.add((Object)MemberDeathDetectorImpl.this.localServerInfo);
                    ProbeManager.getClusterMemberProbeManager().invoke(probeContextImpl);
                }
                finally {
                    pendingProbes.remove((Object)MemberDeathDetectorImpl.this.localServerInfo);
                }
                if (DEBUG) {
                    MemberDeathDetectorImpl.debug("Probe of server: " + LeaseManager.getOwnerIdentity(MemberDeathDetectorImpl.this.localServerInfo.getServerIdentity()) + " returned result: " + probeContextImpl.getResult());
                }
                if (probeContextImpl.getResult() == 1 || probeContextImpl.getResult() == 0) {
                    MemberDeathDetectorImpl.this.voidMemberLeases(suspectedMemberInfo);
                    return;
                }
                MemberDeathDetectorHeartbeatReceiver.fatalError(probeContextImpl.getMessage());
            }

            public String toString() {
                return "Invoking probes for: " + LeaseManager.getOwnerIdentity(suspectedMemberInfo.getServerIdentity());
            }
        };
        this.workManager.schedule((Runnable)workAdapter);
    }

    private void voidMemberLeases(SuspectedMemberInfo suspectedMemberInfo) {
        if (DEBUG) {
            MemberDeathDetectorImpl.debug("WorkAdapter removing suspected member: " + suspectedMemberInfo.getServerName());
        }
        this.removeSuspect(suspectedMemberInfo.getServerName());
        String string = LeaseManager.getOwnerIdentity(suspectedMemberInfo.getServerIdentity());
        if (DEBUG) {
            MemberDeathDetectorImpl.debug(" Voiding all its leases with ownerIdentity: " + string);
        }
        if (!suspectedMemberInfo.hasVoidedSingletonServices()) {
            this.servicesLeaseManager.voidLeases(string);
            suspectedMemberInfo.voidedSingletonServices();
        }
        this.serverLeaseManager.voidLeases(string);
    }

    public String removeMember(String string) {
        SuspectedMemberInfo suspectedMemberInfo = (SuspectedMemberInfo)members.remove(string);
        this.removeSuspect(string);
        String string2 = suspectedMemberInfo != null ? suspectedMemberInfo.getServerName() : null;
        return string2;
    }

    SuspectedMemberInfo removeSuspect(String string) {
        SuspectedMemberInfo suspectedMemberInfo = (SuspectedMemberInfo)suspectedMembers.remove(string);
        if (suspectedMemberInfo != null) {
            if (DEBUG) {
                MemberDeathDetectorImpl.debug("removeSuspect suspect: " + LeaseManager.getOwnerIdentity(suspectedMemberInfo.getServerIdentity()));
            }
        } else if (DEBUG) {
            MemberDeathDetectorImpl.debug("removeSuspect attempted to remove suspect: " + string + " but SuspectedMemberInfo not found");
        }
        return suspectedMemberInfo;
    }

    private static void debug(String string) {
        System.out.println("[MemberDeathDetectorImpl] " + string);
    }

    private static boolean debugEnabled() {
        return debugDisconnectMonitor.isEnabled();
    }

    public boolean isStarted() {
        return this.started;
    }

    static {
        pendingProbes = new ConcurrentHashSet();
    }

    private class SuspectedMemberListMonitor
    implements TimerListener {
        private SuspectedMemberListMonitor() {
        }

        public void timerExpired(Timer timer) {
            HashSet hashSet = new HashSet(suspectedMembers.values());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                SuspectedMemberInfo suspectedMemberInfo = (SuspectedMemberInfo)iterator.next();
                if (System.currentTimeMillis() <= suspectedMemberInfo.getSuspectedStartTime() + SUSPECT_TIMEOUT_INTERVAL) continue;
                try {
                    if (DEBUG) {
                        MemberDeathDetectorImpl.debug(suspectedMemberInfo.getServerName() + " has been marked suspect for more than " + SUSPECT_TIMEOUT_INTERVAL / 60000L + " minutes. Removing it from suspect list.");
                    }
                    suspectedMembers.remove(suspectedMemberInfo);
                }
                catch (Exception exception) {
                    if (!DEBUG) continue;
                    exception.printStackTrace();
                }
            }
        }
    }

    private class HeartbeatTimer
    implements TimerListener {
        private final RMIClusterMessageSenderImpl messageSender = (RMIClusterMessageSenderImpl)ClusterMessageFactory.getInstance().getOneWayMessageSender();
        private final String localServerName;

        HeartbeatTimer() {
            this.localServerName = MemberDeathDetectorImpl.this.getLocalServerName();
        }

        public void timerExpired(Timer timer) {
            HashSet hashSet = new HashSet(members.values());
            hashSet.addAll(suspectedMembers.values());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                SuspectedMemberInfo suspectedMemberInfo = null;
                try {
                    suspectedMemberInfo = (SuspectedMemberInfo)iterator.next();
                    if (this.localServerName.equals(suspectedMemberInfo.getServerName())) continue;
                    this.messageSender.send(HEARTBEAT_REQUEST, suspectedMemberInfo.getServerInformation().getServerName(), 1000);
                }
                catch (RemoteException remoteException) {
                    if (DEBUG) {
                        MemberDeathDetectorImpl.debug(remoteException.getMessage());
                    }
                    if (suspectedMemberInfo == null) continue;
                    MemberDeathDetectorImpl.this.onMessageDeliveryFailure(suspectedMemberInfo.getServerInformation().getServerName(), remoteException);
                }
            }
        }
    }

    private static final class SingletonMaker {
        static final MemberDeathDetectorImpl THE_ONE = new MemberDeathDetectorImpl();

        private SingletonMaker() {
        }
    }
}

