/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.Message;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;

final class MessageImpl
implements Message,
Externalizable {
    private byte[] data;
    private String serverName;
    private long startTime;
    private long id;
    private String version;
    private ServerConfigurationInformation configuration;
    private transient ServerConfigurationInformation forwardConfiguration;

    MessageImpl(byte[] byArray, String string, long l, long l2) {
        this.data = byArray;
        this.serverName = string;
        this.startTime = l;
        this.id = l2;
        this.version = "9.5";
        this.configuration = Environment.getConfiguredServersMonitor().getConfiguration(string);
    }

    public String getVersion() {
        return this.version;
    }

    public String getServerName() {
        return this.serverName;
    }

    public long getServerStartTime() {
        return this.startTime;
    }

    public byte[] getData() {
        return this.data;
    }

    public ServerConfigurationInformation getSenderConfiguration() {
        return this.configuration;
    }

    public ServerConfigurationInformation getForwardingServer() {
        return this.forwardConfiguration;
    }

    public String toString() {
        return " server " + this.serverName + ", id=" + this.id;
    }

    public MessageImpl() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF("9.5");
        objectOutput.writeInt(this.data.length);
        objectOutput.write(this.data);
        objectOutput.writeUTF(this.serverName);
        objectOutput.writeObject(this.configuration);
        objectOutput.writeObject(Environment.getGroupManager().getServerConfigForWire());
        objectOutput.writeLong(this.startTime);
        objectOutput.writeLong(this.id);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.version = objectInput.readUTF();
        int n = objectInput.readInt();
        this.data = new byte[n];
        objectInput.readFully(this.data);
        this.serverName = objectInput.readUTF();
        try {
            this.configuration = (ServerConfigurationInformation)objectInput.readObject();
            this.forwardConfiguration = (ServerConfigurationInformation)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        this.startTime = objectInput.readLong();
        this.id = objectInput.readLong();
    }
}

