/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import java.security.AccessController;
import weblogic.cluster.messaging.internal.MemberDeathDetectorImpl;
import weblogic.cluster.messaging.internal.Probe;
import weblogic.cluster.messaging.internal.ProbeContext;
import weblogic.cluster.singleton.SingletonMonitor;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class NMManagementInterfaceQueryProbe
implements Probe {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void invoke(ProbeContext probeContext) {
        if (!ManagementService.getRuntimeAccess(kernelId).getDomain().isExalogicOptimizationsEnabled()) {
            return;
        }
        NMManagementInterfaceQueryProbe.debug("probe server: " + probeContext.getSuspectedMemberInfo().getServerName());
        NetworkAccessPointMBean networkAccessPointMBean = null;
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(probeContext.getSuspectedMemberInfo().getServerName());
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            if (!"management-interface".equals(networkAccessPointMBeanArray[i].getName())) continue;
            networkAccessPointMBean = networkAccessPointMBeanArray[i];
            break;
        }
        if (networkAccessPointMBean == null) {
            return;
        }
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(networkAccessPointMBean.getListenAddress(), serverMBean.getMachine().getNodeManager().getListenPort(), "ssl");
        String string = null;
        try {
            string = nodeManagerRuntime.getState(serverMBean);
        }
        catch (IOException iOException) {
            probeContext.setNextAction(1);
            probeContext.setResult(-1);
            return;
        }
        NMManagementInterfaceQueryProbe.debug("runtime state: " + string + " for server: " + serverMBean.getName());
        MemberDeathDetectorImpl.getInstance();
        if (MemberDeathDetectorImpl.isServerMigratable(string, serverMBean) && SingletonMonitor.canMigrateLease(string)) {
            NMManagementInterfaceQueryProbe.debug(serverMBean + " is marked as " + string + ". Voiding all its leases");
            probeContext.setNextAction(0);
            probeContext.setResult(-1);
            return;
        }
        probeContext.setNextAction(0);
        probeContext.setResult(1);
    }

    private static void debug(String string) {
        System.out.println("[NMManagementInterfaceQueryProbe] " + string);
    }
}

