/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import java.security.AccessController;
import weblogic.cluster.ClusterService;
import weblogic.cluster.messaging.internal.MemberDeathDetectorImpl;
import weblogic.cluster.messaging.internal.Probe;
import weblogic.cluster.messaging.internal.ProbeContext;
import weblogic.cluster.messaging.internal.SuspectedMemberInfo;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.SingletonMonitor;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class NodeManagerQueryProbe
implements Probe {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory debugDisconnectMonitor = Debug.getCategory((String)"weblogic.cluster.leasing.DisconnectMonitor");
    private static final boolean DEBUG = NodeManagerQueryProbe.debugEnabled();

    public void invoke(ProbeContext probeContext) {
        SuspectedMemberInfo suspectedMemberInfo = probeContext.getSuspectedMemberInfo();
        if (DEBUG) {
            NodeManagerQueryProbe.debug("NodeManagerQueryProbe of server: " + suspectedMemberInfo.getServerName());
        }
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(probeContext.getSuspectedMemberInfo().getServerName());
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(serverMBean);
        String string = "UNKNOWN";
        try {
            string = nodeManagerRuntime.getState(serverMBean);
        }
        catch (IOException iOException) {
            probeContext.setNextAction(1);
            probeContext.setResult(-1);
            return;
        }
        if (DEBUG) {
            NodeManagerQueryProbe.debug("NodeManagerQueryProbe runtime state: " + string + " for server: " + serverMBean.getName());
        }
        if (!suspectedMemberInfo.hasVoidedSingletonServices() && SingletonMonitor.canMigrateLease(string)) {
            LeaseManager leaseManager = ClusterService.getClusterService().getDefaultLeaseManager("service");
            String string2 = LeaseManager.getOwnerIdentity(suspectedMemberInfo.getServerIdentity());
            leaseManager.voidLeases(string2);
            if (DEBUG) {
                NodeManagerQueryProbe.debug("NodeManagerQueryProbe " + string2 + " is marked as " + string + ". Voiding all its singleton services leases");
            }
            suspectedMemberInfo.voidedSingletonServices();
        }
        if (MemberDeathDetectorImpl.isServerMigratable(string, serverMBean)) {
            if (DEBUG) {
                NodeManagerQueryProbe.debug("NodeManagerQueryProbe " + serverMBean + " is marked as " + string + ". Voiding all its leases");
            }
            probeContext.setNextAction(0);
            probeContext.setResult(-1);
            return;
        }
        probeContext.setNextAction(0);
        probeContext.setResult(0);
    }

    private static void debug(String string) {
        System.out.println("[NodeManagerQueryProbe] " + string);
    }

    private static boolean debugEnabled() {
        return debugDisconnectMonitor.isEnabled();
    }
}

