/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.util.Iterator;
import java.util.LinkedList;
import weblogic.cluster.messaging.internal.HttpPingProbe;
import weblogic.cluster.messaging.internal.LeaseTableReachabilityProbe;
import weblogic.cluster.messaging.internal.NodeManagerQueryProbe;
import weblogic.cluster.messaging.internal.Probe;
import weblogic.cluster.messaging.internal.ProbeContext;

public final class ProbeManager {
    private LinkedList list = new LinkedList();
    private static ProbeManager clusterMasterProbeManager;
    private static ProbeManager clusterMemberProbeManager;

    public static ProbeManager getClusterMasterProbeManager() {
        if (clusterMasterProbeManager == null) {
            clusterMasterProbeManager = new ProbeManager();
            clusterMasterProbeManager.add(new HttpPingProbe());
            clusterMasterProbeManager.add(new NodeManagerQueryProbe());
        }
        return clusterMasterProbeManager;
    }

    public static ProbeManager getClusterMemberProbeManager() {
        if (clusterMemberProbeManager == null) {
            clusterMemberProbeManager = new ProbeManager();
            clusterMemberProbeManager.add(new LeaseTableReachabilityProbe());
        }
        return clusterMemberProbeManager;
    }

    protected ProbeManager() {
    }

    public synchronized void add(Probe probe) {
        this.list.add(probe);
    }

    public synchronized Probe remove(Probe probe) {
        int n = this.list.indexOf(probe);
        return (Probe)this.list.remove(n);
    }

    synchronized LinkedList getProbes() {
        return new LinkedList(this.list);
    }

    public synchronized void invoke(ProbeContext probeContext) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Probe probe = (Probe)iterator.next();
            probe.invoke(probeContext);
            if (probeContext.getNextAction() == 1) continue;
        }
    }
}

