/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageEndPoint;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.ClusterMessageReceiver;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.PingMessageListener;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public class RMIClusterMessageEndPointImpl
implements ClusterMessageEndPoint {
    private static final DebugCategory debugMessageEndPoint = Debug.getCategory((String)"weblogic.cluster.leasing.MessageEndPoint");
    private static final boolean DEBUG = RMIClusterMessageEndPointImpl.debugEnabled();
    private PingMessageListener listener;

    public ClusterResponse process(ClusterMessage clusterMessage) throws ClusterMessageProcessingException {
        if (clusterMessage.getMessageType() == 9) {
            if (DEBUG) {
                RMIClusterMessageEndPointImpl.debug("received PING from " + clusterMessage.getSenderInformation());
            }
            this.invokeListener(clusterMessage.getSenderInformation());
            return null;
        }
        ClusterMessageReceiver clusterMessageReceiver = ClusterMessageFactory.getInstance().getMessageReceiver(clusterMessage);
        if (DEBUG) {
            RMIClusterMessageEndPointImpl.debug("dispatching " + clusterMessage + " to " + clusterMessageReceiver);
        }
        if (clusterMessageReceiver == null) {
            throw new ClusterMessageProcessingException("leasing is not ready!");
        }
        return clusterMessageReceiver.process(clusterMessage);
    }

    public void processOneWay(ClusterMessage clusterMessage) throws ClusterMessageProcessingException {
        if (clusterMessage.getMessageType() == 9) {
            if (DEBUG) {
                RMIClusterMessageEndPointImpl.debug("received PING ONE_WAY from " + clusterMessage.getSenderInformation());
            }
            this.invokeListener(clusterMessage.getSenderInformation());
            return;
        }
        ClusterMessageReceiver clusterMessageReceiver = ClusterMessageFactory.getInstance().getMessageReceiver(clusterMessage);
        if (DEBUG) {
            RMIClusterMessageEndPointImpl.debug("dispatching ONE_WAY " + clusterMessage + " to " + clusterMessageReceiver);
        }
        if (clusterMessageReceiver == null) {
            throw new ClusterMessageProcessingException("leasing is not ready!");
        }
        clusterMessageReceiver.process(clusterMessage);
    }

    private static void debug(String string) {
        DebugLogger.debug("[RMIClusterMessageEndPointImpl] " + string);
    }

    public static RMIClusterMessageEndPointImpl getInstance() {
        return Singleton.SINGLETON;
    }

    private static boolean debugEnabled() {
        return true;
    }

    public void registerPingMessageListener(PingMessageListener pingMessageListener) {
        this.listener = pingMessageListener;
    }

    private void invokeListener(final ServerInformation serverInformation) {
        RMIClusterMessageEndPointImpl.debug("invoking listener: " + this.listener + " for sender: " + serverInformation.getServerName());
        if (this.listener != null) {
            final PingMessageListener pingMessageListener = this.listener;
            WorkAdapter workAdapter = new WorkAdapter(){

                public void run() {
                    RMIClusterMessageEndPointImpl.debug(this.toString());
                    pingMessageListener.pingReceived(serverInformation);
                }

                public String toString() {
                    return pingMessageListener + ": Work Adapter ping Received from " + serverInformation.getServerName();
                }
            };
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)workAdapter);
        }
    }

    private static class Singleton {
        private static final RMIClusterMessageEndPointImpl SINGLETON = new RMIClusterMessageEndPointImpl();

        private Singleton() {
        }
    }
}

