/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingException;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageEndPoint;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.RMIClusterMessageEndPointImpl;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.jndi.Environment;
import weblogic.management.configuration.DatabaseLessLeasingBasisMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.collections.ConcurrentHashMap;

public class RMIClusterMessageSenderImpl
implements ClusterMessageSender {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory debugMessageSender = Debug.getCategory((String)"weblogic.cluster.leasing.MessageSender");
    private static final boolean DEBUG = RMIClusterMessageSenderImpl.debugEnabled();
    private static final ConcurrentHashMap serverNameToURL = new ConcurrentHashMap();
    private boolean isOneWay;

    private void setOneWay(boolean bl) {
        this.isOneWay = bl;
    }

    public static RMIClusterMessageSenderImpl getInstance() {
        return Factory.SEND_RECV;
    }

    public static RMIClusterMessageSenderImpl getOneWay() {
        return Factory.ONE_WAY;
    }

    public ClusterResponse[] send(ClusterMessage clusterMessage, ServerInformation[] serverInformationArray) throws ClusterMessageProcessingException {
        ClusterResponse[] clusterResponseArray = new ClusterResponse[serverInformationArray.length];
        HashMap<ServerInformation, RemoteException> hashMap = new HashMap<ServerInformation, RemoteException>();
        for (int i = 0; i < serverInformationArray.length; ++i) {
            try {
                clusterResponseArray[i] = this.send(clusterMessage, serverInformationArray[i]);
                continue;
            }
            catch (RemoteException remoteException) {
                hashMap.put(serverInformationArray[i], remoteException);
            }
        }
        if (hashMap.size() > 0) {
            throw new ClusterMessageProcessingException(clusterResponseArray, hashMap);
        }
        return clusterResponseArray;
    }

    public ClusterResponse send(ClusterMessage clusterMessage, ServerInformation serverInformation) throws RemoteException {
        return this.send(clusterMessage, serverInformation.getServerName());
    }

    public ClusterResponse send(ClusterMessage clusterMessage, String string) throws RemoteException {
        return this.send(clusterMessage, string, -1);
    }

    public ClusterResponse send(ClusterMessage clusterMessage, String string, int n) throws RemoteException {
        ClusterMessageEndPoint clusterMessageEndPoint;
        if (DEBUG) {
            RMIClusterMessageSenderImpl.debug("trying to send message " + clusterMessage + " to " + string);
        }
        if ((clusterMessageEndPoint = n < 0 ? this.getRMIMessageEndPoint(string) : this.getRMIMessageEndPoint(string, n)) == null) {
            throw new ClusterMessageProcessingException("MessageEndPoint not available for " + string + ". The server is probably dead");
        }
        try {
            if (DEBUG) {
                RMIClusterMessageSenderImpl.debug(Thread.currentThread() + ": receiver found for " + string);
            }
            if (this.isOneWay) {
                clusterMessageEndPoint.processOneWay(clusterMessage);
                return null;
            }
            ClusterResponse clusterResponse = clusterMessageEndPoint.process(clusterMessage);
            if (DEBUG) {
                RMIClusterMessageSenderImpl.debug("response received for " + string + ". Response = " + clusterResponse);
            }
            return clusterResponse;
        }
        catch (RemoteException remoteException) {
            if (DEBUG) {
                RMIClusterMessageSenderImpl.debug("exception processing message for " + string);
            }
            if (DEBUG) {
                remoteException.printStackTrace();
            }
            throw remoteException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            if (DEBUG) {
                RMIClusterMessageSenderImpl.debug("remote runtime exception processing message for " + string);
            }
            if (DEBUG) {
                remoteRuntimeException.printStackTrace();
            }
            throw new RemoteException("RMI stub threw a sender side exception ", remoteRuntimeException);
        }
    }

    private static void debug(String string) {
        DebugLogger.debug("[RMIClusterMessageSender] " + string);
    }

    private ClusterMessageEndPoint getRMIMessageEndPoint(String string) throws RemoteException {
        DatabaseLessLeasingBasisMBean databaseLessLeasingBasisMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getDatabaseLessLeasingBasis();
        int n = databaseLessLeasingBasisMBean.getMessageDeliveryTimeout();
        return this.getRMIMessageEndPoint(string, n);
    }

    private ClusterMessageEndPoint getRMIMessageEndPoint(String string, int n) throws RemoteException {
        try {
            Environment environment = new Environment(new Hashtable());
            environment.setRequestTimeout(n);
            environment.setProviderUrl(RMIClusterMessageSenderImpl.getURL(string));
            ClusterMessageEndPoint clusterMessageEndPoint = (ClusterMessageEndPoint)PortableRemoteObject.narrow((Object)environment.getInitialReference(RMIClusterMessageEndPointImpl.class), (Class)ClusterMessageEndPoint.class);
            return clusterMessageEndPoint;
        }
        catch (UnknownHostException unknownHostException) {
            if (DEBUG) {
                unknownHostException.printStackTrace();
            }
            throw unknownHostException;
        }
        catch (NamingException namingException) {
            if (DEBUG) {
                namingException.printStackTrace();
            }
            return null;
        }
    }

    private static String getURL(String string) throws UnknownHostException {
        try {
            String string2 = URLManager.findAdministrationURL(string);
            serverNameToURL.put((Object)string, (Object)string2);
            return string2;
        }
        catch (UnknownHostException unknownHostException) {
            String string3 = (String)serverNameToURL.get((Object)string);
            if (string3 != null) {
                return string3;
            }
            throw unknownHostException;
        }
    }

    private static boolean debugEnabled() {
        return debugMessageSender.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static final class Factory {
        static final RMIClusterMessageSenderImpl SEND_RECV = new RMIClusterMessageSenderImpl();
        static final RMIClusterMessageSenderImpl ONE_WAY = new RMIClusterMessageSenderImpl();

        private Factory() {
        }

        static {
            Factory.ONE_WAY.setOneWay(true);
        }
    }
}

