/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.util.Set;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.GroupImpl;
import weblogic.cluster.messaging.internal.GroupMember;
import weblogic.cluster.messaging.internal.GroupMemberImpl;
import weblogic.cluster.messaging.internal.Message;
import weblogic.cluster.messaging.internal.PingRoutine;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;

final class RemoteGroupImpl
extends GroupImpl {
    public RemoteGroupImpl(Set set) {
        super(set);
    }

    public void start() {
        if (DEBUG) {
            this.debug("starting remote group timer for " + this);
        }
        this.handle = Environment.startTimer(new RemoteGroupMonitor(), 0, Environment.getPropertyService().getDiscoveryPeriodMillis());
    }

    public void send(Message message) {
        GroupMember[] groupMemberArray = this.getMembers();
        if (groupMemberArray.length == 0) {
            if (DEBUG) {
                this.debug("no server in remote group is alive!");
            }
            this.startDiscoveryIfNeeded();
        } else {
            GroupMember groupMember = groupMemberArray[0];
            this.sendToLeader(groupMember, message);
        }
    }

    protected void performLeaderActions(Message message) {
        throw new AssertionError((Object)"local server can never perform leader actions on a remote group !");
    }

    public void forward(Message message, Connection connection) {
        throw new AssertionError((Object)"forward cannot be called on remote groups !");
    }

    protected synchronized void startDiscoveryIfNeeded() {
        if (this.handle != null) {
            return;
        }
        if (this.members.size() == 0) {
            this.handle = Environment.startTimer(new RemoteGroupMonitor(), 0, Environment.getPropertyService().getDiscoveryPeriodMillis());
        }
    }

    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return "RemoteGroup [" + this.members + "]";
    }

    private class RemoteGroupMonitor
    implements Runnable {
        private RemoteGroupMonitor() {
        }

        public void run() {
            ServerConfigurationInformation[] serverConfigurationInformationArray = RemoteGroupImpl.this.getConfigurations();
            if (serverConfigurationInformationArray == null || serverConfigurationInformationArray.length == 0) {
                return;
            }
            for (int i = 0; i < serverConfigurationInformationArray.length; ++i) {
                PingRoutine pingRoutine = Environment.getPingRoutine();
                long l = pingRoutine.ping(serverConfigurationInformationArray[i]);
                if (l <= 0L) continue;
                if (GroupImpl.DEBUG) {
                    RemoteGroupImpl.this.debug("discovered " + serverConfigurationInformationArray[i]);
                }
                GroupMemberImpl groupMemberImpl = new GroupMemberImpl(serverConfigurationInformationArray[i], l);
                RemoteGroupImpl.this.addToRunningSet(groupMemberImpl);
            }
            if (RemoteGroupImpl.this.members.size() > 0) {
                if (RemoteGroupImpl.this.handle != null) {
                    Environment.stopTimer(RemoteGroupImpl.this.handle);
                }
                RemoteGroupImpl.this.handle = null;
                if (GroupImpl.DEBUG) {
                    RemoteGroupImpl.this.debug("stopping timer!");
                }
            }
        }
    }
}

