/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.SRMResult;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.collections.ConcurrentHashMap;

public class SRMResultImpl
implements SRMResult {
    private static final AuthenticatedSubject kernelId;
    private static final DebugCategory debugSRMResult;
    private static final boolean DEBUG;
    private final HashMap serverStates;
    private final String leaderName;
    private int reachabilityCount;
    private final int expectedCount;
    private int machinesExpectedToReportStates;
    private final HashSet machinesReportingState = new HashSet();
    private ConcurrentHashMap serverMachineNameMap = new ConcurrentHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    SRMResultImpl() {
        this.leaderName = null;
        this.serverStates = new HashMap();
        this.reachabilityCount = 0;
        this.expectedCount = Integer.MAX_VALUE;
    }

    public SRMResultImpl(ServerInformation serverInformation, int n) {
        this.leaderName = serverInformation != null ? serverInformation.getServerName() : null;
        this.serverStates = new HashMap();
        this.reachabilityCount = 0;
        this.expectedCount = n;
    }

    public boolean hasReachabilityMajority() {
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        if ("UNKNOWN".equals(this.serverStates.get(string))) {
            if (DEBUG) {
                SRMResultImpl.debug("local server state is UNKNOWN ! Local NodeManager is not reporting correct state?!");
            }
            return false;
        }
        if (DEBUG) {
            SRMResultImpl.debug("hasReachabilityMajority called. reachabilityCount=" + this.reachabilityCount + ", server states=" + this.serverStates.size());
        }
        if (2 * this.reachabilityCount > this.serverStates.size()) {
            if (DEBUG) {
                SRMResultImpl.debug("hasReachabilityMajority returns true as majority is reachable");
            }
            return true;
        }
        if (2 * this.reachabilityCount == this.serverStates.size() && this.leaderName != null && this.serverStates.get(this.leaderName) != null) {
            if (DEBUG) {
                SRMResultImpl.debug("hasReachabilityMajority returns true as half the servers are reachable along with the leader");
            }
            return true;
        }
        if (DEBUG) {
            SRMResultImpl.debug("hasReachabilityMajority returns FALSE !");
        }
        return false;
    }

    private static void debug(String string) {
        DebugLogger.debug("[SRMResult] " + string);
    }

    public String getServerState(String string) {
        return (String)this.serverStates.get(string);
    }

    public String getCurrentMachine(String string) {
        return (String)this.serverMachineNameMap.get((Object)string);
    }

    public synchronized void blockTillCompletion() {
        if (!$assertionsDisabled && this.expectedCount == Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        while (this.serverStates.size() < this.expectedCount || this.machinesReportingState.size() < this.machinesExpectedToReportStates) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void doneReporting(String string) {
        this.machinesReportingState.add(string);
        if (this.serverStates.size() == this.expectedCount && this.machinesReportingState.size() == this.machinesExpectedToReportStates) {
            Iterator iterator = this.serverStates.values().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2 == null) continue;
                ++this.reachabilityCount;
            }
            this.notify();
        }
    }

    public synchronized void setServerState(String string, String string2, String string3) {
        String string4 = (String)this.serverStates.get(string);
        if (!SRMResultImpl.acceptState(string4, string3)) {
            return;
        }
        this.serverStates.put(string, string3);
        this.serverMachineNameMap.put((Object)string, (Object)string2);
        if (!$assertionsDisabled && this.serverStates.size() > this.expectedCount) {
            throw new AssertionError();
        }
    }

    private static boolean acceptState(String string, String string2) {
        if (string == null || "UNKNOWN".equals(string)) {
            return true;
        }
        return string2 != null && !"UNKNOWN".equals(string2) && !"FAILED_NOT_RESTARTABLE".equals(string2);
    }

    public String toString() {
        return "SRMResult [" + this.serverStates + "]";
    }

    private static boolean debugEnabled() {
        return debugSRMResult.isEnabled() || DebugLogger.isDebugEnabled();
    }

    public void setMachinesExpectedToReportStates(int n) {
        this.machinesExpectedToReportStates = n;
    }

    public List getServersInState(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.serverStates == null) {
            return arrayList;
        }
        Iterator iterator = this.serverStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getValue();
            if (string2 == null || !string2.equals(string)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    static {
        $assertionsDisabled = !SRMResultImpl.class.desiredAssertionStatus();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        debugSRMResult = Debug.getCategory((String)"weblogic.cluster.leasing.SRMResult");
        DEBUG = SRMResultImpl.debugEnabled();
    }
}

