/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.net.InetAddress;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;

public final class ServerConfigurationInformationImpl
implements ServerConfigurationInformation {
    private static final long serialVersionUID = -7511929101139272497L;
    private static final boolean DEBUG;
    private final InetAddress address;
    private final int port;
    private final String serverName;
    private final long creationTime;
    private final boolean usingSSL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServerConfigurationInformationImpl(InetAddress inetAddress, int n, String string, long l) {
        this(inetAddress, n, string, l, false);
    }

    public ServerConfigurationInformationImpl(InetAddress inetAddress, int n, String string, long l, boolean bl) {
        this.address = inetAddress;
        this.port = n;
        this.serverName = string;
        this.creationTime = l;
        this.usingSSL = bl;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getServerName() {
        return this.serverName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean isUsingSSL() {
        return this.usingSSL;
    }

    public int compareTo(Object object) {
        if (!$assertionsDisabled && !(object instanceof ServerConfigurationInformationImpl)) {
            throw new AssertionError();
        }
        ServerConfigurationInformationImpl serverConfigurationInformationImpl = (ServerConfigurationInformationImpl)object;
        int n = (int)(this.creationTime - serverConfigurationInformationImpl.creationTime);
        if (n != 0) {
            return n;
        }
        return this.serverName.compareTo(serverConfigurationInformationImpl.serverName);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ServerConfigurationInformationImpl)) {
            return false;
        }
        ServerConfigurationInformationImpl serverConfigurationInformationImpl = (ServerConfigurationInformationImpl)object;
        return this.serverName.equals(serverConfigurationInformationImpl.serverName);
    }

    public int hashCode() {
        return (int)((long)this.serverName.hashCode() ^ this.creationTime);
    }

    public String toString() {
        return this.address + ":" + this.port + (this.usingSSL ? "(SSL):" : ":") + this.serverName + ":" + this.creationTime;
    }

    static {
        $assertionsDisabled = !ServerConfigurationInformationImpl.class.desiredAssertionStatus();
        DEBUG = Environment.DEBUG;
    }
}

