/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.security.AccessController;
import weblogic.cluster.messaging.internal.Probe;
import weblogic.cluster.messaging.internal.ProbeContext;
import weblogic.cluster.messaging.internal.SRMResult;
import weblogic.cluster.messaging.internal.ServerReachabilityMajorityService;
import weblogic.cluster.messaging.internal.ServerReachabilityMajorityServiceImpl;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class ServerReachabilityMajorityProbe
implements Probe {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory debugDisconnectMonitor = Debug.getCategory((String)"weblogic.cluster.leasing.DisconnectMonitor");
    private static final boolean DEBUG = ServerReachabilityMajorityProbe.debugEnabled();

    public void invoke(ProbeContext probeContext) {
        String string;
        ServerReachabilityMajorityService serverReachabilityMajorityService;
        SRMResult sRMResult;
        if (DEBUG) {
            ServerReachabilityMajorityProbe.debug("check ServerReachabilityMajority");
        }
        if (!(sRMResult = (serverReachabilityMajorityService = ServerReachabilityMajorityServiceImpl.getInstance()).performSRMCheck(null, string = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getName())).hasReachabilityMajority()) {
            String string2 = "Server is not in the majority cluster partition";
            probeContext.setMessage(string2);
            probeContext.setNextAction(0);
            probeContext.setResult(-1);
            return;
        }
        probeContext.setNextAction(1);
        probeContext.setResult(1);
    }

    private static boolean debugEnabled() {
        return debugDisconnectMonitor.isEnabled();
    }

    private static void debug(String string) {
        System.out.println("[ServerReachabilityMajorityProbe] " + string);
    }
}

