/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.MachineState;
import weblogic.cluster.messaging.internal.SRMResult;
import weblogic.cluster.messaging.internal.SRMResultImpl;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerReachabilityMajorityService;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.WorkManagerFactory;

public class ServerReachabilityMajorityServiceImpl
implements ServerReachabilityMajorityService {
    private static final DebugCategory debugSRM;
    private static final boolean DEBUG;
    private SRMResult lastResult;
    private static final AuthenticatedSubject kernelId;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SRMResult performSRMCheck(ServerInformation serverInformation, String string, String string2, boolean bl) {
        Object object;
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupCluster(string);
        if (!$assertionsDisabled && clusterMBean == null) {
            throw new AssertionError();
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        if (!$assertionsDisabled && serverMBeanArray == null) {
            throw new AssertionError();
        }
        if (DEBUG) {
            ServerReachabilityMajorityServiceImpl.debug("There are " + serverMBeanArray.length + " in the cluster");
        }
        SRMResultImpl sRMResultImpl = new SRMResultImpl(serverInformation, serverMBeanArray.length);
        HashMap<String, MachineState> hashMap = new HashMap<String, MachineState>();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            object = serverMBeanArray[i].getMachine();
            MachineState machineState = (MachineState)hashMap.get(object.getName());
            if (machineState != null) continue;
            if (DEBUG) {
                ServerReachabilityMajorityServiceImpl.debug("created new MachineState for " + object.getName());
            }
            machineState = new MachineState((MachineMBean)object, sRMResultImpl, bl);
            hashMap.put(object.getName(), machineState);
        }
        sRMResultImpl.setMachinesExpectedToReportStates(hashMap.size());
        if (DEBUG) {
            ServerReachabilityMajorityServiceImpl.debug("machine state map has " + hashMap.size() + " entries");
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object = (MachineState)iterator.next();
            if (((MachineState)object).getMachineName().equals(string2)) {
                ((MachineState)object).nullifyStates();
            }
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)object);
        }
        sRMResultImpl.blockTillCompletion();
        this.lastResult = sRMResultImpl;
        return sRMResultImpl;
    }

    public SRMResult getLastSRMResult() {
        return this.lastResult;
    }

    public SRMResult performSRMCheck(ServerInformation serverInformation, String string) {
        return this.performSRMCheck(serverInformation, string, null, true);
    }

    public SRMResult performSRMCheck(ServerInformation serverInformation, String string, String string2) {
        return this.performSRMCheck(serverInformation, string, string2, true);
    }

    private static void debug(String string) {
        DebugLogger.debug("[SRMService] " + string);
    }

    public static ServerReachabilityMajorityService getInstance() {
        return Factory.THE_ONE;
    }

    private static boolean debugEnabled() {
        return debugSRM.isEnabled() || DebugLogger.isDebugEnabled();
    }

    static {
        $assertionsDisabled = !ServerReachabilityMajorityServiceImpl.class.desiredAssertionStatus();
        debugSRM = Debug.getCategory((String)"weblogic.cluster.leasing.SRMService");
        DEBUG = ServerReachabilityMajorityServiceImpl.debugEnabled();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static final class Factory {
        static final ServerReachabilityMajorityServiceImpl THE_ONE = new ServerReachabilityMajorityServiceImpl();

        private Factory() {
        }
    }
}

