/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import weblogic.cluster.messaging.internal.ConfiguredServersMonitor;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;
import weblogic.cluster.messaging.internal.ServerConfigurationInformationImpl;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ConfiguredServersMonitorImpl
implements ConfiguredServersMonitor {
    private static final boolean DEBUG = Environment.DEBUG;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final ServerConfigurationInformation localInfo;
    private final TreeSet servers = new TreeSet();

    public static ConfiguredServersMonitor getInstance() {
        return Factory.THE_ONE;
    }

    private ConfiguredServersMonitorImpl() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.localInfo = this.createConfiguration(serverMBean);
        if (DEBUG) {
            this.debug("localInfo=" + this.localInfo);
        }
        ClusterMBean clusterMBean = serverMBean.getCluster();
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            ServerConfigurationInformation serverConfigurationInformation = this.createConfiguration(serverMBeanArray[i]);
            if (DEBUG) {
                this.debug("created " + serverConfigurationInformation);
            }
            this.servers.add(serverConfigurationInformation);
        }
    }

    private void debug(String string) {
        Environment.getLogService().debug("[ConfiguredServersMonitor] " + string);
    }

    private ServerConfigurationInformation createConfiguration(ServerMBean serverMBean) {
        InetAddress inetAddress;
        ConfigurationMBean configurationMBean;
        ConfigurationMBean configurationMBean2;
        String string;
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        if (networkAccessPointMBeanArray != null) {
            for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
                InetAddress inetAddress2;
                if (!networkAccessPointMBeanArray[i].getName().equals(serverMBean.getCluster().getClusterBroadcastChannel())) continue;
                try {
                    inetAddress2 = InetAddress.getByName(networkAccessPointMBeanArray[i].getListenAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    throw new AssertionError((Object)unknownHostException);
                }
                if (DEBUG) {
                    this.debug("obtained NAP [" + inetAddress2 + ":" + networkAccessPointMBeanArray[i].getListenPort() + "] for " + serverMBean.getName());
                }
                return new ServerConfigurationInformationImpl(inetAddress2, networkAccessPointMBeanArray[i].getListenPort(), serverMBean.getName(), 1L, ChannelHelper.isNAPSecure(networkAccessPointMBeanArray[i]));
            }
        }
        if (((string = serverMBean.getListenAddress()) == null || string.length() == 0) && (configurationMBean2 = serverMBean.getMachine()) != null && (configurationMBean = configurationMBean2.getNodeManager()) != null) {
            string = configurationMBean.getListenAddress();
        }
        try {
            inetAddress = string != null ? InetAddress.getByName(string) : InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)unknownHostException);
        }
        configurationMBean2 = ManagementService.getRuntimeAccess(kernelId).getServer();
        if (serverMBean.isListenPortEnabled() && configurationMBean2.isListenPortEnabled()) {
            return new ServerConfigurationInformationImpl(inetAddress, serverMBean.getListenPort(), serverMBean.getName(), 1L, false);
        }
        configurationMBean = serverMBean.getSSL();
        if (configurationMBean.isListenPortEnabled() && configurationMBean2.getSSL().isListenPortEnabled()) {
            return new ServerConfigurationInformationImpl(inetAddress, configurationMBean.getListenPort(), serverMBean.getName(), 1L, true);
        }
        throw new AssertionError((Object)"Servers do not have a common channel to communicate over");
    }

    public ServerConfigurationInformation getLocalServerConfiguration() {
        return this.localInfo;
    }

    public SortedSet getConfiguredServers() {
        return this.servers;
    }

    public ServerConfigurationInformation getConfiguration(String string) {
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            ServerConfigurationInformation serverConfigurationInformation = (ServerConfigurationInformation)iterator.next();
            if (!serverConfigurationInformation.getServerName().equals(string)) continue;
            return serverConfigurationInformation;
        }
        return null;
    }

    private static final class Factory {
        static final ConfiguredServersMonitor THE_ONE = new ConfiguredServersMonitorImpl();

        private Factory() {
        }
    }
}

