/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal.server;

import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import javax.net.ssl.SSLSocket;
import weblogic.cluster.messaging.internal.AbstractConnectionManager;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.ConnectionImpl;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;
import weblogic.cluster.messaging.internal.server.SSLConnectionImpl;
import weblogic.cluster.messaging.protocol.MuxableSocketClusterBroadcast;
import weblogic.cluster.messaging.protocol.MuxableSocketClusterBroadcastS;
import weblogic.cluster.messaging.protocol.ProtocolHandlerClusterBroadcast;
import weblogic.cluster.messaging.protocol.ProtocolHandlerClusterBroadcastS;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ConnectionManagerImpl
extends AbstractConnectionManager {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = Environment.DEBUG;

    public static ConnectionManagerImpl getInstance() {
        return Factory.THE_ONE;
    }

    private ConnectionManagerImpl() {
    }

    public Connection createConnection(ServerConfigurationInformation serverConfigurationInformation) throws IOException {
        MuxableSocketClusterBroadcast muxableSocketClusterBroadcast;
        ConnectionImpl connectionImpl;
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        String string = serverMBean.getCluster().getClusterBroadcastChannel();
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        ServerChannel serverChannel = string != null ? ServerChannelManager.findOutboundServerChannel((String)string) : (!serverConfigurationInformation.isUsingSSL() ? ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerClusterBroadcast.PROTOCOL_CLUSTER) : ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerClusterBroadcastS.PROTOCOL_CLUSTER_SECURE));
        if (DEBUG) {
            this.debug("trying to create connection using outbound channel " + serverChannel);
        }
        if (serverChannel == null) {
            throw new IOException("Channel not yet bound!");
        }
        if (serverChannel.supportsTLS()) {
            connectionImpl = new SSLConnectionImpl(serverConfigurationInformation);
            muxableSocketClusterBroadcast = MuxableSocketClusterBroadcastS.createConnection(serverConfigurationInformation.getAddress(), serverConfigurationInformation.getPort(), connectionImpl, serverChannel);
        } else {
            connectionImpl = new ConnectionImpl(serverConfigurationInformation);
            muxableSocketClusterBroadcast = MuxableSocketClusterBroadcast.createConnection(serverConfigurationInformation.getAddress(), serverConfigurationInformation.getPort(), connectionImpl, serverChannel);
        }
        connectionImpl.setSocket(muxableSocketClusterBroadcast.getSocket());
        return connectionImpl;
    }

    private void debug(String string) {
        Environment.getLogService().debug("[ConnectionManager] " + string);
    }

    public Connection createConnection(Socket socket) throws IOException {
        if (socket instanceof SSLSocket) {
            return new SSLConnectionImpl(socket);
        }
        return super.createConnection(socket);
    }

    private static final class Factory {
        static final ConnectionManagerImpl THE_ONE = new ConnectionManagerImpl();

        private Factory() {
        }
    }
}

