/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.cluster.FragmentSocket;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.Message;
import weblogic.cluster.messaging.internal.MessageListener;
import weblogic.cluster.messaging.internal.MessageUtils;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;
import weblogic.cluster.messaging.internal.server.ConfiguredServersMonitorImpl;
import weblogic.cluster.messaging.internal.server.ConnectionManagerImpl;
import weblogic.cluster.messaging.internal.server.LogServiceImpl;
import weblogic.cluster.messaging.internal.server.PropertyServiceImpl;
import weblogic.cluster.messaging.internal.server.UnicastMessagingRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ClusterRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class UnicastFragmentSocket
implements FragmentSocket,
MessageListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = Environment.DEBUG;
    private boolean blocked = true;
    private ArrayList blockedPackets = new ArrayList();
    private int fragmentsSentCount = 0;
    private int fragmentsReceivedCount = 0;
    private ArrayList receivedMessages = new ArrayList();
    private boolean shutdown;

    public UnicastFragmentSocket() {
        if (!Environment.isInitialized()) {
            Environment.setLogService(LogServiceImpl.getInstance());
            Environment.initialize(ConfiguredServersMonitorImpl.getInstance(), ConnectionManagerImpl.getInstance(), PropertyServiceImpl.getInstance());
            this.registerRuntime();
        }
        Environment.getGroupManager().setMessageListener(this);
        if (DEBUG) {
            this.debug("initialized UnicastFragmentSocket !");
        }
    }

    private void registerRuntime() {
        block2: {
            try {
                ClusterRuntimeMBean clusterRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getClusterRuntime();
                new UnicastMessagingRuntimeMBeanImpl(clusterRuntimeMBean);
            }
            catch (ManagementException managementException) {
                if (!DEBUG) break block2;
                managementException.printStackTrace();
            }
        }
    }

    private void debug(String string) {
        Environment.getLogService().debug("[UnicastFragmentSocket] " + string);
    }

    public synchronized void start() throws IOException {
        this.shutdown = false;
        this.blocked = false;
        Iterator iterator = this.blockedPackets.iterator();
        while (iterator.hasNext()) {
            Packet packet = (Packet)iterator.next();
            this.send(packet.buffer, packet.length);
        }
        this.blockedPackets.clear();
    }

    public void send(byte[] byArray, int n) throws IOException {
        if (this.blocked) {
            if (DEBUG) {
                this.debug("blocked. adding to blocked packets");
            }
            this.blockedPackets.add(new Packet(byArray, n));
            return;
        }
        ServerConfigurationInformation serverConfigurationInformation = Environment.getConfiguredServersMonitor().getLocalServerConfiguration();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        Message message = MessageUtils.createMessage(byArray2, serverConfigurationInformation.getServerName(), 1L);
        if (DEBUG) {
            this.debug("sending '" + message + "' to local group");
        }
        Environment.getGroupManager().getLocalGroup().send(message);
        ++this.fragmentsSentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(byte[] byArray) throws InterruptedIOException, IOException {
        Message message = null;
        ArrayList arrayList = this.receivedMessages;
        synchronized (arrayList) {
            while (this.receivedMessages.size() == 0 && !this.shutdown) {
                try {
                    if (DEBUG) {
                        this.debug("waiting for a message to arrive ...");
                    }
                    this.receivedMessages.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.shutdown) {
                throw new IOException("unicast receiver is shutdown");
            }
            message = (Message)this.receivedMessages.remove(0);
        }
        int n = Math.min(byArray.length, message.getData().length);
        System.arraycopy(message.getData(), 0, byArray, 0, n);
        ++this.fragmentsReceivedCount;
        if (DEBUG) {
            this.debug("message '" + message + "' received");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (DEBUG) {
            this.debug("shutdown");
        }
        this.blockedPackets.clear();
        this.shutdown = true;
        ArrayList arrayList = this.receivedMessages;
        synchronized (arrayList) {
            this.receivedMessages.notify();
        }
    }

    public long getFragmentsSentCount() {
        return this.fragmentsSentCount;
    }

    public long getFragmentsReceivedCount() {
        return this.fragmentsReceivedCount;
    }

    public void setPacketDelay(long l) {
    }

    public void shutdownPermanent() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        ArrayList arrayList = this.receivedMessages;
        synchronized (arrayList) {
            this.receivedMessages.add(message);
            this.receivedMessages.notify();
        }
    }

    private static class Packet {
        private final byte[] buffer;
        private final int length;

        Packet(byte[] byArray, int n) {
            this.buffer = byArray;
            this.length = n;
        }
    }
}

