/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal.server;

import java.util.ArrayList;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.Group;
import weblogic.cluster.messaging.internal.GroupMember;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.UnicastMessagingRuntimeMBean;

public class UnicastMessagingRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements UnicastMessagingRuntimeMBean {
    private static UnicastMessagingRuntimeMBeanImpl THE_ONE;

    UnicastMessagingRuntimeMBeanImpl(RuntimeMBean runtimeMBean) throws ManagementException {
        super("UnicastMessagingRuntime", runtimeMBean, true);
        THE_ONE = this;
    }

    public static UnicastMessagingRuntimeMBeanImpl getInstance() {
        return THE_ONE;
    }

    public int getRemoteGroupsDiscoveredCount() {
        return this.getDiscoveredGroupLeaders().length - 1;
    }

    public String getLocalGroupLeaderName() {
        Group group = Environment.getGroupManager().getLocalGroup();
        GroupMember[] groupMemberArray = group.getMembers();
        return groupMemberArray[0].getConfiguration().getServerName();
    }

    public int getTotalGroupsCount() {
        Group[] groupArray = Environment.getGroupManager().getRemoteGroups();
        return groupArray.length + 1;
    }

    public String[] getDiscoveredGroupLeaders() {
        Group[] groupArray = Environment.getGroupManager().getRemoteGroups();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getLocalGroupLeaderName());
        for (int i = 0; i < groupArray.length; ++i) {
            GroupMember[] groupMemberArray = groupArray[i].getMembers();
            if (groupMemberArray == null || groupMemberArray.length <= 0) continue;
            arrayList.add(groupMemberArray[0].getConfiguration().getServerName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getGroups() {
        StringBuffer stringBuffer = new StringBuffer();
        Group group = Environment.getGroupManager().getLocalGroup();
        UnicastMessagingRuntimeMBeanImpl.printGroup(group, stringBuffer);
        Group[] groupArray = Environment.getGroupManager().getRemoteGroups();
        for (int i = 0; i < groupArray.length; ++i) {
            UnicastMessagingRuntimeMBeanImpl.printGroup(groupArray[i], stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static void printGroup(Group group, StringBuffer stringBuffer) {
        GroupMember[] groupMemberArray = group.getMembers();
        stringBuffer.append("{");
        for (int i = 0; i < groupMemberArray.length; ++i) {
            stringBuffer.append(groupMemberArray[i].getConfiguration().getServerName());
            if (i >= groupMemberArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
    }
}

