/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerChannel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.SocketMuxer;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;

public class MuxableSocketClusterBroadcast
extends AbstractMuxableSocket {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    protected static final boolean DEBUG = Environment.DEBUG;
    private static final int PROTOCOL_LENGTH = 17;
    private static final int MESSAGE_LENGTH_SIZE = 4;
    private Connection connection;
    private static boolean enabled = true;

    MuxableSocketClusterBroadcast(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        super(chunk, socket, serverChannel);
        this.ensureEnabled(this.getSocket().getLocalAddress(), this.getSocket().getPort());
        this.connection = Environment.getConnectionManager().createConnection(socket);
        if (DEBUG) {
            this.debug("created connection " + this.connection);
        }
    }

    MuxableSocketClusterBroadcast(InetAddress inetAddress, int n, ServerChannel serverChannel, Connection connection) throws IOException {
        super(serverChannel);
        if (serverChannel == null || serverChannel.getConnectTimeout() == 0) {
            this.connect(inetAddress, n, 10000);
        } else {
            this.connect(inetAddress, n);
        }
        this.ensureEnabled(this.getSocket().getLocalAddress(), this.getSocket().getPort());
        this.connection = connection;
    }

    public static MuxableSocketClusterBroadcast createConnection(InetAddress inetAddress, int n, Connection connection, ServerChannel serverChannel) throws IOException {
        MuxableSocketClusterBroadcast muxableSocketClusterBroadcast = new MuxableSocketClusterBroadcast(inetAddress, n, serverChannel, connection);
        SocketMuxer.getMuxer().register(muxableSocketClusterBroadcast);
        SocketMuxer.getMuxer().read(muxableSocketClusterBroadcast);
        return muxableSocketClusterBroadcast;
    }

    protected int getHeaderLength() {
        return this.getProtocolLength() + 4;
    }

    protected int getMessageLength() {
        int n = this.getProtocolLength();
        int n2 = this.getHeaderByte(n) & 0xFF;
        if (DEBUG) {
            this.debug("r0=" + n2);
        }
        int n3 = this.getHeaderByte(n + 1) & 0xFF;
        if (DEBUG) {
            this.debug("r1=" + n3);
        }
        int n4 = this.getHeaderByte(n + 2) & 0xFF;
        if (DEBUG) {
            this.debug("r2=" + n4);
        }
        int n5 = this.getHeaderByte(n + 3) & 0xFF;
        if (DEBUG) {
            this.debug("r3=" + n5);
        }
        if (DEBUG) {
            this.debug("length=" + (n2 << 24 | n3 << 16 | n4 << 8 | n5));
        }
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    protected int getProtocolLength() {
        return 17;
    }

    public void dispatch(Chunk chunk) {
        try {
            if (DEBUG) {
                this.debug("dispatching with data [" + chunk + "]");
            }
            this.connection.handleIncomingMessage((InputStream)new ChunkedInputStream(chunk, this.getHeaderLength()));
        }
        catch (IOException iOException) {
            SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), iOException);
        }
    }

    protected void debug(String string) {
        Environment.getLogService().debug("[UnicastMuxableSocket] " + string);
    }

    public void hasException(Throwable throwable) {
        this.connection.close();
        this.close();
    }

    public void endOfStream() {
        this.connection.close();
        this.close();
    }

    public boolean timeout() {
        this.connection.close();
        this.close();
        return true;
    }

    public int getIdleTimeoutMillis() {
        return 0;
    }

    public static boolean isEnabled() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        if (serverMBean == null || serverMBean.getCluster() == null) {
            return false;
        }
        return "unicast".equals(serverMBean.getCluster().getClusterMessagingMode()) && Environment.isInitialized();
    }

    private void ensureEnabled(InetAddress inetAddress, int n) throws IOException {
        if (!enabled) {
            Socket socket = this.getSocket();
            if (socket != null) {
                socket.close();
            }
            throw new IOException("An attempt to connect via CLUSTER-BROADCAST to: '" + inetAddress + "', on port: '" + n + "' was rejected because CLUSTER-BROADCAST is " + "not enabled.");
        }
    }
}

