/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.protocol.MuxableSocketClusterBroadcast;
import weblogic.protocol.ServerChannel;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.socket.JSSESocket;
import weblogic.socket.SSLFilter;
import weblogic.socket.utils.JSSEUtils;
import weblogic.utils.io.Chunk;

public final class MuxableSocketClusterBroadcastS
extends MuxableSocketClusterBroadcast {
    private static final int PROTOCOL_LENGTH = "CLUSTER-BROADCAST-SECURE".length();

    public MuxableSocketClusterBroadcastS(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        super(chunk, socket, serverChannel);
    }

    public MuxableSocketClusterBroadcastS(InetAddress inetAddress, int n, ServerChannel serverChannel, Connection connection) throws IOException {
        super(inetAddress, n, serverChannel, connection);
    }

    public static MuxableSocketClusterBroadcast createConnection(InetAddress inetAddress, int n, Connection connection, ServerChannel serverChannel) throws IOException {
        MuxableSocketClusterBroadcastS muxableSocketClusterBroadcastS = new MuxableSocketClusterBroadcastS(inetAddress, n, serverChannel, connection);
        SSLSocket sSLSocket = (SSLSocket)muxableSocketClusterBroadcastS.getSocket();
        JSSESocket jSSESocket = JSSEUtils.getJSSESocket(sSLSocket);
        if (jSSESocket != null) {
            JSSEUtils.registerJSSEFilter(jSSESocket, muxableSocketClusterBroadcastS);
            JSSEUtils.activate(jSSESocket, muxableSocketClusterBroadcastS);
        } else {
            SSLIOContext sSLIOContext = SSLIOContextTable.findContext(sSLSocket);
            SSLFilter sSLFilter = (SSLFilter)sSLIOContext.getFilter();
            muxableSocketClusterBroadcastS.setSocketFilter(sSLFilter);
            try {
                sSLSocket.startHandshake();
            }
            catch (SSLException sSLException) {
                if (!sSLSocket.isClosed()) {
                    try {
                        sSLSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw sSLException;
            }
            sSLFilter.setDelegate(muxableSocketClusterBroadcastS);
            if (DEBUG) {
                muxableSocketClusterBroadcastS.debug("SSL socket initialized!");
            }
            sSLFilter.activate();
        }
        return muxableSocketClusterBroadcastS;
    }

    protected int getProtocolLength() {
        return PROTOCOL_LENGTH;
    }

    protected void debug(String string) {
        Environment.getLogService().debug("[UnicastMuxableSocketSecure] " + string);
    }
}

