/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.protocol;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.LogService;
import weblogic.cluster.messaging.protocol.MuxableSocketClusterBroadcast;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SocketLogger;
import weblogic.utils.io.Chunk;

public class ProtocolHandlerClusterBroadcast
implements ProtocolHandler {
    private static final String PROTOCOL_NAME = "CLUSTER-BROADCAST";
    private static final ProtocolHandler theOne = new ProtocolHandlerClusterBroadcast();
    public static final Protocol PROTOCOL_CLUSTER = ProtocolManager.createProtocol((byte)12, (String)"CLUSTER-BROADCAST", (String)"CLUSTER-BROADCAST", (boolean)false, (ProtocolHandler)ProtocolHandlerClusterBroadcast.getProtocolHandler());
    private static final boolean DEBUG = Environment.DEBUG;

    public static ProtocolHandler getProtocolHandler() {
        return theOne;
    }

    public ServerChannel getDefaultServerChannel() {
        return ChannelInitializer.CHANNEL;
    }

    public int getHeaderLength() {
        return PROTOCOL_NAME.length();
    }

    public int getPriority() {
        return 1;
    }

    public Protocol getProtocol() {
        return PROTOCOL_CLUSTER;
    }

    public MuxableSocket createSocket(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        if (!MuxableSocketClusterBroadcast.isEnabled()) {
            SocketLogger.logConnectionRejectedProtocol((String)serverChannel.getChannelName(), (String)serverChannel.getConfiguredProtocol());
            throw new ProtocolException("unicast cluster messaging is disabled");
        }
        MuxableSocketClusterBroadcast muxableSocketClusterBroadcast = new MuxableSocketClusterBroadcast(chunk, socket, serverChannel);
        return muxableSocketClusterBroadcast;
    }

    public boolean claimSocket(Chunk chunk) {
        return this.claimSocket(chunk, PROTOCOL_NAME);
    }

    protected boolean claimSocket(Chunk chunk, String string) {
        int n = string.length();
        if (chunk.end < n) {
            return false;
        }
        byte[] byArray = chunk.buf;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected void debug(String string) {
        LogService logService = Environment.getLogService();
        if (logService != null) {
            logService.debug("[UnicastProtocolHandler] " + string);
        }
    }

    private static final class ChannelInitializer {
        private static final ServerChannel CHANNEL = ServerChannelImpl.createDefaultServerChannel(PROTOCOL_CLUSTER);

        private ChannelInitializer() {
        }
    }
}

