/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.security.AccessController;
import java.util.List;
import weblogic.cluster.singleton.AbstractServiceLocationSelector;
import weblogic.cluster.singleton.BasicServiceLocationSelector;
import weblogic.cluster.singleton.ServiceLocationSelector;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.cluster.singleton.SingletonServicesState;
import weblogic.cluster.singleton.SingletonServicesStateManager;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ExactlyOnceServiceLocationSelector
extends AbstractServiceLocationSelector {
    private MigratableTargetMBean mtBean;
    private ServerMBean upsServer;
    private SingletonServicesStateManager stateManager;
    private List serverList;
    private ServerMBean lastHost;
    private boolean triedOnUPS = false;
    private ServiceLocationSelector sls;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public ExactlyOnceServiceLocationSelector(MigratableTargetMBean migratableTargetMBean, SingletonServicesStateManager singletonServicesStateManager) {
        this.mtBean = migratableTargetMBean;
        this.upsServer = migratableTargetMBean.getUserPreferredServer();
        this.stateManager = singletonServicesStateManager;
        this.sls = new BasicServiceLocationSelector(migratableTargetMBean.getName(), singletonServicesStateManager);
    }

    public ServerMBean chooseServer() {
        ServerMBean serverMBean = null;
        boolean bl = false;
        if (this.lastHost == null) {
            serverMBean = this.startOnUPServer(bl);
        } else {
            if (!this.stateManager.checkServiceState(this.mtBean.getName(), 0)) {
                bl = true;
            }
            boolean bl2 = false;
            if (this.lastHost == ManagementService.getRuntimeAccess(kernelId).getServer() && this.lastHost.getName().equals(this.upsServer.getName()) && this.stateManager.getServiceState(this.mtBean.getName()) == null) {
                bl2 = true;
            }
            if (!this.lastHost.getName().equals(this.upsServer.getName()) || bl2) {
                serverMBean = this.startOnUPServer(bl);
            }
        }
        if (serverMBean == null) {
            serverMBean = this.startOnNonUPServer(bl);
        }
        return serverMBean;
    }

    public void setLastHost(ServerMBean serverMBean) {
        this.lastHost = serverMBean;
        this.sls.setLastHost(serverMBean);
    }

    public void setServerList(List list) {
        this.serverList = this.getAcceptableServers(list);
        if (this.serverList.size() > 1) {
            this.serverList.remove(this.upsServer);
        }
        this.sls.setServerList(this.serverList);
    }

    public void migrationSuccessful(ServerMBean serverMBean, boolean bl) {
        if (!bl) {
            this.upsServer = serverMBean;
        }
        this.stateManager.storeServiceState(this.mtBean.getName(), new SingletonServicesState(1));
    }

    private ServerMBean startOnUPServer(boolean bl) {
        ServerMBean serverMBean = null;
        if (this.isServerRunning(this.upsServer) && !this.triedOnUPS) {
            serverMBean = this.chooseUPSServer();
        }
        if (serverMBean != null) {
            if (DEBUG) {
                ExactlyOnceServiceLocationSelector.p(this.mtBean.getName() + "- Going to select (UPS) " + serverMBean);
            }
            if (bl && !this.executePostScript(this.mtBean, serverMBean, this.lastHost)) {
                this.stateManager.storeServiceState(this.mtBean.getName(), new SingletonServicesState(4));
                serverMBean = null;
            }
        } else if (DEBUG) {
            ExactlyOnceServiceLocationSelector.p(this.mtBean.getName() + " - UPS Server " + this.upsServer + " not available");
        }
        return serverMBean;
    }

    private ServerMBean startOnNonUPServer(boolean bl) {
        if (this.serverList.size() == 0) {
            return null;
        }
        ServerMBean serverMBean = this.sls.chooseServer();
        if (serverMBean != null) {
            if (DEBUG) {
                ExactlyOnceServiceLocationSelector.p(this.mtBean.getName() + " - Going to select (Non-UPS) " + serverMBean);
            }
            if (bl && !this.executePostScript(this.mtBean, serverMBean, this.lastHost)) {
                this.stateManager.storeServiceState(this.mtBean.getName(), new SingletonServicesState(4));
                serverMBean = null;
            }
        }
        return serverMBean;
    }

    private ServerMBean chooseUPSServer() {
        this.sls.setLastHost(this.upsServer);
        this.triedOnUPS = true;
        return this.upsServer;
    }

    protected static void p(Object object) {
        SingletonServicesDebugLogger.debug("ExactlyOnceServiceLocationSelector: " + object);
    }
}

