/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.util.List;
import weblogic.cluster.singleton.AbstractServiceLocationSelector;
import weblogic.cluster.singleton.BasicServiceLocationSelector;
import weblogic.cluster.singleton.ServiceLocationSelector;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.cluster.singleton.SingletonServicesState;
import weblogic.cluster.singleton.SingletonServicesStateManager;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;

public class FailureRecoveryServiceLocationSelector
extends AbstractServiceLocationSelector {
    private MigratableTargetMBean mtBean;
    private ServerMBean upsServer;
    private SingletonServicesStateManager stateManager;
    private List serverList;
    private ServerMBean lastHost;
    private boolean triedOnUPS = false;
    private ServiceLocationSelector sls;

    public FailureRecoveryServiceLocationSelector(MigratableTargetMBean migratableTargetMBean, SingletonServicesStateManager singletonServicesStateManager) {
        this.mtBean = migratableTargetMBean;
        this.upsServer = migratableTargetMBean.getUserPreferredServer();
        this.stateManager = singletonServicesStateManager;
        this.sls = new BasicServiceLocationSelector(migratableTargetMBean.getName(), singletonServicesStateManager);
    }

    public ServerMBean chooseServer() {
        ServerMBean serverMBean = null;
        boolean bl = this.stateManager.checkServiceState(this.mtBean.getName(), 1);
        boolean bl2 = this.stateManager.checkServiceState(this.mtBean.getName(), 2);
        boolean bl3 = this.stateManager.checkServiceState(this.mtBean.getName(), 3);
        boolean bl4 = this.stateManager.checkServiceState(this.mtBean.getName(), 0);
        if (bl3) {
            if (DEBUG) {
                FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " - is marked as shutdown. Trying to" + " start it on its UPS Server");
            }
            return this.startOnUPServer(false);
        }
        if (bl4) {
            if (this.lastHost == null) {
                if (DEBUG) {
                    FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " - is marked as failed and its last host " + "is null. First trying to start it on its UPS Server");
                }
                serverMBean = this.startOnUPServer(false);
            } else {
                if (DEBUG) {
                    FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " - is marked as failed and its last host " + "is not null. First trying to start it on its UPS Server");
                }
                if (!this.lastHost.getName().equals(this.upsServer.getName())) {
                    serverMBean = this.startOnUPServer(false);
                }
            }
            if (serverMBean == null) {
                if (DEBUG) {
                    FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " -  Now trying to start it on its Non-UPS Server");
                }
                serverMBean = this.startOnNonUPServer(false);
            }
        } else {
            if (!bl2 && !bl) {
                if (DEBUG) {
                    FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " - is neither marked as NonMigratable nor " + "migratable. Trying to start it on its UPS Server");
                }
                return this.startOnUPServer(false);
            }
            if (bl2) {
                if (this.lastHost == null) {
                    if (DEBUG) {
                        FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " is marked as NonMigratable and its " + "lasthost is null. Trying to start it on its UPS Server");
                    }
                    return this.startOnUPServer(false);
                }
                if (DEBUG) {
                    FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " is marked as NonMigratable and its " + "lasthost is not null. First trying to start it on its UPS Server");
                }
                if (!this.triedOnUPS) {
                    serverMBean = this.startOnUPServer(true);
                }
                if (serverMBean == null) {
                    if (DEBUG) {
                        FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " -  Now trying to start it on its Non-UPS Server");
                    }
                    serverMBean = this.startOnNonUPServer(true);
                }
            } else if (bl) {
                if (this.lastHost == null) {
                    if (DEBUG) {
                        FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " is marked as Migratable and its " + "lasthost is null. First trying to start it on its UPS Server.");
                    }
                    if (!this.triedOnUPS) {
                        serverMBean = this.startOnUPServer(false);
                    }
                    if (serverMBean == null) {
                        if (DEBUG) {
                            FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " -  Now trying to start it on its Non-UPS Server");
                        }
                        serverMBean = this.startOnNonUPServer(false);
                    }
                } else {
                    if (DEBUG) {
                        FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " is marked as Migratable and its " + "lasthost is not null. First trying to start it on its UPS Server.");
                    }
                    if (!this.triedOnUPS) {
                        serverMBean = this.startOnUPServer(true);
                    }
                    if (serverMBean == null) {
                        if (DEBUG) {
                            FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " -  Now trying to start it on its Non-UPS Server");
                        }
                        serverMBean = this.startOnNonUPServer(true);
                    }
                }
            }
        }
        return serverMBean;
    }

    private ServerMBean startOnUPServer(boolean bl) {
        ServerMBean serverMBean = null;
        if (this.isServerRunning(this.upsServer) && !this.triedOnUPS) {
            serverMBean = this.chooseUPSServer();
        }
        if (serverMBean != null) {
            if (DEBUG) {
                FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " - Going to select (UPS) " + serverMBean);
            }
            if (bl && !this.executePostScript(this.mtBean, serverMBean, this.lastHost)) {
                this.stateManager.storeServiceState(this.mtBean.getName(), new SingletonServicesState(4));
                serverMBean = null;
            }
        } else if (DEBUG) {
            FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " - UPS Server " + this.upsServer + " not available");
        }
        return serverMBean;
    }

    private ServerMBean startOnNonUPServer(boolean bl) {
        if (this.serverList.size() == 0) {
            return null;
        }
        ServerMBean serverMBean = this.sls.chooseServer();
        if (serverMBean != null) {
            if (DEBUG) {
                FailureRecoveryServiceLocationSelector.p(this.mtBean.getName() + " - Going to select (Non-UPS) " + serverMBean);
            }
            if (bl && !this.executePostScript(this.mtBean, serverMBean, this.lastHost)) {
                this.stateManager.storeServiceState(this.mtBean.getName(), new SingletonServicesState(4));
                serverMBean = null;
            }
        }
        return serverMBean;
    }

    public void setLastHost(ServerMBean serverMBean) {
        this.lastHost = serverMBean;
        this.sls.setLastHost(serverMBean);
    }

    public void setServerList(List list) {
        this.serverList = this.getAcceptableServers(list);
        if (this.serverList.size() > 1) {
            this.serverList.remove(this.upsServer);
        }
        this.sls.setServerList(this.serverList);
    }

    public void migrationSuccessful(ServerMBean serverMBean, boolean bl) {
        SingletonServicesState singletonServicesState = null;
        if (bl) {
            singletonServicesState = serverMBean.getName().equals(this.upsServer.getName()) ? new SingletonServicesState(2) : new SingletonServicesState(1);
        } else {
            this.upsServer = serverMBean;
            singletonServicesState = new SingletonServicesState(2);
        }
        this.stateManager.storeServiceState(this.mtBean.getName(), singletonServicesState);
    }

    private ServerMBean chooseUPSServer() {
        this.sls.setLastHost(this.upsServer);
        this.triedOnUPS = true;
        return this.upsServer;
    }

    protected static void p(Object object) {
        SingletonServicesDebugLogger.debug("FailureRecoveryServiceLocationSelector: " + object);
    }
}

