/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.RemoteMigratableServiceCoordinator;
import weblogic.cluster.migration.management.MigratableServiceCoordinatorRuntime;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.jndi.Environment;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStoreException;

public class JTAMigrationHandler {
    private static int SINGLETON_MASTER_RETRY_COUNT;
    private static RemoteMigratableServiceCoordinator remoteMigratableServiceCoordinator;
    private static final boolean DEBUG = true;
    private static final AuthenticatedSubject kernelId;

    public static void deactivateJTA(MigratableTargetMBean migratableTargetMBean, String string) throws MigrationException {
        if (JTAMigrationHandler.isTargetAutoMigratable(migratableTargetMBean)) {
            try {
                SingletonMonitorRemote singletonMonitorRemote = MigratableServerService.theOne().getSingletonMasterRemote(SINGLETON_MASTER_RETRY_COUNT);
                if (singletonMonitorRemote == null) {
                    throw new MigrationException("Could not deactivate JTA, the singleton monitor is unreachable.");
                }
                singletonMonitorRemote.deactivateJTA(string, string);
            }
            catch (Exception exception) {
                throw new MigrationException("Could not deactivate JTA: " + exception, exception);
            }
        }
        if (remoteMigratableServiceCoordinator == null) {
            JTAMigrationHandler.initializeRemoteMigratableServiceCoordinator();
        }
        try {
            remoteMigratableServiceCoordinator.deactivateJTA(string, string);
        }
        catch (RemoteException remoteException) {
            throw new MigrationException("Could not deactivate JTA: " + remoteException, remoteException);
        }
        return;
    }

    public static void deactivateJTA(String string, String string2) throws MigrationException {
        JTAMigrationHandler.deactivateJTA(JTAMigrationHandler.getJTAMigratableTarget(string), string2);
    }

    public static void migrateJTA(String string, String string2, boolean bl, boolean bl2) throws MigrationException {
        block7: {
            MigratableTargetMBean migratableTargetMBean = JTAMigrationHandler.getJTAMigratableTarget(string);
            if (JTAMigrationHandler.isTargetAutoMigratable(migratableTargetMBean)) {
                if (!bl2) {
                    JTAMigrationHandler.deactivateJTA(string, string2);
                }
                try {
                    SingletonMonitorRemote singletonMonitorRemote = MigratableServerService.theOne().getSingletonMasterRemote();
                    if (!singletonMonitorRemote.migrate(string, string2)) {
                        throw new MigrationException("Migration of " + string + " to " + string2 + " failed.");
                    }
                    break block7;
                }
                catch (LeasingException leasingException) {
                    throw new MigrationException("Could not migrate JTA: " + leasingException, leasingException);
                }
                catch (RemoteException remoteException) {
                    throw new MigrationException("Could not migrate JTA: " + remoteException, remoteException);
                }
            }
            if (remoteMigratableServiceCoordinator == null) {
                JTAMigrationHandler.initializeRemoteMigratableServiceCoordinator();
            }
            remoteMigratableServiceCoordinator.migrateJTA(string, string2, bl, bl2);
        }
    }

    public static String findJTA(String string) throws RemoteException, PersistentStoreException {
        MigratableTargetMBean migratableTargetMBean = JTAMigrationHandler.getJTAMigratableTarget(string);
        if (JTAMigrationHandler.isTargetAutoMigratable(migratableTargetMBean)) {
            try {
                SingletonMonitorRemote singletonMonitorRemote = MigratableServerService.theOne().getSingletonMasterRemote();
                return singletonMonitorRemote.findServiceLocation(string);
            }
            catch (LeasingException leasingException) {
                throw new RemoteException("Could not find JTA: " + leasingException);
            }
        }
        if (remoteMigratableServiceCoordinator == null) {
            JTAMigrationHandler.initializeRemoteMigratableServiceCoordinator();
        }
        return remoteMigratableServiceCoordinator.getCurrentLocationOfJTA(string);
    }

    public static boolean isAvailable(String string) {
        MigratableTargetMBean migratableTargetMBean = JTAMigrationHandler.getJTAMigratableTarget(string);
        if (JTAMigrationHandler.isTargetAutoMigratable(migratableTargetMBean)) {
            try {
                SingletonMonitorRemote singletonMonitorRemote = MigratableServerService.theOne().getSingletonMasterRemote();
                return singletonMonitorRemote != null;
            }
            catch (LeasingException leasingException) {
                return false;
            }
        }
        try {
            if (remoteMigratableServiceCoordinator == null) {
                JTAMigrationHandler.initializeRemoteMigratableServiceCoordinator();
            }
            return true;
        }
        catch (MigrationException migrationException) {
            return false;
        }
    }

    private static MigratableTargetMBean getJTAMigratableTarget(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(string);
        if (serverMBean == null) {
            throw new MigrationException("No server found named " + string);
        }
        JTAMigratableTargetMBean jTAMigratableTargetMBean = serverMBean.getJTAMigratableTarget();
        if (jTAMigratableTargetMBean == null) {
            throw new MigrationException("No JTA migratable target found on " + string);
        }
        return jTAMigratableTargetMBean;
    }

    private static boolean isTargetAutoMigratable(MigratableTargetMBean migratableTargetMBean) throws MigrationException {
        return !migratableTargetMBean.getMigrationPolicy().equals("manual");
    }

    private static void initializeRemoteMigratableServiceCoordinator() {
        block9: {
            String string;
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            try {
                string = URLManager.findAdministrationURL(domainMBean.getAdminServerName());
            }
            catch (UnknownHostException unknownHostException) {
                throw new MigrationException("Cannot contact the administration server to deactivate JTA.", unknownHostException);
            }
            Environment environment = new Environment();
            environment.setProviderUrl(string);
            if (domainMBean.getAdminServerName().equals(ManagementService.getRuntimeAccess(kernelId).getServer().getName())) {
                ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
                if (2 != serverRuntimeMBean.getStateVal()) {
                    throw new MigrationException("Admin server is not available");
                }
                remoteMigratableServiceCoordinator = MigratableServiceCoordinatorRuntime.remoteCoordinator;
                return;
            }
            try {
                Context context = environment.getInitialContext();
                remoteMigratableServiceCoordinator = (RemoteMigratableServiceCoordinator)context.lookup("weblogic.cluster.migration.migratableServiceCoordinator");
                if (remoteMigratableServiceCoordinator == null) break block9;
                DisconnectMonitor disconnectMonitor = DisconnectMonitorListImpl.getDisconnectMonitor();
                try {
                    disconnectMonitor.addDisconnectListener((Remote)remoteMigratableServiceCoordinator, (DisconnectListener)new MigratableServiceCoordinatorDisconnectListener());
                    return;
                }
                catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
                }
                catch (Exception exception) {
                    JTAMigrationHandler.p("Unexpected exception while getting RemoteMigratableServiceCoordinator", exception);
                }
            }
            catch (NamingException namingException) {
                JTAMigrationHandler.p("Unexpected exception while getting RemoteMigratableServiceCoordinator", namingException);
            }
        }
        throw new MigrationException("Cannot contact the administration server to deactivate JTA.");
    }

    private static void p(String string, Exception exception) {
        System.out.println("<JTAMigrationHandler> " + string + " : " + exception);
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            String string = System.getProperty("weblogic.cluster.jta.SingletonMasterRetryCount", "20");
            SINGLETON_MASTER_RETRY_COUNT = Integer.valueOf(string);
        }
        catch (Exception exception) {
            SINGLETON_MASTER_RETRY_COUNT = 20;
        }
    }

    private static final class MigratableServiceCoordinatorDisconnectListener
    implements DisconnectListener {
        private MigratableServiceCoordinatorDisconnectListener() {
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            JTAMigrationHandler.remoteMigratableServiceCoordinator = null;
        }
    }
}

