/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.io.File;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import weblogic.cluster.ClusterTextTextFormatter;
import weblogic.common.internal.VersionInfo;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class MTCustomValidator {
    private static final ClusterTextTextFormatter fmt = new ClusterTextTextFormatter();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static boolean ASM_JMS_DISABLED = false;

    public static void validateMigratableTarget(MigratableTargetMBean migratableTargetMBean) {
        String string = migratableTargetMBean.getType();
        ClusterMBean clusterMBean = migratableTargetMBean.getCluster();
        ServerMBean serverMBean = migratableTargetMBean.getUserPreferredServer();
        String string2 = migratableTargetMBean.getName();
        if (serverMBean == null) {
            throw new IllegalArgumentException(fmt.getMigratableTargetInvViolation_1B(string2));
        }
        String string3 = serverMBean.getName() + " (migratable)";
        if (serverMBean.getCluster() == null && (string2.equals(string3) || migratableTargetMBean instanceof JTAMigratableTargetMBean)) {
            return;
        }
        if (clusterMBean == null) {
            throw new IllegalArgumentException(fmt.getMigratableTargetInvViolation_1A(string2));
        }
        String string4 = serverMBean.getName();
        if (!MTCustomValidator.isUserPreferredServerIsPartOfCluster(string4, clusterMBean.getServerNames())) {
            throw new IllegalArgumentException(fmt.getMigratableTargetInvViolation_1C(string2));
        }
        if (!serverMBean.getCluster().getName().equals(clusterMBean.getName())) {
            throw new IllegalArgumentException(fmt.getMigratableTargetInvViolation_2(string2));
        }
        ServerMBean[] serverMBeanArray = migratableTargetMBean.getConstrainedCandidateServers();
        if (serverMBeanArray.length > 0) {
            DomainMBean domainMBean = (DomainMBean)serverMBean.getParent();
            String string5 = domainMBean.getConfigurationVersion();
            if (!(string5 != null && new VersionInfo(string5).getMajor() <= 8 || MTCustomValidator.isUserPreferredServersIsPartOfCandidateServers(serverMBean, serverMBeanArray))) {
                throw new IllegalArgumentException(fmt.getMigratableTargetInvViolation_3(string2));
            }
            if (!MTCustomValidator.areAllCandidateServersPartOfCluster(serverMBeanArray, clusterMBean)) {
                throw new IllegalArgumentException(fmt.getMigratableTargetInvViolation_4(string2));
            }
        }
    }

    private static boolean isUserPreferredServerIsPartOfCluster(String string, Set set) {
        boolean bl = false;
        for (String string2 : set) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isUserPreferredServersIsPartOfCandidateServers(ServerMBean serverMBean, ServerMBean[] serverMBeanArray) {
        String string = serverMBean.getName();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!string.equals(serverMBeanArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean areAllCandidateServersPartOfCluster(ServerMBean[] serverMBeanArray, ClusterMBean clusterMBean) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < serverMBeanArray.length; ++n) {
            hashSet.add(serverMBeanArray[n].getName());
        }
        for (n = 0; n < serverMBeanArray.length; ++n) {
            if (hashSet.contains(serverMBeanArray[n].getName())) continue;
            return false;
        }
        return true;
    }

    public static void destroyMigratableTarget(MigratableTargetMBean migratableTargetMBean) {
        String string;
        ServerMBean serverMBean = migratableTargetMBean.getUserPreferredServer();
        if (!ManagementService.isRuntimeAccessInitialized()) {
            return;
        }
        ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = MTCustomValidator.getServerLifeCycleRuntime(serverMBean.getName());
        String string2 = string = serverLifeCycleRuntimeMBean == null ? "UNKNOWN" : serverLifeCycleRuntimeMBean.getState();
        if (string.equals("RUNNING") && ManagementService.getDomainAccess(kernelId).getDeployerRuntime().getDeployments(migratableTargetMBean).length != 0) {
            throw new IllegalArgumentException(fmt.getCannotDeleteMigratableTargetException(migratableTargetMBean.getName()));
        }
    }

    private static ServerLifeCycleRuntimeMBean getServerLifeCycleRuntime(String string) {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
            return domainAccess.lookupServerLifecycleRuntime(string);
        }
        return null;
    }

    public static void destroyServer(ServerMBean serverMBean) {
        MigratableTargetMBean[] migratableTargetMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getMigratableTargets();
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            ServerMBean serverMBean2 = migratableTargetMBeanArray[i].getUserPreferredServer();
            if (!serverMBean.getName().equals(serverMBean2.getName())) continue;
            throw new IllegalArgumentException(fmt.getCannotDeleteServerException(serverMBean.getName()));
        }
    }

    public static void destroyCluster(ClusterMBean clusterMBean) {
        MigratableTargetMBean[] migratableTargetMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getMigratableTargets();
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            ClusterMBean clusterMBean2 = migratableTargetMBeanArray[i].getCluster();
            if (!clusterMBean2.getName().equals(clusterMBean.getName()) || ManagementService.getDomainAccess(kernelId).getDeployerRuntime().getDeployments(migratableTargetMBeanArray[i]).length <= 0) continue;
            throw new IllegalArgumentException(fmt.getCannotDeleteClusterException(clusterMBean.getName()));
        }
    }

    public static void removeConstrainedCandidateServer(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean) {
        ServerMBean serverMBean2 = migratableTargetMBean.getUserPreferredServer();
        if (serverMBean2.getName().equals(serverMBean.getName())) {
            throw new IllegalArgumentException(fmt.getCannotRemoveUserPreferredServerException(migratableTargetMBean.getName()));
        }
    }

    public static void canSetCluster(MigratableTargetMBean migratableTargetMBean, ClusterMBean clusterMBean) {
        ClusterMBean clusterMBean2 = migratableTargetMBean.getCluster();
        if (clusterMBean2 != null && !clusterMBean2.getName().equals(clusterMBean.getName())) {
            throw new IllegalArgumentException(fmt.getCannotSetClusterException(migratableTargetMBean.getName()));
        }
    }

    public static void validateMigrationPolicy(MigratableTargetMBean migratableTargetMBean, String string) {
        ServerMBean[] serverMBeanArray;
        Object object;
        if ("manual".equals(string)) {
            return;
        }
        if (ASM_JMS_DISABLED && !(migratableTargetMBean instanceof JTAMigratableTargetMBean)) {
            throw new IllegalArgumentException(fmt.getIllegalMigrationPolicy(migratableTargetMBean.getName()));
        }
        ClusterMBean clusterMBean = migratableTargetMBean.getCluster();
        if (clusterMBean == null) {
            object = migratableTargetMBean.getParent();
            if (object instanceof ServerMBean) {
                serverMBeanArray = (ServerMBean[])object;
                clusterMBean = serverMBeanArray.getCluster();
                if (clusterMBean == null) {
                    return;
                }
            } else {
                return;
            }
        }
        if ("database".equals(object = clusterMBean.getMigrationBasis()) && clusterMBean.getDataSourceForAutomaticMigration() == null) {
            throw new IllegalArgumentException(fmt.getCannotEnableAutoMigrationWithoutLeasing(migratableTargetMBean.getName()));
        }
        if ("consensus".equals(object)) {
            serverMBeanArray = migratableTargetMBean.getConstrainedCandidateServers();
            if (serverMBeanArray == null) {
                return;
            }
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                MachineMBean machineMBean = serverMBeanArray[i].getMachine();
                if (machineMBean == null) {
                    throw new IllegalArgumentException(fmt.getNodemanagerRequiredOnCandidateServers(serverMBeanArray[i].getName()));
                }
                if (machineMBean.getNodeManager() != null) continue;
                throw new IllegalArgumentException(fmt.getNodemanagerRequiredOnCandidateServers(serverMBeanArray[i].getName()));
            }
        }
    }

    public static void validateScriptPath(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            throw new IllegalArgumentException("This value must specify a path relative to the service_migration directory in your domain." + string);
        }
        if (string.indexOf("..") > -1) {
            throw new IllegalArgumentException("This value must specify a path relative to the service_migration directory in your domain." + string);
        }
    }

    public static void validatePostScriptFailureFatal(MigratableTargetMBean migratableTargetMBean, boolean bl) {
        if (ASM_JMS_DISABLED && !(migratableTargetMBean instanceof JTAMigratableTargetMBean)) {
            throw new IllegalArgumentException(fmt.getIllegalAttemptToSetPostScriptFailure(migratableTargetMBean.getName()));
        }
    }

    public static void validateRestartOnFailure(MigratableTargetMBean migratableTargetMBean, boolean bl) {
        if (ASM_JMS_DISABLED && !(migratableTargetMBean instanceof JTAMigratableTargetMBean)) {
            throw new IllegalArgumentException(fmt.getIllegalAttemptToSetRestartOnFailure(migratableTargetMBean.getName()));
        }
    }

    public static void validateSecondsBetweenRestarts(MigratableTargetMBean migratableTargetMBean, int n) {
        if (ASM_JMS_DISABLED && !(migratableTargetMBean instanceof JTAMigratableTargetMBean)) {
            throw new IllegalArgumentException(fmt.getIllegalAttemptToSetSecondsBetweenRestarts(migratableTargetMBean.getName()));
        }
    }

    public static void validateNumberOfRestartAttempts(MigratableTargetMBean migratableTargetMBean, int n) {
        if (ASM_JMS_DISABLED && !(migratableTargetMBean instanceof JTAMigratableTargetMBean)) {
            throw new IllegalArgumentException(fmt.getIllegalAttemptToSetNumberOfRestartAttempts(migratableTargetMBean.getName()));
        }
    }
}

