/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.migration.GroupActivationException;
import weblogic.cluster.migration.GroupDeactivationException;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.ScriptExecutor;
import weblogic.cluster.singleton.LeaseLostListener;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeaseObtainedListener;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.SingletonService;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.cluster.singleton.SingletonServicesState;
import weblogic.cluster.singleton.SingletonServicesStateManagerRemote;
import weblogic.health.HealthFeedbackCallback;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.work.WorkManagerFactory;

public class MigratableGroup
implements ClusterMembersChangeListener,
SingletonService,
LeaseLostListener,
LeaseObtainedListener,
HealthFeedbackCallback {
    private static final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();
    private static final String HEALTH_JTA_SUBSYSTEM_NAME = "JTA";
    private final MigratableTargetMBean target;
    private final Map migratablesToJNDINameMap;
    private final TreeSet migratablesAsList = new TreeSet(new MigratableComparator());
    private HostID[] cachedHostList = new HostID[0];
    private boolean isActive;
    private int migratableState;
    private final Context ctx;
    Object activationLock = new Object();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public MigratableGroup(MigratableTargetMBean migratableTargetMBean) {
        this.target = migratableTargetMBean;
        this.migratablesToJNDINameMap = Collections.synchronizedMap(new HashMap());
        this.isActive = false;
        this.migratableState = 0;
        this.updateHostList();
        if (!migratableTargetMBean.getMigrationPolicy().equals("manual")) {
            SingletonServicesManager.getInstance().addConfiguredService(this.getName(), this);
        }
        try {
            this.ctx = new InitialContext();
        }
        catch (NamingException namingException) {
            throw new AssertionError("Error creating initial context", (Throwable)namingException);
        }
    }

    public MigratableTargetMBean getTarget() {
        return this.target;
    }

    boolean isActive() {
        return this.isActive;
    }

    public int getMigratableState() {
        return this.migratableState;
    }

    void failed() {
        if (DEBUG) {
            this.p("Failed " + this.getName());
        }
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = MigratableGroup.this.activationLock;
                synchronized (object) {
                    Object v1;
                    boolean bl;
                    if (!MigratableGroup.this.isActive) {
                        return;
                    }
                    try {
                        MigratableGroup.this.deactivateAllMigratables();
                        Object var3_2 = null;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Object v0;
                        Object var3_3 = null;
                        boolean bl2 = true;
                        try {
                            bl2 = MigratableGroup.this.executePostScript();
                            v0 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var6_9;
                            v0 = var6_9 = null;
                        }
                        if (!MigratableGroup.this.target.getMigrationPolicy().equals("manual")) {
                            Exception exception2;
                            if (bl2) {
                                try {
                                    MigratableGroup.this.updateState(0, (Serializable)((Object)ManagementService.getRuntimeAccess(kernelId).getServer().getName()));
                                }
                                catch (Exception exception2) {
                                    ClusterLogger.logLeasingError((String)MigratableGroup.this.target.getName(), (Exception)exception2);
                                }
                            }
                            try {
                                ClusterService.getServices().getDefaultLeaseManager("service").release(MigratableGroup.this.target.getName());
                            }
                            catch (LeasingException exception2) {
                                ClusterExtensionLogger.logReleaseLeaseError((String)MigratableGroup.this.target.getName(), (Exception)exception2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        bl = MigratableGroup.this.executePostScript();
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8;
                        v1 = var6_8 = null;
                    }
                    if (!MigratableGroup.this.target.getMigrationPolicy().equals("manual")) {
                        Exception exception3;
                        if (bl) {
                            try {
                                MigratableGroup.this.updateState(0, (Serializable)((Object)ManagementService.getRuntimeAccess(kernelId).getServer().getName()));
                            }
                            catch (Exception exception3) {
                                ClusterLogger.logLeasingError((String)MigratableGroup.this.target.getName(), (Exception)exception3);
                            }
                        }
                        try {
                            ClusterService.getServices().getDefaultLeaseManager("service").release(MigratableGroup.this.target.getName());
                        }
                        catch (LeasingException exception3) {
                            ClusterExtensionLogger.logReleaseLeaseError((String)MigratableGroup.this.target.getName(), (Exception)exception3);
                        }
                    }
                }
            }
        });
    }

    public void healthStateChange(HealthState healthState) {
        if (healthState == null) {
            return;
        }
        if (healthState.getSubsystemName() == null) {
            return;
        }
        if (healthState.getState() != 3 && healthState.getState() != 2) {
            return;
        }
        Iterator iterator = this.migratablesAsList.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = ((Migratable)iterator.next()).getName();
            if (string2 == null) continue;
            if (healthState.getSubsystemName().equals(string2)) {
                this.failed();
                continue;
            }
            if (!healthState.getSubsystemName().startsWith("PersistentStore.") || !string2.equals(string = healthState.getSubsystemName().substring("PersistentStore.".length(), healthState.getSubsystemName().length()))) continue;
            this.failed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Migratable migratable, String string) throws MigrationException {
        Object object = this.activationLock;
        synchronized (object) {
            if (this.migratablesAsList.contains(migratable)) {
                return false;
            }
            try {
                if (string != null) {
                    this.ctx.bind(string, (Object)migratable);
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (this.isActive) {
                migratable.migratableActivate();
            }
            if (string != null) {
                this.migratablesToJNDINameMap.put(migratable, string);
            }
            if (DEBUG) {
                this.p("adding migratable " + migratable.getName() + " to group " + this.getName() + " Migratable class - " + migratable.getClass().getName());
            }
            return this.migratablesAsList.add(migratable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Migratable migratable) throws MigrationException {
        Object object = this.activationLock;
        synchronized (object) {
            if (this.isActive) {
                migratable.migratableDeactivate();
            }
            this.migratablesToJNDINameMap.remove(migratable);
            return this.migratablesAsList.remove(migratable);
        }
    }

    String clearUpJNDIMap(Migratable migratable) {
        return (String)this.migratablesToJNDINameMap.remove(migratable);
    }

    int size() {
        return this.migratablesAsList.size();
    }

    public String getName() {
        return this.getTarget().getName();
    }

    public void onAcquire(String string) {
        LeaseManager leaseManager = ClusterService.getServices().getDefaultLeaseManager("service");
        leaseManager.addLeaseLostListener(this);
    }

    public void onException(Exception exception, String string) {
    }

    public void restart() throws MigrationException {
        this.deactivate();
        this.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Object object = this.activationLock;
        synchronized (object) {
            block18: {
                if (this.isActive) {
                    return;
                }
                if (!this.target.getMigrationPolicy().equals("manual")) {
                    LeaseManager leaseManager = ClusterService.getServices().getDefaultLeaseManager("service");
                    if (leaseManager == null) {
                        if (DEBUG) {
                            this.p("No lease manager, cannot start auto-migratable service.");
                        }
                        throw new MigrationException("No lease manager, cannot start auto-migratable service.");
                    }
                    try {
                        if (!leaseManager.tryAcquire(this.target.getName())) {
                            if (DEBUG) {
                                this.p("Could not claim lease for " + this.getName() + ", someone else must have it already.");
                            }
                            if (this.permitActivateWithoutLease(this.target)) {
                                try {
                                    leaseManager.acquire(this.target.getName(), this);
                                    break block18;
                                }
                                catch (LeasingException leasingException) {
                                    throw new MigrationException(leasingException);
                                }
                            }
                            throw new MigrationException("Could not claim lease, someone else must have it already.");
                        }
                        leaseManager.addLeaseLostListener(this);
                    }
                    catch (LeasingException leasingException) {
                        ClusterLogger.logLeasingError((String)this.target.getName(), (Exception)leasingException);
                        if (DEBUG) {
                            this.p("Could not claim lease due to error: " + leasingException);
                        }
                        throw new MigrationException("Could not claim lease due to error: " + leasingException, leasingException);
                    }
                }
            }
            if (!ScriptExecutor.runNMScript(this.target.getPreScript(), this.target)) {
                if (DEBUG) {
                    this.p("couldn't run prescript");
                }
                throw new MigrationException("couldn't run prescript", true);
            }
            this.updateHostList();
            this.activateAllMigratables();
            if (!this.target.getMigrationPolicy().equals("manual")) {
                HealthMonitorService.registerForCallback(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAllMigratables() {
        this.migratableState = 2;
        TreeSet treeSet = this.migratablesAsList;
        synchronized (treeSet) {
            if (DEBUG) {
                this.p("activating " + this.migratablesAsList.size() + " migratables" + " for " + this.getName());
            }
            Iterator iterator = this.migratablesAsList.iterator();
            GroupActivationException groupActivationException = new GroupActivationException();
            ArrayList<Migratable> arrayList = new ArrayList<Migratable>();
            while (iterator.hasNext()) {
                Migratable migratable = (Migratable)iterator.next();
                if (DEBUG) {
                    this.p("activating migratable '" + migratable.getName() + "' for " + this.getName());
                }
                this.activateTarget(migratable, groupActivationException);
                if (groupActivationException.getCauses().size() > 0) {
                    this.handleFailedStateChange(arrayList, true);
                    throw groupActivationException;
                }
                arrayList.add(migratable);
            }
            this.isActive = true;
            this.migratableState = 1;
        }
    }

    private void handleFailedStateChange(List list, boolean bl) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Migratable migratable = (Migratable)list.get(i);
            try {
                if (bl) {
                    if (DEBUG) {
                        this.p("Going to call migratableDeactivate on " + migratable + " for " + this.getName());
                    }
                    migratable.migratableDeactivate();
                    continue;
                }
                if (DEBUG) {
                    this.p("Going to call migratableActivate on " + migratable + " for " + this.getName());
                }
                this.activateTarget(migratable, new GroupActivationException());
                continue;
            }
            catch (MigrationException migrationException) {
                // empty catch block
            }
        }
    }

    private void activateTarget(Migratable migratable, GroupActivationException groupActivationException) throws MigrationException {
        try {
            migratable.migratableActivate();
            String string = (String)this.migratablesToJNDINameMap.get(migratable);
            if (string != null) {
                this.ctx.rebind(string, (Object)migratable);
            }
        }
        catch (NamingException namingException) {
            throw new MigrationException("Failed to migrate", namingException);
        }
        catch (MigrationException migrationException) {
            if (DEBUG) {
                this.p("Failed to activate " + migratable.getName() + " - " + migrationException.getCause());
            }
            groupActivationException.addCause(migrationException);
        }
    }

    void shutdown() {
        this.deactivate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateAllMigratables() {
        TreeSet treeSet = this.migratablesAsList;
        synchronized (treeSet) {
            if (DEBUG) {
                this.p("deactivating " + this.migratablesAsList.size() + " migratables" + " for " + this.getName());
            }
            Migratable[] migratableArray = new Migratable[this.migratablesAsList.size()];
            this.migratablesAsList.toArray(migratableArray);
            GroupDeactivationException groupDeactivationException = null;
            for (int i = migratableArray.length - 1; i >= 0; --i) {
                Migratable migratable = migratableArray[i];
                try {
                    if (DEBUG) {
                        this.p("Going to call migratableDeactivate on " + migratable.getName() + " for " + this.getName());
                    }
                    migratable.migratableDeactivate();
                    continue;
                }
                catch (MigrationException migrationException) {
                    if (groupDeactivationException == null) {
                        groupDeactivationException = new GroupDeactivationException();
                    }
                    if (DEBUG) {
                        this.p("Failed to deactivate " + migratable.getName() + " - " + migrationException.getCause());
                    }
                    groupDeactivationException.addCause(migrationException);
                }
            }
            this.isActive = false;
            this.migratableState = 0;
            if (groupDeactivationException != null) {
                throw groupDeactivationException;
            }
        }
    }

    public void deactivate() {
        if (DEBUG) {
            this.p("deactivating " + this.getName());
        }
        this.deactivate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate(boolean bl) {
        Object object = this.activationLock;
        synchronized (object) {
            Object v1;
            if (!this.isActive) {
                return;
            }
            this.updateHostList();
            if (!this.target.getMigrationPolicy().equals("manual")) {
                HealthMonitorService.deregisterForCallback(this);
            }
            try {
                this.deactivateAllMigratables();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                try {
                    if (!this.executePostScript() && !bl) {
                        throw new MigrationException("Execution of post deactivation script failed");
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_8;
                    v0 = var6_8 = null;
                }
                if (!this.target.getMigrationPolicy().equals("manual")) {
                    this.releaseLease();
                }
                throw throwable;
            }
            try {
                if (!this.executePostScript() && !bl) {
                    throw new MigrationException("Execution of post deactivation script failed");
                }
                v1 = null;
            }
            catch (Throwable throwable) {
                Object var6_7;
                v1 = var6_7 = null;
            }
            if (!this.target.getMigrationPolicy().equals("manual")) {
                this.releaseLease();
            }
        }
    }

    private void releaseLease() {
        try {
            ClusterService.getServices().getDefaultLeaseManager("service").release(this.target.getName());
        }
        catch (LeasingException leasingException) {
            ClusterExtensionLogger.logReleaseLeaseError((String)this.target.getName(), (Exception)leasingException);
        }
    }

    public void onRelease() {
        LeaseManager leaseManager = ClusterService.getServices().getDefaultLeaseManager("service");
        leaseManager.removeLeaseLostListener(this);
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (this.isActive && this.isLocalJTAMigratableTarget() && MigratableGroup.isLocalJTAAutoMigratable()) {
            HealthMonitorService.subsystemFailedForceShutdown("JTAMigratableGroup", "JTA migratable target lost a lease");
        } else {
            this.deactivate();
        }
    }

    public int hashCode() {
        return this.target.getName().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof MigratableGroup && ((MigratableGroup)object).target.getName().equals(this.target.getName());
    }

    public String toString() {
        return "MigratableGroup " + this.target.getName() + " with " + this.migratablesToJNDINameMap.toString();
    }

    public HostID[] getHostList() {
        this.updateHostList();
        return this.cachedHostList;
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        this.updateHostList();
    }

    private void updateHostList() {
        try {
            ServerMBean[] serverMBeanArray;
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            MigratableTargetMBean migratableTargetMBean = runtimeAccess.getDomain().lookupMigratableTarget(this.target.getName());
            if (migratableTargetMBean == null) {
                serverMBeanArray = runtimeAccess.getDomain().lookupServer(this.target.getName());
                migratableTargetMBean = serverMBeanArray.getJTAMigratableTarget();
            }
            Debug.assertion((migratableTargetMBean != null ? 1 : 0) != 0, (String)("Could find neither MigratableTarget nor JTAMigratableTarget " + this.target.getName()));
            serverMBeanArray = migratableTargetMBean.getAllCandidateServers();
            Collection collection = ClusterService.getServices().getRemoteMembers();
            ArrayList<ServerIdentity> arrayList = new ArrayList<ServerIdentity>();
            block2: for (int i = 0; i < serverMBeanArray.length; ++i) {
                String string = serverMBeanArray[i].getName();
                if (ManagementService.getRuntimeAccess(kernelId).getServerName().equals(string)) {
                    arrayList.add(LocalServerIdentity.getIdentity());
                    continue;
                }
                for (ClusterMemberInfo clusterMemberInfo : collection) {
                    if (!clusterMemberInfo.serverName().equals(string)) continue;
                    arrayList.add(clusterMemberInfo.identity());
                    continue block2;
                }
            }
            this.cachedHostList = arrayList.toArray(this.cachedHostList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean permitActivateWithoutLease(MigratableTargetMBean migratableTargetMBean) {
        if (!this.isJTAMigratableGroup()) {
            return false;
        }
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        return clusterMBean != null && "consensus".equals(clusterMBean.getMigrationBasis()) && MigratableGroup.isAutoServiceMigrationEnabled(clusterMBean);
    }

    private static boolean isAutoServiceMigrationEnabled(ClusterMBean clusterMBean) {
        MigratableTargetMBean[] migratableTargetMBeanArray = clusterMBean.getMigratableTargets();
        if (migratableTargetMBeanArray == null) {
            return false;
        }
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            if ("manual".equals(migratableTargetMBeanArray[i].getMigrationPolicy())) continue;
            return true;
        }
        return false;
    }

    private boolean isJTAMigratableGroup() {
        return this.target instanceof JTAMigratableTargetMBean;
    }

    private boolean isLocalJTAMigratableTarget() {
        if (!this.isJTAMigratableGroup()) {
            return false;
        }
        JTAMigratableTargetMBean jTAMigratableTargetMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getJTAMigratableTarget();
        if (jTAMigratableTargetMBean == null) {
            return false;
        }
        return jTAMigratableTargetMBean.getName().equals(this.target.getName());
    }

    private static boolean isLocalJTAAutoMigratable() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        return serverMBean.getJTAMigratableTarget() != null && "failure-recovery".equals(serverMBean.getJTAMigratableTarget().getMigrationPolicy());
    }

    private void p(Object object) {
        SingletonServicesDebugLogger.debug("MigratableGroup: " + object.toString());
    }

    private boolean executePostScript() {
        boolean bl;
        String string = this.target.getPostScript();
        if (string == null) {
            return true;
        }
        boolean bl2 = bl = !this.target.getMigrationPolicy().equals("manual");
        if (!ScriptExecutor.runNMScript(string, this.target) && this.target.isPostScriptFailureFatal()) {
            this.logPostScriptExecutionFailed();
            if (bl) {
                try {
                    this.updateState(4, null);
                }
                catch (Exception exception) {
                    ClusterExtensionLogger.logFailedToNotifyPostScriptFailureToStateManager((String)this.getName(), (String)string, (Exception)exception);
                }
            }
            return false;
        }
        return true;
    }

    private static SingletonServicesStateManagerRemote getLocalSingletonServicesStateManager() {
        SingletonServicesStateManagerRemote singletonServicesStateManagerRemote = null;
        try {
            Environment environment = new Environment();
            Context context = environment.getInitialContext();
            singletonServicesStateManagerRemote = (SingletonServicesStateManagerRemote)context.lookup("weblogic.cluster.singleton.SingletonServicesStateManager");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return singletonServicesStateManagerRemote;
    }

    public void handlePriorityShutDownTasks() {
        if (this.isActive && this.target.isManualActiveOn(ManagementService.getRuntimeAccess(kernelId).getServer()) && this.target.getMigrationPolicy().equals("failure-recovery")) {
            if (this.isJTAMigratableGroup() && this.isJTAHealthFailed()) {
                if (DEBUG) {
                    this.p("Not marking the state of jta migratable group " + this.getName() + " as shutdown because it is failed");
                }
                return;
            }
            try {
                this.updateState(3, null);
            }
            catch (Exception exception) {
                ClusterLogger.logLeasingError((String)this.target.getName(), (Exception)exception);
            }
        }
    }

    private boolean isJTAHealthFailed() {
        HealthState[] healthStateArray = HealthMonitorService.getHealthStates();
        for (int i = 0; i < healthStateArray.length; ++i) {
            HealthState healthState = healthStateArray[i];
            if (!healthState.getSubsystemName().equals(HEALTH_JTA_SUBSYSTEM_NAME)) continue;
            return healthState.getState() == 3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateState(int n, Serializable serializable) throws Exception {
        SingletonServicesStateManagerRemote singletonServicesStateManagerRemote = MigratableGroup.getLocalSingletonServicesStateManager();
        if (singletonServicesStateManagerRemote == null) throw new Exception("Failed to lookup local state manager to update state of " + this.getName());
        SingletonServicesState singletonServicesState = new SingletonServicesState(n);
        singletonServicesState.setStateData(serializable);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Sender", ManagementService.getRuntimeAccess(kernelId).getServerName());
        hashMap.put("SvcName", this.getName());
        hashMap.put("SvcState", singletonServicesState);
        Boolean bl = (Boolean)singletonServicesStateManagerRemote.invoke(1001, hashMap);
        if (!bl.booleanValue()) throw new Exception("Failed to update state of " + this.getName() + " to " + singletonServicesState);
        if (!DEBUG) return;
        this.p("Updated state of " + this.getName() + " to " + singletonServicesState);
    }

    private void logPostScriptExecutionFailed() {
        ClusterExtensionLogger.logPostDeactivationScriptFailure((String)this.target.getPostScript(), (String)this.target.getName());
    }

    private static class MigratableComparator
    implements Comparator {
        private MigratableComparator() {
        }

        public int compare(Object object, Object object2) {
            Migratable migratable = (Migratable)object;
            Migratable migratable2 = (Migratable)object2;
            if (migratable.getOrder() < migratable2.getOrder()) {
                return -1;
            }
            if (migratable.getOrder() > migratable2.getOrder()) {
                return 1;
            }
            return migratable.toString().compareTo(migratable2.toString());
        }

        public boolean equals(Object object) {
            return object instanceof MigratableComparator;
        }
    }
}

