/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigratableGroup;
import weblogic.cluster.migration.MigratableRemote;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.RemoteMigrationControl;
import weblogic.cluster.singleton.MemberDeathDetectorHeartbeatReceiverIntf;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;
import weblogic.utils.Debug;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.collections.FilteringIterator;
import weblogic.utils.collections.Iterators;

public final class MigrationManager
implements RemoteMigrationControl {
    private static MigrationManager singleton;
    private static final boolean GRACEFUL_SHUTDOWN = true;
    private Map groups;
    private Map migratableToGroup;
    private Map nameToGroup;
    private int state = 0;
    private Map activeTargets;
    private static final AuthenticatedSubject kernelId;
    public static long TIMEOUT;
    private boolean migrating = false;
    private long timestamp = 0L;
    private boolean memberDeathDetectorHeartbeatReceiverEnabled = false;

    public static MigrationManager singleton() {
        return singleton;
    }

    public MigrationManager() {
        Debug.assertion((singleton == null ? 1 : 0) != 0);
        this.groups = new ConcurrentHashMap();
        this.migratableToGroup = new ConcurrentHashMap();
        this.nameToGroup = new ConcurrentHashMap();
        this.activeTargets = new ConcurrentHashMap();
        singleton = this;
    }

    void initialize() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean != null) {
            Environment environment = new Environment();
            environment.setReplicateBindings(false);
            environment.setCreateIntermediateContexts(true);
            try {
                environment.getInitialContext().bind("weblogic.cluster.migrationControl", (Object)singleton);
            }
            catch (NamingException namingException) {
                throw new AssertionError((Object)("Unexpected exception: " + namingException));
            }
        }
        this.state = 3;
    }

    void start() throws MigrationException {
        this.activateAllTargets();
        if (ClusterService.getClusterService().isMemberDeathDetectorEnabled()) {
            ClusterExtensionLogger.logStartingMemberDeathDetectorReceiver();
            try {
                MigrationManager.invokeStaticMethodOnMemberDeathDetectorHeartbeatReceiver("enableHeartbeatReceiver", new Class[0], new Object[0]);
                this.memberDeathDetectorHeartbeatReceiverEnabled = true;
            }
            catch (ServiceFailureException serviceFailureException) {
                System.out.println("Member Death Detector Heartbeat Receiver failed to start. " + (Object)((Object)serviceFailureException));
            }
        }
        this.state = 2;
    }

    void halt() throws MigrationException {
        this.deactivateAllTargets(false);
        this.state = 3;
    }

    void stop() throws MigrationException {
        this.deactivateAllTargets(true);
        if (this.memberDeathDetectorHeartbeatReceiverEnabled) {
            try {
                MemberDeathDetectorHeartbeatReceiverIntf memberDeathDetectorHeartbeatReceiverIntf = this.getMemberDeathDetectorHeartbeatReceiver();
                memberDeathDetectorHeartbeatReceiverIntf.stop();
                this.memberDeathDetectorHeartbeatReceiverEnabled = false;
            }
            catch (ServiceFailureException serviceFailureException) {
                throw new MigrationException((Exception)((Object)serviceFailureException));
            }
        }
        this.state = 3;
    }

    public synchronized void setMigrating(boolean bl) {
        this.migrating = bl;
        if (this.migrating) {
            this.timestamp = System.currentTimeMillis();
        }
    }

    public synchronized boolean isMigrating() {
        if (System.currentTimeMillis() - this.timestamp > TIMEOUT) {
            this.setMigrating(false);
        }
        return this.migrating;
    }

    public MigratableGroup findGroup(String string) {
        return (MigratableGroup)this.groups.get(string);
    }

    public void register(Migratable migratable, MigratableTargetMBean migratableTargetMBean) throws MigrationException {
        this.privateRegister(migratable, null, migratableTargetMBean);
    }

    public void register(MigratableRemote migratableRemote, String string, MigratableTargetMBean migratableTargetMBean) throws MigrationException {
        this.privateRegister(migratableRemote, string, migratableTargetMBean);
        this.nameToGroup.put(string, this.migratableToGroup.get(migratableRemote));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void privateRegister(Migratable migratable, String string, MigratableTargetMBean migratableTargetMBean) throws MigrationException {
        block11: {
            Debug.assertion((migratableTargetMBean.getUserPreferredServer() != null ? 1 : 0) != 0);
            String string2 = migratableTargetMBean.getName();
            MigratableGroup migratableGroup = null;
            if (migratableTargetMBean.isCandidate(ManagementService.getRuntimeAccess(kernelId).getServer())) {
                migratable.migratableInitialize();
            }
            MigrationManager migrationManager = this;
            synchronized (migrationManager) {
                migratableGroup = (MigratableGroup)this.groups.get(string2);
                if (migratableGroup == null) {
                    migratableGroup = new MigratableGroup(migratableTargetMBean);
                    this.groups.put(string2, migratableGroup);
                }
            }
            if (migratableGroup.add(migratable, string)) {
                this.migratableToGroup.put(migratable, migratableGroup);
            }
            boolean bl = migratableTargetMBean.getMigrationPolicy().equals("manual");
            boolean bl2 = migratableTargetMBean instanceof JTAMigratableTargetMBean;
            if ((bl || bl2) && migratableTargetMBean.isManualActiveOn(ManagementService.getRuntimeAccess(kernelId).getServer()) && !migratableGroup.isActive()) {
                try {
                    migratableGroup.activate();
                    this.activeTargets.put(string2, string2);
                    if (bl2) {
                        SingletonServicesManager.getInstance().addActiveService(string2);
                    }
                }
                catch (MigrationException migrationException) {
                    if (migratableTargetMBean.getMigrationPolicy() != null && migratableTargetMBean.getMigrationPolicy().equals("manual")) {
                        throw migrationException;
                    }
                    if (!migrationException.isFatal()) break block11;
                    throw migrationException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Migratable migratable, MigratableTargetMBean migratableTargetMBean) throws MigrationException {
        MigratableGroup migratableGroup = (MigratableGroup)this.groups.get(migratableTargetMBean.getName());
        Debug.assertion((migratableGroup != null ? 1 : 0) != 0);
        MigrationManager migrationManager = this;
        synchronized (migrationManager) {
            if (migratableGroup.remove(migratable)) {
                String string = migratableGroup.clearUpJNDIMap(migratable);
                this.migratableToGroup.remove(migratable);
                if (string != null) {
                    this.nameToGroup.remove(string);
                }
                this.activeTargets.remove(migratableTargetMBean.getName());
            }
        }
    }

    public HostID[] getMigratableHostList(String string) {
        MigratableGroup migratableGroup = (MigratableGroup)this.nameToGroup.get(string);
        if (migratableGroup != null) {
            return migratableGroup.getHostList();
        }
        return null;
    }

    public String[] getMigratableGroupServerList(Migratable migratable) {
        return null;
    }

    public int getMigratableState(Migratable migratable) {
        MigratableGroup migratableGroup = (MigratableGroup)this.migratableToGroup.get(migratable);
        if (migratableGroup != null) {
            return migratableGroup.getMigratableState();
        }
        return 0;
    }

    public int getMigratableState(String string) {
        MigratableGroup migratableGroup = (MigratableGroup)this.groups.get(string);
        if (migratableGroup != null) {
            return migratableGroup.getMigratableState();
        }
        if (this.activeTargets.get(string) != null) {
            return 1;
        }
        return 0;
    }

    public void restartTarget(String string) throws MigrationException {
        MigratableGroup migratableGroup = (MigratableGroup)this.groups.get(string);
        if (migratableGroup == null) {
            throw new MigrationException("Could not find a migratable target   named " + string);
        }
        migratableGroup.restart();
    }

    public void activateTarget(String string) throws MigrationException {
        MigratableGroup migratableGroup = (MigratableGroup)this.groups.get(string);
        if (migratableGroup != null) {
            migratableGroup.activate();
        }
        this.activeTargets.put(string, string);
    }

    public void deactivateTarget(String string, String string2) throws MigrationException {
        MigratableGroup migratableGroup = (MigratableGroup)this.groups.get(string);
        if (migratableGroup != null) {
            migratableGroup.deactivate();
        }
        this.activeTargets.remove(string);
    }

    public Collection activatedTargets() {
        FilteringIterator filteringIterator = new FilteringIterator(this.groups.entrySet().iterator()){

            protected boolean accept(Object object) {
                MigratableGroup migratableGroup = (MigratableGroup)object;
                return migratableGroup.getMigratableState() == 2 || migratableGroup.getMigratableState() == 1;
            }
        };
        ArrayList arrayList = new ArrayList();
        Iterators.addAll(arrayList, (Iterator)filteringIterator);
        return arrayList;
    }

    private void activateAllTargets() throws MigrationException {
        Iterator iterator = this.groups.entrySet().iterator();
        MigratableGroup migratableGroup = null;
        while (iterator.hasNext()) {
            migratableGroup = (MigratableGroup)iterator.next().getValue();
            MigratableTargetMBean migratableTargetMBean = migratableGroup.getTarget();
            if (!migratableTargetMBean.isManualActiveOn(ManagementService.getRuntimeAccess(kernelId).getServer())) continue;
            migratableGroup.activate();
            this.activeTargets.put(migratableTargetMBean.getName(), migratableTargetMBean.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateAllTargets(boolean bl) throws MigrationException {
        Iterator iterator = this.groups.entrySet().iterator();
        MigratableGroup migratableGroup = null;
        while (iterator.hasNext()) {
            migratableGroup = (MigratableGroup)iterator.next().getValue();
            Object object = migratableGroup.activationLock;
            synchronized (object) {
                migratableGroup.shutdown();
                this.activeTargets.remove(migratableGroup.getTarget().getName());
                if (!migratableGroup.getTarget().getMigrationPolicy().equals("manual")) {
                    SingletonServicesManager.getInstance().removeActiveService(migratableGroup.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePriorityShutDownTasks() {
        Iterator iterator = this.groups.entrySet().iterator();
        while (iterator.hasNext()) {
            MigratableGroup migratableGroup = (MigratableGroup)iterator.next().getValue();
            Object object = migratableGroup.activationLock;
            synchronized (object) {
                migratableGroup.handlePriorityShutDownTasks();
            }
        }
    }

    public static void invokeStaticMethodOnMemberDeathDetectorHeartbeatReceiver(String string, Class[] classArray, Object[] objectArray) throws ServiceFailureException {
        try {
            Class clazz = MigrationManager.getMemberDeathDetectorHeartbeatReceiverClass();
            MigrationManager.invokeStaticMethodOnClass(clazz, string, classArray, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new ServiceFailureException("Unable to find class: weblogic.cluster.messaging.internal.MemberDeathDetectorImpl");
        }
    }

    public static void invokeStaticMethodOnClass(Class clazz, String string, Class[] classArray, Object[] objectArray) throws ServiceFailureException {
        try {
            Method method = clazz.getMethod(string, classArray);
            method.invoke(null, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new ServiceFailureException("No such method: weblogic.cluster.messaging.internal.MemberDeathDetectorImpl.exportHeartbeatReceiver()");
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            throw new ServiceFailureException(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new ServiceFailureException(illegalAccessException.getCause());
        }
    }

    public MemberDeathDetectorHeartbeatReceiverIntf getMemberDeathDetectorHeartbeatReceiver() throws ServiceFailureException {
        try {
            Class clazz = MigrationManager.getMemberDeathDetectorHeartbeatReceiverClass();
            Method method = clazz.getMethod("getInstance", new Class[0]);
            method.setAccessible(true);
            return (MemberDeathDetectorHeartbeatReceiverIntf)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new ServiceFailureException("Unable to find class: weblogic.cluster.messaging.internal.MemberDeathDetectorImpl");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new ServiceFailureException("No such method: weblogic.cluster.messaging.internal.MemberDeathDetectorImpl.getInstance()");
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            throw new ServiceFailureException(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new ServiceFailureException(illegalAccessException.getCause());
        }
    }

    private static Class getMemberDeathDetectorHeartbeatReceiverClass() throws ClassNotFoundException {
        Class<?> clazz = Class.forName("weblogic.cluster.messaging.internal.MemberDeathDetectorHeartbeatReceiver");
        return clazz;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        TIMEOUT = 300000L;
    }
}

