/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.security.AccessController;
import java.util.HashSet;
import weblogic.cluster.ClusterTextTextFormatter;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.cluster.migration.management.MigratableServiceCoordinatorRuntime;
import weblogic.cluster.migration.management.MigratableServiceUpdateBeanListener;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.provider.DomainAccessSettable;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.MigratableServiceCoordinatorRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class MigrationService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ClusterTextTextFormatter fmt = new ClusterTextTextFormatter();
    private static MigratableServiceCoordinatorRuntimeMBean coordinator;
    private static final AuthenticatedSubject KERNEL_ID;

    public static MigratableServiceCoordinatorRuntimeMBean getMigrationCoordinator() {
        SecurityHelper.assertIfNotKernel();
        return coordinator;
    }

    private void initialize() throws ServiceFailureException {
        new MigrationManager().initialize();
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            try {
                coordinator = new MigratableServiceCoordinatorRuntime();
                ((DomainAccessSettable)((Object)ManagementService.getDomainAccess(kernelId))).setServerMigrationCoordinator(coordinator);
            }
            catch (ManagementException managementException) {
                throw new ServiceFailureException((Throwable)managementException);
            }
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ClusterMBean[] clusterMBeanArray = domainMBean.getClusters();
        for (int i = 0; i < clusterMBeanArray.length; ++i) {
            this.validateMTConfigs(clusterMBeanArray[i]);
        }
        MigratableTargetMBean[] migratableTargetMBeanArray = domainMBean.getMigratableTargets();
        if (migratableTargetMBeanArray == null) {
            return;
        }
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            MigratableTargetMBean migratableTargetMBean = migratableTargetMBeanArray[i];
            migratableTargetMBean.addBeanUpdateListener(new MigratableServiceUpdateBeanListener());
        }
        domainMBean.addBeanUpdateListener(new MigratableConfiguredListener());
    }

    public void start() throws ServiceFailureException {
        this.initialize();
        try {
            MigrationManager.singleton().start();
        }
        catch (MigrationException migrationException) {
            throw new ServiceFailureException("Failed to activate targets", (Throwable)migrationException);
        }
    }

    public void stop() throws ServiceFailureException {
        try {
            MigrationManager.singleton().stop();
        }
        catch (MigrationException migrationException) {
            throw new ServiceFailureException("Failed to deactivate targets", (Throwable)migrationException);
        }
    }

    public void halt() throws ServiceFailureException {
        try {
            MigrationManager.singleton().halt();
        }
        catch (MigrationException migrationException) {
            throw new ServiceFailureException("Failed to deactivate targets", (Throwable)migrationException);
        }
    }

    private void validateMTConfigs(ClusterMBean clusterMBean) throws ServiceFailureException {
        MigratableTargetMBean[] migratableTargetMBeanArray = clusterMBean.getMigratableTargets();
        boolean bl = false;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            if ("manual".equals(migratableTargetMBeanArray[i].getMigrationPolicy())) continue;
            bl = true;
            ServerMBean[] serverMBeanArray = migratableTargetMBeanArray[i].getConstrainedCandidateServers();
            for (int j = 0; j < serverMBeanArray.length; ++j) {
                hashSet.add(serverMBeanArray[j]);
            }
        }
        if (!bl) {
            return;
        }
        String string = clusterMBean.getMigrationBasis();
        if ("database".equals(string) && clusterMBean.getDataSourceForAutomaticMigration() == null) {
            throw new ServiceFailureException(fmt.getCannotEnableAutoMigrationWithoutLeasing2());
        }
        if ("consensus".equals(string)) {
            for (ServerMBean serverMBean : hashSet) {
                MachineMBean machineMBean = serverMBean.getMachine();
                if (machineMBean == null) {
                    throw new ServiceFailureException(fmt.getNodemanagerRequiredOnCandidateServers(serverMBean.getName()));
                }
                if (machineMBean.getNodeManager() != null) continue;
                throw new ServiceFailureException(fmt.getNodemanagerRequiredOnCandidateServers(serverMBean.getName()));
            }
        }
    }

    static {
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    class MigratableConfiguredListener
    implements BeanUpdateListener {
        MigratableConfiguredListener() {
        }

        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        }

        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                MigratableTargetMBean migratableTargetMBean;
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                if (propertyUpdate.getUpdateType() != 2 || !propertyUpdate.getPropertyName().equals("MigratableTargets")) continue;
                MigratableTargetMBean migratableTargetMBean2 = migratableTargetMBean = (MigratableTargetMBean)propertyUpdate.getAddedObject();
                migratableTargetMBean2.addBeanUpdateListener(new MigratableServiceUpdateBeanListener());
            }
        }

        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        }
    }
}

