/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.RemoteMigratableServiceCoordinator;
import weblogic.cluster.migration.RemoteMigrationControl;
import weblogic.cluster.migration.management.MigratableServiceCoordinatorRuntime;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.DefaultObjectHandler;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.utils.Debug;

public class RemoteMigratableServiceCoordinatorImpl
implements RemoteMigratableServiceCoordinator {
    private MigratableServiceCoordinatorRuntime runtimeMBeanDelegate;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final DebugLogger JTAMigration = DebugLogger.getDebugLogger((String)"DebugJTAMigration");

    public RemoteMigratableServiceCoordinatorImpl(MigratableServiceCoordinatorRuntime migratableServiceCoordinatorRuntime) throws NamingException {
        this.runtimeMBeanDelegate = migratableServiceCoordinatorRuntime;
        Context context = this.getInitialContext();
        context.bind("weblogic.cluster.migration.migratableServiceCoordinator", (Object)this);
    }

    public void migrateJTA(String string, String string2, boolean bl, boolean bl2) throws MigrationException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        JTAMigratableTargetMBean jTAMigratableTargetMBean = domainMBean.lookupServer(string).getJTAMigratableTarget();
        ServerMBean serverMBean = domainMBean.lookupServer(string2);
        if (JTAMigration.isDebugEnabled()) {
            JTAMigration.debug("RemoteMigratableServiceCoordinatorImpl.migrateJTA() migratableTarget=" + jTAMigratableTargetMBean + ",destination=" + serverMBean + ",sourceUp=" + bl + ",destinationUp=" + bl2);
        }
        try {
            this.runtimeMBeanDelegate.migrateJTA(jTAMigratableTargetMBean, serverMBean, bl, bl2);
        }
        catch (weblogic.management.runtime.MigrationException migrationException) {
            throw new MigrationException((Exception)((Object)migrationException));
        }
    }

    public void deactivateJTA(String string, String string2) throws RemoteException, MigrationException {
        String string3 = null;
        try {
            string3 = this.getCurrentLocationOfJTA(string);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new MigrationException("Unexpected exception accessing store", (Exception)((Object)persistentStoreException));
        }
        if (string3 == null || string3.equals(string2)) {
            return;
        }
        Debug.say((String)("Current " + string3 + " destination " + string2));
        RemoteMigrationControl remoteMigrationControl = this.getRemoteMigrationControl(string3);
        if (remoteMigrationControl == null) {
            throw new MigrationException("Failed to contact server " + string3 + " hosting '" + string + "' to deactivate");
        }
        remoteMigrationControl.deactivateTarget(string, string2);
        try {
            this.getPersistentStoreMap().put((Object)string, (Object)string2);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new MigrationException("Failed to contact server " + string3 + " hosting '" + string + "' to deactivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteMigrationControl getRemoteMigrationControl(String string) {
        RemoteMigrationControl remoteMigrationControl;
        Environment environment = new Environment();
        Context context = null;
        try {
            String string2 = URLManager.findAdministrationURL(string);
            if (string2 == null) {
                RemoteMigrationControl remoteMigrationControl2 = null;
                return remoteMigrationControl2;
            }
            environment.setProviderUrl(string2);
            context = environment.getInitialContext();
            remoteMigrationControl = (RemoteMigrationControl)context.lookup("weblogic.cluster.migrationControl");
        }
        catch (NamingException namingException) {
            RemoteMigrationControl remoteMigrationControl3 = null;
            return remoteMigrationControl3;
        }
        catch (UnknownHostException unknownHostException) {
            RemoteMigrationControl remoteMigrationControl4 = null;
            return remoteMigrationControl4;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return remoteMigrationControl;
    }

    private PersistentMap getPersistentStoreMap() throws PersistentStoreException {
        PersistentStore persistentStore = PersistentStoreManager.getManager().getDefaultStore();
        String string = "weblogic_migratable_services_store";
        if (persistentStore == null) {
            throw new PersistentStoreException("No store found");
        }
        return persistentStore.createPersistentMap(string, (ObjectHandler)DefaultObjectHandler.THE_ONE);
    }

    public String getCurrentLocationOfJTA(String string) throws PersistentStoreException {
        return (String)this.getPersistentStoreMap().get((Object)string);
    }

    public void setCurrentLocation(String string, String string2) throws PersistentStoreException {
        this.getPersistentStoreMap().put((Object)string, (Object)string2);
    }

    private Context getInitialContext() throws NamingException {
        Environment environment = new Environment();
        environment.setCreateIntermediateContexts(true);
        return environment.getInitialContext();
    }
}

