/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import weblogic.cluster.ClusterLogger;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ScriptExecutor {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static boolean isNMAvailable(ServerMBean serverMBean) {
        return serverMBean.getMachine() != null;
    }

    public static boolean runNMScript(String string, MigratableTargetMBean migratableTargetMBean) {
        return ScriptExecutor.runNMScript(string, migratableTargetMBean, ManagementService.getRuntimeAccess(kernelId).getServer());
    }

    public static boolean runNMScript(String string, MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean) {
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(serverMBean.getMachine());
        if (migratableTargetMBean == null) {
            return false;
        }
        if (serverMBean == null) {
            return false;
        }
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        if (!ScriptExecutor.isNMAvailable(serverMBean)) {
            ClusterLogger.logMissingMachine((String)serverMBean.getName());
            return false;
        }
        try {
            long l = 0L;
            nodeManagerRuntime.runScript(new File(string), l);
        }
        catch (IOException iOException) {
            ClusterLogger.logScriptFailed((String)string, (Exception)iOException);
            return false;
        }
        return true;
    }
}

