/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration.management;

import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.RemoteMigratableServiceCoordinatorImpl;
import weblogic.cluster.migration.RemoteMigrationControl;
import weblogic.cluster.migration.management.MigrationTask;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditChangesValidationException;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.EditNotEditorException;
import weblogic.management.provider.EditSaveChangesFailedException;
import weblogic.management.provider.EditWaitTimedOutException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.MigratableServiceCoordinatorRuntimeMBean;
import weblogic.management.runtime.MigrationTaskRuntimeMBean;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.DefaultObjectHandler;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.utils.Debug;

public final class MigratableServiceCoordinatorRuntime
extends DomainRuntimeMBeanDelegate
implements MigratableServiceCoordinatorRuntimeMBean {
    private static final int TASK_AFTERLIFE_TIME_MILLIS = 1800000;
    private static final int POLLING_DELAY = 1000;
    public static final String STORE_NAME = "weblogic_migratable_services_store";
    private boolean sysTask = false;
    private DomainMBean domain;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static RemoteMigratableServiceCoordinatorImpl remoteCoordinator;
    Map taskMap = new ConcurrentHashMap();
    private static final AuthenticatedSubject KERNELID;

    public MigratableServiceCoordinatorRuntime() throws ManagementException {
        super("the-MigratableServiceCoordinator");
        try {
            this.domain = ManagementService.getRuntimeAccess(kernelId).getDomain();
            remoteCoordinator = new RemoteMigratableServiceCoordinatorImpl(this);
        }
        catch (NamingException namingException) {
            throw new ManagementException("Failed to create remote migratable service coordinator", (Throwable)namingException);
        }
    }

    public boolean isSystemTask() {
        return this.sysTask;
    }

    public void setSystemTask(boolean bl) {
        this.sysTask = bl;
    }

    public void migrateSingleton(SingletonServiceMBean singletonServiceMBean, ServerMBean serverMBean) throws weblogic.management.runtime.MigrationException {
        ServerMBean[] serverMBeanArray = singletonServiceMBean.getAllCandidateServers();
        SingletonMonitorRemote singletonMonitorRemote = null;
        DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            String string = domainAccess.lookupServerLifecycleRuntime(serverMBeanArray[i].getName()).getState();
            if (!"RUNNING".equals(string)) continue;
            Context context = null;
            Environment environment = new Environment();
            try {
                String string2 = URLManager.findAdministrationURL(serverMBeanArray[i].getName());
                environment.setProviderUrl(string2);
                context = environment.getInitialContext();
                singletonMonitorRemote = (SingletonMonitorRemote)context.lookup("weblogic.cluster.singleton.SingletonMonitorRemote");
                continue;
            }
            catch (NamingException namingException) {
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (singletonMonitorRemote == null) {
            throw new weblogic.management.runtime.MigrationException("No candidate server for " + singletonServiceMBean + " is reachable. " + "The service cannot be migrated until at least one is up.");
        }
        try {
            if (!singletonMonitorRemote.migrate(singletonServiceMBean.getName(), serverMBean.getName())) {
                throw new weblogic.management.runtime.MigrationException("Failed to migrate " + singletonServiceMBean.getName());
            }
            ServerMBean serverMBean2 = singletonServiceMBean.getUserPreferredServer();
            if (serverMBean2 != null && !serverMBean2.getName().equals(serverMBean.getName())) {
                this.changeMigratableTargetsConfiguration(singletonServiceMBean.getName(), serverMBean.getName());
            }
        }
        catch (MigrationException migrationException) {
            throw new weblogic.management.runtime.MigrationException(migrationException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new weblogic.management.runtime.MigrationException("Error while communicating with the Singleton Monitor: " + remoteException, remoteException);
        }
    }

    public void migrate(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean) throws weblogic.management.runtime.MigrationException {
        this.doMigrate(migratableTargetMBean, serverMBean, true, true, false);
    }

    public boolean migrate(String string, String string2) throws RemoteException {
        try {
            this.migrate(this.domain.lookupMigratableTarget(string), this.domain.lookupServer(string2));
            return true;
        }
        catch (weblogic.management.runtime.MigrationException migrationException) {
            throw new RemoteException("Error: " + (Object)((Object)migrationException), (Throwable)((Object)migrationException));
        }
    }

    public void migrate(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, boolean bl, boolean bl2) throws weblogic.management.runtime.MigrationException {
        this.doMigrate(migratableTargetMBean, serverMBean, !bl, !bl2, false);
    }

    public boolean migrate(String string, String string2, boolean bl, boolean bl2) throws RemoteException {
        try {
            this.migrate(this.domain.lookupMigratableTarget(string), this.domain.lookupServer(string2), bl, bl2);
            return true;
        }
        catch (weblogic.management.runtime.MigrationException migrationException) {
            throw new RemoteException("Error: " + (Object)((Object)migrationException), (Throwable)((Object)migrationException));
        }
    }

    public void migrateJTA(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, boolean bl, boolean bl2) throws weblogic.management.runtime.MigrationException {
        this.doMigrate(migratableTargetMBean, serverMBean, !bl, !bl2, true);
    }

    public boolean migrateJTA(String string, String string2, boolean bl, boolean bl2) throws RemoteException {
        try {
            ServerMBean[] serverMBeanArray = this.domain.getServers();
            JTAMigratableTargetMBean jTAMigratableTargetMBean = null;
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                if (!string.equals(serverMBeanArray[i].getJTAMigratableTarget())) continue;
                jTAMigratableTargetMBean = serverMBeanArray[i].getJTAMigratableTarget();
                break;
            }
            this.migrateJTA(jTAMigratableTargetMBean, this.domain.lookupServer(string2), bl, bl2);
            return true;
        }
        catch (weblogic.management.runtime.MigrationException migrationException) {
            throw new RemoteException("Error: " + (Object)((Object)migrationException), (Throwable)((Object)migrationException));
        }
    }

    public MigrationTaskRuntimeMBean startMigrateTask(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, boolean bl) throws ManagementException {
        MigrationTask migrationTask = new MigrationTask(migratableTargetMBean, serverMBean, bl, false, false, this);
        this.taskMap.put(migrationTask.getName(), migrationTask);
        migrationTask.run();
        return migrationTask;
    }

    public void deactivateJTATarget(MigratableTargetMBean migratableTargetMBean, String string) throws weblogic.management.runtime.MigrationException {
        try {
            PersistentMap persistentMap = this.getStoreMap();
            String string2 = (String)persistentMap.get((Object)migratableTargetMBean.getName());
            if (string2 == null || string2.equals(string)) {
                return;
            }
            RemoteMigrationControl remoteMigrationControl = this.getMigrationControl(string);
            remoteMigrationControl.deactivateTarget(migratableTargetMBean.getName(), string);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.management.runtime.MigrationException("Unexpected exception opening store ", persistentStoreException);
        }
        catch (RemoteException remoteException) {
            throw new weblogic.management.runtime.MigrationException("Failed to deactivate " + migratableTargetMBean.getName() + " on " + string, remoteException);
        }
        catch (MigrationException migrationException) {
            throw new weblogic.management.runtime.MigrationException("Failed to deactivate " + migratableTargetMBean.getName() + " on " + string, migrationException);
        }
    }

    private RemoteMigrationControl getMigrationControl(String string) throws weblogic.management.runtime.MigrationException {
        Context context = null;
        try {
            Environment environment = new Environment();
            environment.setProviderUrl(URLManager.findAdministrationURL(string));
            context = environment.getInitialContext();
            return (RemoteMigrationControl)context.lookup("weblogic.cluster.migrationControl");
        }
        catch (UnknownHostException unknownHostException) {
            throw new weblogic.management.runtime.MigrationException("Failed to reach " + string + " to deactivate" + " JTAMigratableTarget", unknownHostException);
        }
        catch (NamingException namingException) {
            throw new weblogic.management.runtime.MigrationException("Unexpected naming exception", namingException);
        }
    }

    public MigrationTaskRuntimeMBean startMigrateTask(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, boolean bl, boolean bl2, boolean bl3) throws ManagementException {
        MigrationTask migrationTask = new MigrationTask(migratableTargetMBean, serverMBean, bl, bl2, bl3, this);
        this.taskMap.put(migrationTask.getName(), migrationTask);
        migrationTask.run();
        return migrationTask;
    }

    public void driveMigrateTaskToEnd(String string, boolean bl, boolean bl2) throws ManagementException {
        MigrationTaskRuntimeMBean migrationTaskRuntimeMBean = this.getTaskRuntimeMBean(string);
        this.driveMigrateTaskToEnd(migrationTaskRuntimeMBean, bl, bl2);
    }

    private void doMigrate(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, boolean bl, boolean bl2, boolean bl3) throws weblogic.management.runtime.MigrationException {
        try {
            MigrationTaskRuntimeMBean migrationTaskRuntimeMBean = this.startMigrateTask(migratableTargetMBean, serverMBean, bl3, bl, bl2);
            this.driveMigrateTaskToEnd(migrationTaskRuntimeMBean, bl, bl2);
            if (migrationTaskRuntimeMBean.getError() != null) {
                if (migrationTaskRuntimeMBean.getError() instanceof weblogic.management.runtime.MigrationException) {
                    throw (weblogic.management.runtime.MigrationException)((Object)migrationTaskRuntimeMBean.getError());
                }
                throw new weblogic.management.runtime.MigrationException(migrationTaskRuntimeMBean.getError());
            }
        }
        catch (ManagementException managementException) {
            throw new weblogic.management.runtime.MigrationException(managementException);
        }
    }

    private void driveMigrateTaskToEnd(MigrationTaskRuntimeMBean migrationTaskRuntimeMBean, boolean bl, boolean bl2) throws ManagementException {
        while (migrationTaskRuntimeMBean.isRunning()) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!migrationTaskRuntimeMBean.isTerminal()) {
            Debug.assertion((boolean)migrationTaskRuntimeMBean.isWaitingForUser());
            if (migrationTaskRuntimeMBean.getStatusCode() == 3) {
                migrationTaskRuntimeMBean.continueWithSourceServerDown(bl);
            } else if (migrationTaskRuntimeMBean.getStatusCode() == 4) {
                migrationTaskRuntimeMBean.continueWithDestinationServerDown(bl2);
            }
            this.driveMigrateTaskToEnd(migrationTaskRuntimeMBean, bl, bl2);
        }
    }

    void updateState(String string, String string2) throws weblogic.management.runtime.MigrationException {
        try {
            PersistentMap persistentMap = this.getStoreMap();
            persistentMap.put((Object)string, (Object)string2);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.management.runtime.MigrationException("Failed to update store", persistentStoreException);
        }
    }

    private PersistentMap getStoreMap() throws PersistentStoreException {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        PersistentStore persistentStore = persistentStoreManager.getDefaultStore();
        return persistentStore.createPersistentMap(STORE_NAME, (ObjectHandler)DefaultObjectHandler.THE_ONE);
    }

    public MigrationTaskRuntimeMBean[] getMigrationTaskRuntimes() {
        return this.taskMap.values().toArray(new MigrationTaskRuntimeMBean[this.taskMap.size()]);
    }

    public void clearOldMigrationTaskRuntimes() {
        for (MigrationTaskRuntimeMBean migrationTaskRuntimeMBean : this.taskMap.values()) {
            if (System.currentTimeMillis() - migrationTaskRuntimeMBean.getEndTime() <= 1800000L) continue;
            this.taskMap.remove(migrationTaskRuntimeMBean.getName());
        }
    }

    private MigrationTaskRuntimeMBean getTaskRuntimeMBean(String string) {
        return (MigrationTaskRuntimeMBean)this.taskMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void changeMigratableTargetsConfiguration(String string, String string2) throws weblogic.management.runtime.MigrationException {
        block15: {
            try {
                Object object;
                Object object2;
                DomainMBean domainMBean = null;
                EditAccess editAccess = ManagementServiceRestricted.getEditAccess(KERNELID);
                boolean bl = false;
                if (editAccess.getEditor() == null || editAccess.isEditorExclusive()) {
                    domainMBean = editAccess.startEdit(120000, 120000);
                    bl = true;
                } else {
                    domainMBean = editAccess.getDomainBeanWithoutLock();
                    bl = false;
                }
                if (string2 != null) {
                    object2 = MigratableServiceCoordinatorRuntime.getServer(domainMBean, string2);
                    object = MigratableServiceCoordinatorRuntime.getMigratableTarget(domainMBean, string);
                    if (object != null) {
                        object.setUserPreferredServer((ServerMBean)object2);
                    } else {
                        SingletonServiceMBean singletonServiceMBean = domainMBean.lookupSingletonService(string);
                        if (singletonServiceMBean != null) {
                            singletonServiceMBean.setUserPreferredServer((ServerMBean)object2);
                        }
                    }
                }
                if (!bl) break block15;
                object2 = null;
                try {
                    editAccess.saveChanges();
                    object2 = editAccess.activateChangesAndWaitForCompletion(120000L);
                    if (object2 == null || object2.getState() == 4) break block15;
                    editAccess.cancelEdit();
                    object = object2.getError() != null ? object2.getError().toString() : "Failed to update config";
                }
                catch (Throwable throwable) {
                    if (object2 != null && object2.getState() != 4) {
                        editAccess.cancelEdit();
                        String string3 = object2.getError() != null ? object2.getError().toString() : "Failed to update config";
                        throw new weblogic.management.runtime.MigrationException(string3, object2.getError());
                    }
                    throw throwable;
                }
                throw new weblogic.management.runtime.MigrationException((String)object, object2.getError());
            }
            catch (EditNotEditorException editNotEditorException) {
                throw new weblogic.management.runtime.MigrationException("Failed to update config", (Throwable)((Object)editNotEditorException));
            }
            catch (EditFailedException editFailedException) {
                throw new weblogic.management.runtime.MigrationException("Failed to update config", (Throwable)((Object)editFailedException));
            }
            catch (EditChangesValidationException editChangesValidationException) {
                throw new weblogic.management.runtime.MigrationException("Failed to update config", (Throwable)((Object)editChangesValidationException));
            }
            catch (EditSaveChangesFailedException editSaveChangesFailedException) {
                throw new weblogic.management.runtime.MigrationException("Failed to update config", (Throwable)((Object)editSaveChangesFailedException));
            }
            catch (EditWaitTimedOutException editWaitTimedOutException) {
                throw new weblogic.management.runtime.MigrationException("Failed to update config", (Throwable)((Object)editWaitTimedOutException));
            }
        }
    }

    private static MigratableTargetMBean getMigratableTarget(DomainMBean domainMBean, String string) {
        MigratableTargetMBean[] migratableTargetMBeanArray = domainMBean.getMigratableTargets();
        if (migratableTargetMBeanArray != null) {
            for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
                if (!migratableTargetMBeanArray[i].getName().equals(string)) continue;
                return migratableTargetMBeanArray[i];
            }
        }
        return null;
    }

    private static ServerMBean getServer(DomainMBean domainMBean, String string) {
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].getName().equals(string)) continue;
            return serverMBeanArray[i];
        }
        return null;
    }

    static {
        KERNELID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

