/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration.management;

import java.security.AccessController;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.cluster.singleton.SingletonServicesDebugLogger;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class MigratableServiceUpdateBeanListener
implements BeanUpdateListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = SingletonServicesDebugLogger.isDebugEnabled();

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        MigratableTargetMBean migratableTargetMBean;
        MigratableTargetMBean migratableTargetMBean2;
        boolean bl;
        if (DEBUG) {
            this.p("Rolling back update: " + beanUpdateEvent);
        }
        if (!(bl = this.isConfigUpdatedForUserPreferredServer(migratableTargetMBean2 = (MigratableTargetMBean)beanUpdateEvent.getProposedBean(), migratableTargetMBean = this.getMigratableTarget(migratableTargetMBean2.getName())))) {
            return;
        }
        MigrationManager migrationManager = MigrationManager.singleton();
        try {
            migrationManager.deactivateTarget(migratableTargetMBean2.getName(), null);
        }
        catch (MigrationException migrationException) {
            ClusterLogger.logFailedToDeactivateMigratableServicesDuringRollback((Exception)migrationException);
        }
    }

    private MigratableTargetMBean getMigratableTarget(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        return domainMBean.lookupMigratableTarget(string);
    }

    private boolean isConfigUpdatedForUserPreferredServer(MigratableTargetMBean migratableTargetMBean, MigratableTargetMBean migratableTargetMBean2) {
        boolean bl = false;
        ServerMBean serverMBean = migratableTargetMBean.getUserPreferredServer();
        if (serverMBean == null) {
            return bl;
        }
        ServerMBean serverMBean2 = migratableTargetMBean2.getUserPreferredServer();
        if (DEBUG) {
            this.p("Intended User Preferred Server - " + serverMBean + " Existing User Preferred Server - " + serverMBean2);
        }
        ServerMBean serverMBean3 = ManagementService.getRuntimeAccess(kernelId).getServer();
        if (serverMBean2 != null) {
            if (!serverMBean.getName().equals(serverMBean2.getName()) && serverMBean.getName().equals(serverMBean3.getName())) {
                bl = true;
            }
        } else if (serverMBean.getName().equals(serverMBean3.getName())) {
            bl = true;
        }
        return bl;
    }

    private void p(Object object) {
        SingletonServicesDebugLogger.debug("MigratableServiceUpdateBeanListener: " + object.toString());
    }
}

