/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration.management;

import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.cluster.migration.RemoteMigratableServiceCoordinator;
import weblogic.cluster.migration.RemoteMigrationControl;
import weblogic.cluster.migration.management.MigratableServiceCoordinatorRuntime;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.runtime.MigrationTaskRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.TaskRuntimeMBean;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public class MigrationTask
extends RuntimeMBeanDelegate
implements MigrationTaskRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final int SECONDS_TO_WAIT_FOR_MIGRATION = 30;
    private static int num = 0;
    private MigratableTargetMBean mt;
    private ServerMBean destination;
    private boolean jta;
    private int status = 0;
    private Exception ex;
    private long startTime;
    private long endTime;
    private StringBuffer log;
    private boolean isSourceServerDown;
    private boolean isDestinationServerDown;
    private String[] statusTextLUT = null;
    private boolean sysTask = false;
    private final MigratableServiceCoordinatorRuntime runtime;
    private ServerMBean currentServer;
    private final ManagementTextTextFormatter texter = ManagementTextTextFormatter.getInstance();
    private final String currentServerURL;
    private final String destinationServerURL;
    private final String currentServerName;
    private final String destinationServerName;

    public MigrationTask(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, boolean bl, boolean bl2, boolean bl3, MigratableServiceCoordinatorRuntime migratableServiceCoordinatorRuntime) throws ManagementException {
        super(ManagementTextTextFormatter.getInstance().getMigrationTaskTitle(migratableTargetMBean != null ? migratableTargetMBean.getName() : "(null)", serverMBean != null ? serverMBean.getName() : "(null)", bl ? "JTA " : "") + "-" + num++, (RuntimeMBean)migratableServiceCoordinatorRuntime);
        this.mt = migratableTargetMBean;
        this.destination = serverMBean;
        this.jta = bl;
        this.isSourceServerDown = bl2 || bl;
        this.isDestinationServerDown = bl3;
        this.log = new StringBuffer(4096);
        this.runtime = migratableServiceCoordinatorRuntime;
        if (bl) {
            try {
                DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
                String string = URLManager.findAdministrationURL(domainMBean.getAdminServerName());
                RemoteMigratableServiceCoordinator remoteMigratableServiceCoordinator = this.getServiceCoordinator(string);
                String string2 = remoteMigratableServiceCoordinator.getCurrentLocationOfJTA(migratableTargetMBean.getName());
                this.currentServer = domainMBean.lookupServer(string2);
                if (this.currentServer == null) {
                    this.currentServer = migratableTargetMBean.getUserPreferredServer();
                }
                Debug.assertion((this.currentServer != null ? 1 : 0) != 0);
                this.currentServerURL = this.getServerAdminURL(this.currentServer.getName());
                this.currentServerName = this.currentServer.getName();
            }
            catch (Exception exception) {
                throw new ManagementException((Throwable)exception);
            }
        } else {
            if (this.isTargetAutoMigratable(migratableTargetMBean)) {
                this.currentServer = migratableTargetMBean.getHostingServer();
                if (this.currentServer == null) {
                    this.isSourceServerDown = true;
                }
            } else {
                this.currentServer = migratableTargetMBean.getUserPreferredServer();
                Debug.assertion((this.currentServer != null ? 1 : 0) != 0);
            }
            if (this.currentServer != null) {
                this.currentServerURL = this.getServerAdminURL(this.currentServer.getName());
                this.currentServerName = this.currentServer.getName();
            } else {
                this.currentServerURL = null;
                this.currentServerName = null;
            }
            if (this.currentServerURL == null) {
                this.isSourceServerDown = true;
            }
        }
        this.destinationServerURL = this.getServerAdminURL(serverMBean.getName());
        this.destinationServerName = serverMBean.getName();
        this.statusTextLUT = new String[]{ManagementTextTextFormatter.getInstance().getMigrationTaskStatusInProgress(), ManagementTextTextFormatter.getInstance().getMigrationTaskStatusDone(), ManagementTextTextFormatter.getInstance().getMigrationTaskStatusFailed(), ManagementTextTextFormatter.getInstance().getMigrationTaskStatusQIsTheSourceServerDown(), ManagementTextTextFormatter.getInstance().getMigrationTaskStatusQIsTheDestinationServerDown(), ManagementTextTextFormatter.getInstance().getMigrationTaskStatusCanceled()};
    }

    public boolean isSystemTask() {
        return this.sysTask;
    }

    private RemoteMigratableServiceCoordinator getServiceCoordinator(String string) throws weblogic.management.runtime.MigrationException {
        Context context = null;
        try {
            Environment environment = new Environment();
            environment.setProviderUrl(string);
            context = environment.getInitialContext();
            return (RemoteMigratableServiceCoordinator)context.lookup("weblogic.cluster.migration.migratableServiceCoordinator");
        }
        catch (NamingException namingException) {
            throw new weblogic.management.runtime.MigrationException("Unexpected naming exception", namingException);
        }
    }

    public String getDescription() {
        return ManagementTextTextFormatter.getInstance().getMigrationTaskTitle(this.mt != null ? this.mt.getName() : "(null)", this.destination != null ? this.destinationServerName : "(null)", this.jta ? "JTA " : "");
    }

    public String getStatus() {
        return this.statusTextLUT[this.status];
    }

    public int getStatusCode() {
        return this.status;
    }

    public synchronized boolean isRunning() {
        return this.status == 0;
    }

    public synchronized boolean isTerminal() {
        return this.status == 5 || this.status == 2 || this.status == 1;
    }

    public boolean isWaitingForUser() {
        return this.status == 3 || this.status == 4;
    }

    public long getBeginTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public synchronized Exception getError() {
        return this.ex;
    }

    public ServerMBean getSourceServer() {
        return this.mt.getUserPreferredServer();
    }

    public ServerMBean getDestinationServer() {
        return this.destination;
    }

    public MigratableTargetMBean getMigratableTarget() {
        return this.mt;
    }

    public boolean isJTA() {
        return this.jta;
    }

    public TaskRuntimeMBean[] getSubTasks() {
        return null;
    }

    public TaskRuntimeMBean getParentTask() {
        return null;
    }

    public void setSystemTask(boolean bl) {
        this.sysTask = bl;
    }

    public void run() {
        WorkAdapter workAdapter = new WorkAdapter(){

            public void run() {
                MigrationTask.this.status = 0;
                MigrationTask.this.startTime = System.currentTimeMillis();
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        try {
                            Object object = MigrationManager.singleton();
                            synchronized (object) {
                                while (MigrationManager.singleton().isMigrating()) {
                                    MigrationManager.singleton().wait(1000L);
                                }
                                MigrationManager.singleton().setMigrating(true);
                                MigrationTask.this.migrate();
                            }
                            object = MigrationTask.this;
                            synchronized (object) {
                                MigrationTask.this.status = 1;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            MigrationTask migrationTask = MigrationTask.this;
                            synchronized (migrationTask) {
                                MigrationTask.this.ex = runtimeException;
                                MigrationTask.this.status = 2;
                            }
                            MigrationTask.this.logLine(runtimeException.toString());
                            MigrationTask.this.logLine(StackTraceUtils.throwable2StackTrace((Throwable)runtimeException));
                        }
                        catch (Exception exception) {
                            MigrationTask migrationTask = MigrationTask.this;
                            synchronized (migrationTask) {
                                MigrationTask.this.ex = exception;
                                MigrationTask.this.status = 2;
                            }
                            MigrationTask.this.logLine(exception.toString());
                            MigrationTask.this.logLine(StackTraceUtils.throwable2StackTrace((Throwable)exception));
                        }
                        finally {
                            MigrationTask.this.endTime = System.currentTimeMillis();
                            MigrationManager migrationManager = MigrationManager.singleton();
                            synchronized (migrationManager) {
                                MigrationManager.singleton().setMigrating(false);
                            }
                        }
                        return null;
                    }
                });
            }

            public String toString() {
                return MigrationTask.this.getDescription();
            }
        };
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)workAdapter);
    }

    public synchronized void cancel() throws Exception {
        if (this.status != 3 && this.status != 4) {
            throw new Exception(ManagementTextTextFormatter.getInstance().getMigrationTaskCannotCancelHere());
        }
        this.status = 5;
        this.notifyAll();
    }

    public void printLog(PrintWriter printWriter) {
        printWriter.print(this.log.toString());
        printWriter.flush();
    }

    public synchronized void continueWithSourceServerDown(boolean bl) {
        Debug.assertion((this.status == 3 ? 1 : 0) != 0);
        this.isSourceServerDown = bl || this.jta;
        this.status = 0;
        this.notifyAll();
    }

    public synchronized void continueWithDestinationServerDown(boolean bl) {
        Debug.assertion((this.status == 4 ? 1 : 0) != 0);
        this.isDestinationServerDown = bl;
        this.status = 0;
        this.notifyAll();
    }

    private void validateConfiguration() throws weblogic.management.runtime.MigrationException {
        this.check(this.mt.getAllCandidateServers().length > 0, this.texter.getMigrationTaskErrorCandidateServerMustNotBeEmpty());
        if (!this.jta) {
            if (this.isTargetAutoMigratable(this.mt)) {
                if (this.currentServer != null) {
                    this.check(!this.currentServer.getName().equals(this.destination.getName()), this.texter.getMigrationTaskErrorDestinationMustNotBeCurrentlyActiveServer());
                }
            } else {
                this.check(!this.mt.isManualActiveOn(this.destination), this.texter.getMigrationTaskErrorDestinationMustNotBeCurrentlyActiveServer());
            }
        }
        this.check(this.isDestinationServerMemberOfCandidateServers(this.destinationServerName), this.texter.getMigrationTaskErrorDestinationMustBeMemberOfCandidiateServers());
    }

    private boolean isDestinationServerMemberOfCandidateServers(String string) {
        ServerMBean[] serverMBeanArray = this.mt.getAllCandidateServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String getServerAdminURL(String string) {
        try {
            return URLManager.findAdministrationURL(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private void migrate() throws weblogic.management.runtime.MigrationException {
        try {
            this.validateConfiguration();
            if (this.jta) {
                this.logLine(this.texter.getMigrationTaskLoglineJTAMigrationStarted(this.mt.getName(), this.destinationServerName));
            } else {
                this.logLine(this.texter.getMigrationTaskLoglineMigrationStarted(this.mt.getName(), this.destinationServerName));
            }
            this.logLine("Destination URL " + this.destinationServerURL + "\t" + this.isDestinationServerDown);
            this.logLine("Source URL " + this.currentServerURL + "\t" + this.isSourceServerDown);
            if (this.destinationServerURL == null && !this.isDestinationServerDown) {
                this.failWith(this.texter.getMigrationTaskUserStopDestinationNotReachable(this.destinationServerName));
            }
            if (this.currentServerURL == null && !this.isSourceServerDown) {
                this.failWith(this.texter.getMigrationTaskLoglineUnableToConnectToCurrentServer(this.currentServerName));
            }
            if (this.jta) {
                this.checkIfRunningServerTlogIsBeingMigrated(this.currentServerURL);
            }
            if (this.isTargetAutoMigratable(this.mt)) {
                ClusterMBean clusterMBean = this.mt.getCluster();
                SingletonMonitorRemote singletonMonitorRemote = this.getSingletonMonitor(clusterMBean);
                if (singletonMonitorRemote == null) {
                    throw new weblogic.management.runtime.MigrationException("Cluster still not started. Please try after sometime.");
                }
                singletonMonitorRemote.migrate(this.mt.getName(), this.destinationServerName);
                if (!this.mt.getUserPreferredServer().getName().equals(this.destinationServerName)) {
                    this.runtime.changeMigratableTargetsConfiguration(this.mt.getName(), this.destinationServerName);
                }
            } else {
                this.deactivateMigratableTarget();
                this.activateMigratableTarget();
                if (!this.jta) {
                    this.runtime.changeMigratableTargetsConfiguration(this.mt.getName(), this.destinationServerName);
                } else {
                    this.runtime.updateState(this.mt.getName(), this.destination.getName());
                }
            }
            this.logLine(this.texter.getActivationSucceeded());
        }
        catch (Exception exception) {
            this.failWith(exception.toString());
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof weblogic.management.runtime.MigrationException) {
                throw (weblogic.management.runtime.MigrationException)((Object)exception);
            }
            throw new weblogic.management.runtime.MigrationException(exception);
        }
    }

    private void deactivateMigratableTarget() throws weblogic.management.runtime.MigrationException {
        if (this.currentServerURL == null) {
            Debug.say((String)("Cannot reach " + this.currentServerName + " to deactivate MT " + this.mt.getName()));
        }
        if (this.currentServerURL != null) {
            Environment environment = new Environment();
            Context context = null;
            RemoteMigrationControl remoteMigrationControl = null;
            try {
                environment.setProviderUrl(this.currentServerURL);
                this.logLine(this.texter.getMigrationTaskLoglineTryingToConnectToCurrentServer(this.currentServerURL));
                context = environment.getInitialContext();
                remoteMigrationControl = (RemoteMigrationControl)context.lookup("weblogic.cluster.migrationControl");
                this.logLine(this.texter.getMigrationTaskLoglineConnectedSuccessfulyToCurrentServer(this.currentServerURL));
                this.logLine(this.texter.getTryingToDeactivateMigratableTarget(this.mt.getName()));
                remoteMigrationControl.deactivateTarget(this.mt.getName(), this.destinationServerName);
                this.logLine(this.texter.getDeactivationSucceeded());
            }
            catch (NamingException namingException) {
                String string = this.texter.getMigrationTaskLoglineUnableToConnectToCurrentServer(this.currentServerURL);
                this.logLine(string);
                throw new weblogic.management.runtime.MigrationException(string);
            }
            catch (MigrationException migrationException) {
                this.logLine(this.texter.getServiceNotDeactivatedOnCurrentHostingServer(this.currentServerName));
                throw new weblogic.management.runtime.MigrationException(this.texter.getServiceWasNotDeactivatedOnCurrentHostingServer(this.currentServerName, migrationException.toString()));
            }
            catch (RemoteException remoteException) {
                this.logLine(this.texter.getLostConnectionToCurrentHostingServerDeactivation(this.currentServerName));
                throw new weblogic.management.runtime.MigrationException(this.texter.getLostConnectionToCurrentHostingServerDeactivationEx(this.currentServerName, remoteException.toString()));
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
        if (!this.isSourceServerDown) {
            throw new weblogic.management.runtime.MigrationException(this.texter.getServiceWasNotDeactivatedOnCurrentHostingServer(this.currentServerName, "Current server is unreachable"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void activateMigratableTarget() throws weblogic.management.runtime.MigrationException {
        if (this.destinationServerURL == null) {
            Debug.say((String)("Cannot reach " + this.destinationServerName + " to activate MT " + this.mt.getName()));
        }
        if (this.destinationServerURL != null) {
            Environment environment = new Environment();
            Context context = null;
            RemoteMigrationControl remoteMigrationControl = null;
            try {
                environment.setProviderUrl(this.destinationServerURL);
                this.logLine(this.texter.getTyingToConnectDestinationServer(this.destinationServerURL));
                context = environment.getInitialContext();
                this.logLine(this.texter.getConnectedSuccessfulyToDestinationServer(this.destinationServerURL));
                remoteMigrationControl = (RemoteMigrationControl)context.lookup("weblogic.cluster.migrationControl");
                this.logLine(this.texter.getTryingToActivateMigratableTarget(this.mt.getName()));
                remoteMigrationControl.activateTarget(this.mt.getName());
                EditAccess editAccess = ManagementServiceRestricted.getEditAccess(kernelId);
                boolean bl = false;
                if (editAccess.getEditor() != null && !editAccess.isEditorExclusive()) {
                    bl = true;
                }
                if (this.isDestinationServerDown || this.jta || bl) return;
                for (int i = 0; i < 30 && remoteMigrationControl.getMigratableState(this.mt.getName()) == 0; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (i != 29) continue;
                    throw new MigrationException("Could not determine state of Migratable services on destination server. Services may not be active.");
                }
                return;
            }
            catch (NamingException namingException) {
                this.logLine(this.texter.getUnableToConnectToDestinationServer(this.destinationServerName, this.destinationServerURL));
                throw new weblogic.management.runtime.MigrationException(this.texter.getUnableToConnectToDestinationServer(this.destinationServerName, this.destinationServerURL));
            }
            catch (MigrationException migrationException) {
                this.logLine(this.texter.getMigratableServiceWasNotActivatedOnDestination(this.destinationServerName));
                throw new weblogic.management.runtime.MigrationException(this.texter.getMigratableServiceWasNotActivatedOnDestinationEx(this.destinationServerName, migrationException.toString()));
            }
            catch (RemoteException remoteException) {
                this.logLine(this.texter.getLostConnectToDestinationServer(this.destinationServerName));
                throw new weblogic.management.runtime.MigrationException(this.texter.getLostConnectToDestinationServerEx(this.destinationServerName, remoteException.toString()));
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
        if (this.isDestinationServerDown) return;
        throw new weblogic.management.runtime.MigrationException(this.texter.getMigratableServiceWasNotActivatedOnDestination(this.destinationServerName));
    }

    private void checkIfRunningServerTlogIsBeingMigrated(String string) throws weblogic.management.runtime.MigrationException {
        if (this.currentServerName.equals(this.mt.getName()) && this.currentServerURL != null) {
            this.logLine(this.texter.getMigrationTaskLoglineCannotMigrateTransactionRecoveryService(this.currentServerName, string));
            throw new weblogic.management.runtime.MigrationException(this.texter.getMigrationTaskLoglineMigrationTaskLoglineCannotMigrateTransactionRecoveryServiceForTheCurrentServiceHost(this.currentServerName));
        }
    }

    private void check(boolean bl, String string) throws weblogic.management.runtime.MigrationException {
        if (!bl) {
            this.failWith(string);
        }
    }

    private void failWith(String string) throws weblogic.management.runtime.MigrationException {
        this.logLine(string);
        this.status = 2;
        throw new weblogic.management.runtime.MigrationException(string);
    }

    private void logLine(String string) {
        ManagementLogger.logMigrationTaskProgressInfo((String)this.getDescription(), (String)string);
        this.log.append(string + "\n");
    }

    private boolean isTargetAutoMigratable(MigratableTargetMBean migratableTargetMBean) {
        return !migratableTargetMBean.getMigrationPolicy().equals("manual");
    }

    private SingletonMonitorRemote getSingletonMonitor(ClusterMBean clusterMBean) {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        SingletonMonitorRemote singletonMonitorRemote = null;
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            singletonMonitorRemote = this.getSingletonMonitorRemote(serverMBeanArray[i].getName());
            if (singletonMonitorRemote == null) continue;
            return singletonMonitorRemote;
        }
        return singletonMonitorRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingletonMonitorRemote getSingletonMonitorRemote(String string) {
        SingletonMonitorRemote singletonMonitorRemote;
        Environment environment = new Environment();
        Context context = null;
        try {
            String string2 = URLManager.findAdministrationURL(string);
            if (string2 == null) {
                SingletonMonitorRemote singletonMonitorRemote2 = null;
                return singletonMonitorRemote2;
            }
            environment.setProviderUrl(string2);
            context = environment.getInitialContext();
            singletonMonitorRemote = (SingletonMonitorRemote)context.lookup("weblogic/cluster/singleton/SingletonMonitorRemote");
        }
        catch (NamingException namingException) {
            SingletonMonitorRemote singletonMonitorRemote3 = null;
            return singletonMonitorRemote3;
        }
        catch (UnknownHostException unknownHostException) {
            SingletonMonitorRemote singletonMonitorRemote4 = null;
            return singletonMonitorRemote4;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return singletonMonitorRemote;
    }
}

