/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.migration.rmiservice;

import java.util.HashMap;
import java.util.Map;
import weblogic.cluster.migration.MigratableRemote;
import weblogic.cluster.migration.MigrationManager;
import weblogic.cluster.migration.rmiservice.Initialization;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.MigratableRMIServiceMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.internal.DeploymentHandlerHome;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.Debug;

public final class MigratableRMIService
extends AbstractServerService
implements DeploymentHandler {
    private boolean debug = true;
    private static MigratableRMIService singleton = null;
    private Map deployments = null;

    public MigratableRMIService() {
        Debug.assertion((singleton == null ? 1 : 0) != 0, (String)"MigratableRMIService singleton already set");
        singleton = this;
        this.deployments = new HashMap();
    }

    public void start() throws ServiceFailureException {
        DeploymentHandlerHome.addDeploymentHandler(this);
    }

    public void stop() throws ServiceFailureException {
        this.shutdown();
    }

    public void halt() throws ServiceFailureException {
        this.shutdown();
    }

    public void shutdown() throws ServiceFailureException {
        DeploymentHandlerHome.removeDeploymentHandler(this);
    }

    private void deploy(MigratableRMIServiceMBean migratableRMIServiceMBean) {
        try {
            if (!this.deployments.containsKey(migratableRMIServiceMBean.getName())) {
                Class<?> clazz = Class.forName(migratableRMIServiceMBean.getClassname());
                Object obj = clazz.newInstance();
                MigratableRemote migratableRemote = (MigratableRemote)obj;
                ((Initialization)((Object)migratableRemote)).initialize(migratableRMIServiceMBean.getArgument());
                Debug.assertion((migratableRMIServiceMBean.getTargets().length == 1 ? 1 : 0) != 0, (String)"[MigratableRMIService] OAM did not localize targets properly!");
                MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)migratableRMIServiceMBean.getTargets()[0];
                String string = migratableRMIServiceMBean.getArgument();
                MigrationManager.singleton().register(migratableRemote, string, migratableTargetMBean);
                this.deployments.put(migratableRMIServiceMBean.getName(), migratableRemote);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void undeploy(MigratableRMIServiceMBean migratableRMIServiceMBean) {
        try {
            MigratableRemote migratableRemote = (MigratableRemote)this.deployments.remove(migratableRMIServiceMBean.getName());
            if (migratableRemote != null) {
                Debug.assertion((migratableRemote != null ? 1 : 0) != 0);
                ((Initialization)((Object)migratableRemote)).destroy(migratableRMIServiceMBean.getArgument());
                Debug.assertion((migratableRMIServiceMBean.getTargets().length == 1 ? 1 : 0) != 0, (String)"[MigratableRMIService] OAM did not localize targets properly!");
                MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)migratableRMIServiceMBean.getTargets()[0];
                String string = migratableRMIServiceMBean.getArgument();
                MigrationManager.singleton().unregister(migratableRemote, migratableTargetMBean);
            } else {
                Debug.say((String)"--> undeploy called but m is null!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof MigratableRMIServiceMBean) {
            try {
                this.deploy((MigratableRMIServiceMBean)deploymentMBean);
            }
            catch (Exception exception) {
                throw new DeploymentException("failed to deploy MigratableRMIServiceMBean " + deploymentMBean.getName(), exception);
            }
        }
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        if (deploymentMBean instanceof MigratableRMIServiceMBean) {
            try {
                this.undeploy((MigratableRMIServiceMBean)deploymentMBean);
            }
            catch (Exception exception) {
                throw new UndeploymentException("failed to undeploy MigratableRMIServiceMBean " + deploymentMBean.getName(), exception);
            }
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
    }
}

