/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.replication.AsyncFlush;
import weblogic.cluster.replication.AsyncQueueDebugLogger;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class AsyncQueueManager
implements PropertyChangeListener {
    private static final int DEFAULT_MIN_CONCURRENCY = 1;
    private static final int DEFAULT_MAX_CONCURRENCY = 1;
    private long asyncSessionQueueTimeout;
    private int UPDATE_SIZE;
    private BlockingQueue updateSet;
    private WorkManager workManager;
    private AsyncFlush flushManager;
    private int updateIndex = 0;
    private Timer updateTimer;
    private long timeAtLastUpdateFlush = 0L;
    private int sessionFlushInterval;
    private TimerManager sessionUpdateFlushTimerManager;
    private boolean greedy = false;

    public AsyncQueueManager(AsyncFlush asyncFlush, boolean bl) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getCluster();
        int n = this.UPDATE_SIZE = clusterMBean.getSessionFlushThreshold() == -1 ? 0 : clusterMBean.getSessionFlushThreshold();
        this.sessionFlushInterval = bl ? (clusterMBean.getGreedySessionFlushInterval() == -1 ? 0 : clusterMBean.getGreedySessionFlushInterval() * 1000) : (clusterMBean.getSessionFlushInterval() == -1 ? 0 : clusterMBean.getSessionFlushInterval() * 1000);
        this.asyncSessionQueueTimeout = clusterMBean.getAsyncSessionQueueTimeout() == -1 ? 0L : (long)clusterMBean.getAsyncSessionQueueTimeout();
        clusterMBean.addPropertyChangeListener(this);
        this.init(asyncFlush, bl);
    }

    public AsyncQueueManager(AsyncFlush asyncFlush, boolean bl, int n, int n2, int n3) {
        this.sessionFlushInterval = n * 1000;
        this.UPDATE_SIZE = n2;
        this.asyncSessionQueueTimeout = n3;
        this.init(asyncFlush, bl);
    }

    private void init(AsyncFlush asyncFlush, boolean bl) {
        this.workManager = WorkManagerFactory.getInstance().findOrCreate("ASYNC_REP_FLUSH_WM", 1, 1);
        this.updateSet = AsyncQueueManager.createUpdateSet(this.UPDATE_SIZE);
        this.flushManager = asyncFlush;
        this.greedy = bl;
        this.sessionUpdateFlushTimerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("asyncSessionUpdateFlushTimerManager", this.workManager);
        this.updateTimer = this.scheduleSessionUpdateTimer();
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SessionFlushThreshold".equals(propertyChangeEvent.getPropertyName())) {
            if (AsyncQueueDebugLogger.isDebugEnabled()) {
                AsyncQueueDebugLogger.debug("SessionFlushThreshold property change has occurred with new value: " + propertyChangeEvent.getNewValue() + " Resetting AsyncQueue max size.");
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.UPDATE_SIZE = n;
        } else if ("SessionFlushInterval".equals(propertyChangeEvent.getPropertyName())) {
            if (AsyncQueueDebugLogger.isDebugEnabled()) {
                AsyncQueueDebugLogger.debug("SessionFlushInterval property change has occurred with new value: " + propertyChangeEvent.getNewValue() + " Will reset timer as appropriate.");
            }
            if (this.greedy) {
                return;
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.sessionFlushInterval = n * 1000;
            this.updateTimer.cancel();
            this.updateTimer = this.scheduleSessionUpdateTimer();
        } else if ("GreedySessionFlushInterval".equals(propertyChangeEvent.getPropertyName())) {
            if (AsyncQueueDebugLogger.isDebugEnabled()) {
                AsyncQueueDebugLogger.debug("GreedySessionFlushInterval property change has occurred with new value: " + propertyChangeEvent.getNewValue() + " This will only change for Greedy Async Queues.");
            }
            if (!this.greedy) {
                return;
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.sessionFlushInterval = n * 1000;
            this.updateTimer.cancel();
            this.updateTimer = this.scheduleSessionUpdateTimer();
        } else if ("AsyncSessionQueueTimeout".equals(propertyChangeEvent.getPropertyName())) {
            if (AsyncQueueDebugLogger.isDebugEnabled()) {
                AsyncQueueDebugLogger.debug("AsyncSessionQueueTimeout property change has occurred with new value: " + propertyChangeEvent.getNewValue() + " Resetting queue blocking timeout.");
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.asyncSessionQueueTimeout = n.intValue();
        }
    }

    private Timer scheduleSessionUpdateTimer() {
        if (AsyncQueueDebugLogger.isDebugEnabled()) {
            AsyncQueueDebugLogger.debug("Session Flush Interval " + this.sessionFlushInterval + "ms" + " and threshold is " + this.UPDATE_SIZE);
        }
        return this.sessionUpdateFlushTimerManager.schedule((TimerListener)new SessionUpdateFlushTrigger(this, this.sessionFlushInterval), (long)this.sessionFlushInterval, (long)this.sessionFlushInterval);
    }

    private static BlockingQueue createUpdateSet(int n) {
        assert (n >= 1);
        return new ArrayBlockingQueue(n);
    }

    public void addToUpdates(Object object) {
        try {
            boolean bl;
            if (!this.updateSet.offer(object, this.asyncSessionQueueTimeout, TimeUnit.SECONDS)) {
                ClusterExtensionLogger.logAsyncReplicationRequestTimeout((String)object.toString());
                return;
            }
            ++this.updateIndex;
            boolean bl2 = bl = this.updateIndex == this.UPDATE_SIZE;
            if (bl) {
                if (AsyncQueueDebugLogger.isDebugEnabled()) {
                    AsyncQueueDebugLogger.debug("The AsyncQueue has reached its maximum size and will schedule a flush");
                }
                this.workManager.schedule((Runnable)new FlushWork(this));
            }
        }
        catch (InterruptedException interruptedException) {
            this.addToUpdates(object);
        }
    }

    long getTimeAtLastUpdateFlush() {
        return this.timeAtLastUpdateFlush;
    }

    int getQueueSize() {
        return this.updateSet != null ? this.updateSet.size() : 0;
    }

    public Iterator iterator() {
        return this.updateSet.iterator();
    }

    public void remove(Object object) {
        this.updateSet.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOnce() {
        if (this.updateSet.isEmpty()) {
            return;
        }
        AsyncQueueManager asyncQueueManager = this;
        synchronized (asyncQueueManager) {
            this.updateIndex = 0;
            this.timeAtLastUpdateFlush = System.currentTimeMillis();
            this.flushManager.flushQueue(this.updateSet);
        }
    }

    public void flush() {
        if (AsyncQueueDebugLogger.isDebugEnabled()) {
            AsyncQueueDebugLogger.debug("AsyncQueueManager flushing with queue size: " + this.updateSet.size() + " for flushManager: " + this.flushManager);
        }
        this.flushOnce();
        if (this.greedy && !this.updateSet.isEmpty()) {
            AsyncQueueDebugLogger.debug("greedy flush again");
            this.flush();
        }
    }

    private static final class FlushWork
    implements Runnable {
        private final AsyncQueueManager manager;

        private FlushWork(AsyncQueueManager asyncQueueManager) {
            this.manager = asyncQueueManager;
        }

        public void run() {
            this.manager.flush();
        }
    }

    private static final class SessionUpdateFlushTrigger
    implements NakedTimerListener {
        private final AsyncQueueManager manager;
        private final int flushPeriod;

        private SessionUpdateFlushTrigger(AsyncQueueManager asyncQueueManager, int n) {
            this.manager = asyncQueueManager;
            this.flushPeriod = n;
        }

        public void timerExpired(Timer timer) {
            if (System.currentTimeMillis() - this.manager.getTimeAtLastUpdateFlush() > (long)this.flushPeriod) {
                this.manager.flush();
            }
        }
    }
}

