/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import javax.naming.NamingException;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.replication.AsyncBatch;
import weblogic.cluster.replication.AsyncBatchFailedException;
import weblogic.cluster.replication.AsyncFlush;
import weblogic.cluster.replication.AsyncQueueManager;
import weblogic.cluster.replication.AsyncReplicatable;
import weblogic.cluster.replication.AsyncReplicationRuntime;
import weblogic.cluster.replication.AsyncUpdate;
import weblogic.cluster.replication.NotFoundException;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.ReplicationDebugLogger;
import weblogic.cluster.replication.ReplicationDetailsDebugLogger;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.replication.ReplicationServices;
import weblogic.cluster.replication.ReplicationServicesInternal;
import weblogic.cluster.replication.WrappedRO;
import weblogic.management.ManagementException;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.ServerShuttingDownException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.HostID;

public class AsyncReplicationManager
extends ReplicationManager
implements AsyncFlush {
    private HostID secondaryHost;
    private AsyncQueueManager queue = new AsyncQueueManager(this, true);

    public static ReplicationManager theOne() {
        return SingletonMaker.singleton;
    }

    public static ReplicationServices services() {
        return AsyncReplicationManager.theOne();
    }

    protected AsyncReplicationManager() {
        this.initializeRuntime();
    }

    protected void initializeRuntime() {
        try {
            new AsyncReplicationRuntime();
        }
        catch (ManagementException managementException) {
            throw new AssertionError((Object)managementException);
        }
    }

    public long getTimeAtLastUpdateFlush() {
        return this.queue != null ? this.queue.getTimeAtLastUpdateFlush() : 0L;
    }

    public int getSessionsWaitingForFlushCount() {
        return this.queue != null ? this.queue.getQueueSize() : 0;
    }

    public static void start() {
        try {
            if (ClusterService.getClusterService().isReplicationTimeoutEnabled()) {
                ServerHelper.exportObject((Remote)AsyncReplicationManager.theOne(), (int)ClusterService.getClusterService().getHeartbeatTimeoutMillis());
            } else {
                ServerHelper.exportObject((Remote)AsyncReplicationManager.theOne());
            }
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)("Failed to export replication system" + remoteException));
        }
    }

    public static void stop() {
        try {
            ServerHelper.unexportObject((Remote)AsyncReplicationManager.theOne(), (boolean)false);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)("Failed to unexport replication system" + remoteException));
        }
        SingletonMaker.singleton.blockingFlush();
    }

    public void unregister(ROID[] rOIDArray, Object object) {
        this.removeFromQueue(rOIDArray);
        super.unregister(rOIDArray, object);
    }

    public synchronized void removeFromQueue(ROID[] rOIDArray) {
        for (int i = 0; i < rOIDArray.length; ++i) {
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                AsyncUpdate asyncUpdate = (AsyncUpdate)iterator.next();
                if (!asyncUpdate.getId().equals(rOIDArray[i])) continue;
                this.queue.remove(asyncUpdate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object updateSecondary(ROID rOID, Serializable serializable, Object object) throws NotFoundException {
        WrappedRO wrappedRO = this.getPrimary(rOID, false, object);
        HostID hostID = wrappedRO.getOtherHost();
        if (hostID != null && hostID.equals(this.getSecondarySelector().getSecondarySrvr())) {
            AsyncReplicatable asyncReplicatable;
            AsyncReplicatable asyncReplicatable2 = asyncReplicatable = (AsyncReplicatable)((Object)serializable);
            synchronized (asyncReplicatable2) {
                if (asyncReplicatable.isQueued()) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Avoided a duplicate update to the queue for " + rOID + " with version: " + wrappedRO.getVersion(object) + " and key: " + object + " and secondary info: " + wrappedRO.getSecondaryROInfo());
                    }
                    return wrappedRO.getSecondaryROInfo();
                }
                asyncReplicatable.setQueued();
            }
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("Adding a new update to the queue for " + rOID + " with version: " + wrappedRO.getVersion(object) + " and key: " + object);
            }
            wrappedRO.incrementVersion(object);
            this.queue.addToUpdates(new AsyncUpdate(rOID, wrappedRO.getVersion(object), asyncReplicatable, object));
        } else {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("No Secondary for this session or Secondary become New Primary or Cluster has changed and we need to choose a new secondary. Hence creating a new Secondary for session " + rOID + " and key: " + object);
            }
            wrappedRO.incrementVersion(object);
            this.createSecondary(wrappedRO, object);
        }
        return wrappedRO.getSecondaryROInfo();
    }

    public void update(AsyncBatch asyncBatch) throws RemoteException {
        AsyncUpdate[] asyncUpdateArray = asyncBatch.getUpdates();
        ArrayList<ROID> arrayList = new ArrayList<ROID>();
        for (int i = 0; i < asyncUpdateArray.length; ++i) {
            if (asyncUpdateArray[i].isUpdate()) {
                try {
                    this.update(asyncUpdateArray[i].getId(), asyncUpdateArray[i].getVersion(), asyncUpdateArray[i].getChange(), asyncUpdateArray[i].getKey());
                }
                catch (Exception exception) {
                    arrayList.add(asyncUpdateArray[i].getId());
                    if (!ReplicationDebugLogger.isDebugEnabled()) continue;
                    ReplicationDebugLogger.debug(asyncUpdateArray[i].getId(), "Error updating secondary with version " + asyncUpdateArray[i].getVersion() + " from " + asyncUpdateArray[i].getPrimaryHost() + " on this server:  " + LOCAL_HOSTID + ". Re-creating secondary.", exception);
                }
                continue;
            }
            this.create(asyncUpdateArray[i].getPrimaryHost(), asyncUpdateArray[i].getVersion(), asyncUpdateArray[i].getId(), asyncUpdateArray[i].getRO());
        }
        if (arrayList.size() > 0) {
            ROID[] rOIDArray = new ROID[arrayList.size()];
            arrayList.toArray(rOIDArray);
            throw new AsyncBatchFailedException(rOIDArray);
        }
    }

    public void blockingFlush() {
        this.queue.flushOnce();
    }

    protected void createSecondary(WrappedRO wrappedRO, Object object) {
        HostID hostID = this.getSecondarySelector().getSecondarySrvr();
        if (hostID == null) {
            hostID = this.secondaryHost;
        }
        if (hostID == null) {
            hostID = wrappedRO.getOtherHost();
        }
        if (this.secondaryHost == null) {
            this.secondaryHost = hostID;
        }
        this.trySecondary(wrappedRO, hostID, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean trySecondary(WrappedRO wrappedRO, HostID hostID, Object object) {
        wrappedRO.setOtherHostInfo(hostID);
        wrappedRO.setOtherHost(hostID);
        if (object == null) {
            Iterator iterator = wrappedRO.keys();
            boolean bl = false;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                bl = this.trySecondary(wrappedRO, hostID, e);
            }
            return bl;
        }
        AsyncReplicatable asyncReplicatable = (AsyncReplicatable)((Object)wrappedRO.getRO(object));
        Serializable serializable = asyncReplicatable.getBatchedChanges();
        synchronized (serializable) {
            if (asyncReplicatable.isQueued()) {
                if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                    ReplicationDetailsDebugLogger.debug("Avoided a duplicate create to the queue for " + wrappedRO.getID() + " with version: " + wrappedRO.getVersion(object) + " and key: " + object + " and secondary info: " + wrappedRO.getSecondaryROInfo());
                }
                return true;
            }
            asyncReplicatable.setQueued();
        }
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "Adding a new create to the queue with version: " + wrappedRO.getVersion(object) + " and key: " + object);
        }
        this.queue.addToUpdates(new AsyncUpdate(LOCAL_HOSTID, wrappedRO.getID(), wrappedRO.getVersion(object), object, asyncReplicatable));
        return true;
    }

    public synchronized void flushQueue(BlockingQueue blockingQueue) {
        HashSet hashSet = new HashSet();
        blockingQueue.drainTo(hashSet);
        this.flush(hashSet);
    }

    protected ReplicationServicesInternal getRepMan(HostID hostID) throws RemoteException {
        if (hostID.isLocal()) {
            return this;
        }
        ReplicationServicesInternal replicationServicesInternal = (ReplicationServicesInternal)this.cache.get(hostID);
        if (replicationServicesInternal == null) {
            try {
                replicationServicesInternal = svcLocator.replicationServicesLookup((ServerIdentity)hostID, AsyncReplicationManager.class);
                this.cache.put(hostID, replicationServicesInternal);
            }
            catch (NamingException namingException) {
                throw new RemoteException(namingException.getMessage(), namingException);
            }
        }
        return replicationServicesInternal;
    }

    protected ReplicationServicesInternal getRepManWithChannelName(HostID hostID, String string) throws RemoteException {
        ReplicationServicesInternal replicationServicesInternal;
        try {
            replicationServicesInternal = svcLocator.replicationServicesLookup((ServerIdentity)hostID, string, AsyncReplicationManager.class);
        }
        catch (NamingException namingException) {
            throw new RemoteException(namingException.getMessage(), namingException);
        }
        return replicationServicesInternal;
    }

    public void flush(Set set) {
        HostID hostID;
        if (ReplicationDebugLogger.isDebugEnabled()) {
            ReplicationDebugLogger.debug("FLUSH");
        }
        if ((hostID = this.getSecondarySelector().getSecondarySrvr()) != null && !hostID.equals(this.secondaryHost)) {
            this.resetSecondaryHost(hostID, set);
            this.secondaryHost = hostID;
        }
        while (hostID != null) {
            block25: {
                try {
                    ReplicationServicesInternal replicationServicesInternal = this.getRepMan(hostID);
                    int n = set.size();
                    AsyncUpdate[] asyncUpdateArray = new AsyncUpdate[n];
                    set.toArray(asyncUpdateArray);
                    AsyncBatch asyncBatch = new AsyncBatch(asyncUpdateArray);
                    replicationServicesInternal.update(asyncBatch);
                    AsyncReplicationManager.resetTimeOut(hostID);
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("AsyncBatch flushed to " + hostID);
                    }
                    return;
                }
                catch (ConnectException connectException) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Failed to reach secondary server " + hostID + " trying to create/update secondary for batch", connectException);
                    }
                    this.cleanupDeadServer(hostID);
                }
                catch (ServerShuttingDownException serverShuttingDownException) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Secondary server " + hostID + " is shutting down. Failed to create/update secondary '" + hostID + "' for batch", serverShuttingDownException);
                    }
                    this.cleanupDeadServer(hostID);
                }
                catch (ConnectIOException connectIOException) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("ConnectIOException while trying to connect to secondary server " + hostID + " for " + "creating/updating secondary '" + hostID + "' for batch", connectIOException);
                    }
                    this.cleanupDeadServer(hostID);
                }
                catch (MarshalException marshalException) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Marshalling error", marshalException);
                    }
                    ClusterLogger.logUnableToUpdateNonSerializableObject((Exception)marshalException);
                    if (marshalException.detail instanceof NotSerializableException) {
                        this.decrementUpdates(set);
                    }
                    return;
                }
                catch (UnmarshalException unmarshalException) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Unmarshalling error", unmarshalException);
                    }
                    ClusterLogger.logUnableToUpdateNonSerializableObject((Exception)unmarshalException);
                    if (unmarshalException.detail instanceof NotSerializableException) {
                        this.decrementUpdates(set);
                    }
                    return;
                }
                catch (AsyncBatchFailedException asyncBatchFailedException) {
                    if (ReplicationDebugLogger.isDebugEnabled()) {
                        ReplicationDebugLogger.debug("AsyncBatchFailed updating secondary for batch on " + hostID + ". Re-creating secondaries.");
                    }
                    set = this.recreateList(asyncBatchFailedException.getIDs(), hostID, set);
                    this.flush(set);
                    return;
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    ClusterExtensionLogger.logUnexpectedExceptionDuringReplication((Throwable)remoteRuntimeException.getCause());
                    return;
                }
                catch (RequestTimeoutException requestTimeoutException) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Error sending batched sessions on " + hostID, requestTimeoutException);
                    }
                    this.cleanupDeadServer(hostID);
                }
                catch (RemoteException remoteException) {
                    if (!ReplicationDetailsDebugLogger.isDebugEnabled()) break block25;
                    ReplicationDetailsDebugLogger.debug("Error creating secondary for batched sessions on " + hostID, remoteException);
                }
            }
            if ((hostID = this.getSecondarySelector().getSecondarySrvr()) == null) continue;
            this.secondaryHost = hostID;
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("Recreating secondaries on " + hostID);
            }
            this.resetSecondaryHost(hostID, set);
        }
        this.secondaryHost = null;
        this.resetSecondaryHost(this.secondaryHost, set);
        if (ReplicationDebugLogger.isDebugEnabled()) {
            ReplicationDebugLogger.debug("Unable to create secondarys for async batch on " + hostID);
        }
    }

    private Set recreateList(ROID[] rOIDArray, HostID hostID, Set set) {
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug("Recreating list for retry on secondary: " + hostID);
        }
        HashSet<AsyncUpdate> hashSet = new HashSet<AsyncUpdate>();
        for (int i = 0; i < rOIDArray.length; ++i) {
            for (AsyncUpdate asyncUpdate : set) {
                if (!asyncUpdate.getId().equals(rOIDArray[i])) continue;
                this.resetSecondary(hostID, asyncUpdate);
                hashSet.add(asyncUpdate);
            }
        }
        return hashSet;
    }

    private void decrementUpdates(Set set) {
        for (AsyncUpdate asyncUpdate : set) {
            WrappedRO wrappedRO;
            if (!asyncUpdate.isUpdate() || (wrappedRO = this.wroMan.find(asyncUpdate.getId())) == null) continue;
            wrappedRO.decrementVersion(asyncUpdate.getRO().getKey());
        }
    }

    private void resetSecondaryHost(HostID hostID, Set set) {
        for (AsyncUpdate asyncUpdate : set) {
            this.resetSecondary(hostID, asyncUpdate);
        }
    }

    private void resetSecondary(HostID hostID, AsyncUpdate asyncUpdate) {
        asyncUpdate.recreate(LOCAL_HOSTID);
        WrappedRO wrappedRO = this.wroMan.find(asyncUpdate.getId());
        if (wrappedRO == null) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("Problem setting new secondary for " + asyncUpdate.getId());
            }
            return;
        }
        wrappedRO.setOtherHost(hostID);
        wrappedRO.setOtherHostInfo(hostID);
    }

    private static class SingletonMaker {
        private static final AsyncReplicationManager singleton = new AsyncReplicationManager();

        private SingletonMaker() {
        }
    }
}

