/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.cluster.replication.AsyncReplicatable;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.Replicatable;
import weblogic.rmi.spi.HostID;

public class AsyncUpdate
implements Externalizable {
    static final long serialVersionUID = -9097910107368943550L;
    private boolean update;
    private ROID id;
    private int version;
    private Serializable change = null;
    private Object key;
    private HostID primaryHost = null;
    private Replicatable ro = null;
    private transient AsyncReplicatable aro = null;

    public AsyncUpdate(ROID rOID, int n, AsyncReplicatable asyncReplicatable, Object object) {
        this.id = rOID;
        this.version = n;
        this.aro = asyncReplicatable;
        this.change = asyncReplicatable.getBatchedChanges();
        this.key = object;
        this.update = true;
    }

    public AsyncUpdate(HostID hostID, ROID rOID, int n, Object object, AsyncReplicatable asyncReplicatable) {
        this.primaryHost = hostID;
        this.id = rOID;
        this.version = n;
        this.key = object;
        this.aro = asyncReplicatable;
        this.ro = (Replicatable)((Object)asyncReplicatable);
        this.update = false;
    }

    public void recreate(HostID hostID) {
        if (this.update) {
            this.ro = (Replicatable)((Object)this.aro);
            this.update = false;
            this.change = null;
            this.primaryHost = hostID;
        }
    }

    public void commit() {
        this.aro.commit();
    }

    public AsyncUpdate() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.update);
        if (this.update) {
            this.writeForUpdate(objectOutput);
        } else {
            this.writeForCreate(objectOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeForUpdate(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
        objectOutput.writeInt(this.version);
        Serializable serializable = this.change;
        synchronized (serializable) {
            objectOutput.writeObject(this.change);
            this.aro.commit();
        }
        objectOutput.writeObject(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeForCreate(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
        objectOutput.writeInt(this.version);
        objectOutput.writeObject(this.key);
        objectOutput.writeObject(this.primaryHost);
        Serializable serializable = this.aro.getBatchedChanges();
        synchronized (serializable) {
            objectOutput.writeObject(this.ro);
            this.aro.commit();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.update = objectInput.readBoolean();
        if (this.update) {
            this.readForUpdate(objectInput);
        } else {
            this.readForCreate(objectInput);
        }
    }

    public void readForUpdate(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (ROID)objectInput.readObject();
        this.version = objectInput.readInt();
        this.change = (Serializable)objectInput.readObject();
        this.key = objectInput.readObject();
    }

    public void readForCreate(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (ROID)objectInput.readObject();
        this.version = objectInput.readInt();
        this.key = objectInput.readObject();
        this.primaryHost = (HostID)objectInput.readObject();
        this.ro = (Replicatable)objectInput.readObject();
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.version;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        try {
            AsyncUpdate asyncUpdate = (AsyncUpdate)object;
            return this.hashCode() == asyncUpdate.hashCode() && this.version == asyncUpdate.getVersion() && this.getId().equals(asyncUpdate.getId());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public Serializable getChange() {
        return this.change;
    }

    public ROID getId() {
        return this.id;
    }

    public Object getKey() {
        return this.key;
    }

    public int getVersion() {
        return this.version;
    }

    public HostID getPrimaryHost() {
        return this.primaryHost;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public Replicatable getRO() {
        return this.ro;
    }
}

