/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.replication.AsyncReplicationManager;
import weblogic.cluster.replication.ReplicationDebugLogger;
import weblogic.cluster.replication.ReplicationDetailsDebugLogger;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.replication.SecondarySelector;
import weblogic.cluster.replication.WrappedRO;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class LocalSecondarySelector
implements ClusterMembersChangeListener,
SecondarySelector {
    private static final HostID LOCAL_HOSTID = LocalServerIdentity.getIdentity();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final String machineName;
    private final String preferredSecondaryGroup;
    private final HashSet serverInfos;
    private final WorkManager workManager;
    private boolean clusterHasSecondarySrvrs;
    private boolean placeSecondariesAutomatically;
    private final ArrayList preferredCandidates = new ArrayList();
    private final ArrayList remoteCandidates = new ArrayList();
    private final ArrayList localCandidates = new ArrayList();
    private HostID currentSecondary = null;
    private final MachineServerMap localMap;
    private final ArrayList machineList = new ArrayList();

    public static SecondarySelector getSecondarySelector() {
        return SingletonMaker.singleton;
    }

    protected LocalSecondarySelector() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.machineName = serverMBean.getMachine() == null ? ClusterHelper.getMachineName() : serverMBean.getMachine().getName();
        this.preferredSecondaryGroup = serverMBean.getPreferredSecondaryGroup();
        String string = serverMBean.getReplicationGroup();
        this.placeSecondariesAutomatically = this.preferredSecondaryGroup == null || string == null;
        this.serverInfos = new HashSet();
        if (serverMBean.getCluster() != null) {
            ClusterService.getClusterService().addClusterMembersListener(this);
        }
        this.workManager = WorkManagerFactory.getInstance().getSystem();
        this.localMap = new MachineServerMap(this.machineName);
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        ServerIdentity serverIdentity = clusterMembersChangeEvent.getClusterMemberInfo().identity();
        switch (clusterMembersChangeEvent.getAction()) {
            case 0: {
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ClusterLogger.logNewServerJoinedCluster((String)serverIdentity.toString());
                }
                this.addNewServer(clusterMembersChangeEvent.getClusterMemberInfo());
                break;
            }
            case 2: {
                ClusterLogger.logUpdatingServerInTheCluster((String)serverIdentity.toString());
                this.addNewServer(clusterMembersChangeEvent.getClusterMemberInfo());
                break;
            }
            case 1: {
                Iterator<WrappedRO> iterator;
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ClusterLogger.logRemovingServerFromCluster((String)serverIdentity.toString());
                }
                this.removeDeadServer(clusterMembersChangeEvent.getClusterMemberInfo());
                Iterator<WrappedRO> iterator2 = ReplicationManager.theOne().ids();
                if (iterator2.hasNext()) {
                    this.workManager.schedule((Runnable)new ChangeSecondaryInfo(iterator2, (HostID)serverIdentity));
                }
                if (!(iterator = AsyncReplicationManager.theOne().ids()).hasNext()) break;
                this.workManager.schedule((Runnable)new ChangeSecondaryInfo(iterator, (HostID)serverIdentity));
            }
        }
    }

    public synchronized HostID getSecondarySrvr() {
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug("Has secondary servers? " + this.clusterHasSecondarySrvrs);
            ReplicationDetailsDebugLogger.debug("Current secondary server? " + this.currentSecondary);
        }
        if (this.clusterHasSecondarySrvrs) {
            if (this.currentSecondary != null) {
                return this.currentSecondary;
            }
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("Preferred list : " + this.preferredCandidates);
                ReplicationDetailsDebugLogger.debug("Remote list : " + this.remoteCandidates);
                ReplicationDetailsDebugLogger.debug("Local list : " + this.localCandidates);
            }
            this.currentSecondary = this.placeSecondariesAutomatically ? this.selectSecondaryAutomatically() : this.selectSecondaryBasedOnConfig();
            if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug("New secondary server is " + this.currentSecondary);
            }
        }
        return this.currentSecondary;
    }

    private HostID selectSecondaryAutomatically() {
        int n = this.localMap.getServerList().indexOf(LOCAL_HOSTID);
        int n2 = this.machineList.size();
        if (n2 > 1) {
            int n3 = this.machineList.indexOf(this.localMap);
            ArrayList arrayList = new ArrayList();
            for (int i = 1; i < n2; ++i) {
                MachineServerMap machineServerMap = (MachineServerMap)this.machineList.get((i + n3) % n2);
                List list = machineServerMap.getServerList();
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ReplicationDebugLogger.debug("localServerList size " + this.localMap.getServerList().size() + "\n machineName " + machineServerMap.machineName + "\n remoteServerList size " + list.size() + "\n currSrvrIndex " + n);
                }
                if (list.size() > n) {
                    return (HostID)list.get(n);
                }
                arrayList.addAll(list);
            }
            return (HostID)arrayList.get(n % arrayList.size());
        }
        List list = this.localMap.getServerList();
        int n4 = list.size();
        if (n4 == 1) {
            return null;
        }
        return (HostID)list.get((n + 1) % n4);
    }

    private HostID selectSecondaryBasedOnConfig() {
        HostID hostID;
        int n = this.preferredCandidates.size();
        int n2 = this.remoteCandidates.size();
        int n3 = this.localCandidates.size();
        if (n > n3) {
            ArrayList arrayList = this.getCombinedCandidates(this.localCandidates, this.remoteCandidates);
            hostID = (HostID)this.preferredCandidates.get(arrayList.indexOf(LOCAL_HOSTID) % n);
        } else if (n > 0) {
            hostID = (HostID)this.preferredCandidates.get(this.localCandidates.indexOf(LOCAL_HOSTID) % n);
        } else if (n2 > n3) {
            ArrayList arrayList = this.getCombinedCandidates(this.localCandidates, this.remoteCandidates);
            hostID = (HostID)this.remoteCandidates.get(arrayList.indexOf(LOCAL_HOSTID) % n2);
        } else {
            hostID = n2 > 0 ? (HostID)this.remoteCandidates.get(this.localCandidates.indexOf(LOCAL_HOSTID) % n2) : (HostID)this.localCandidates.get((this.localCandidates.indexOf(LOCAL_HOSTID) + 1) % n3);
        }
        return hostID;
    }

    private ArrayList getCombinedCandidates(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2.size() == 0) {
            return arrayList;
        }
        if (arrayList.size() == 0) {
            return arrayList2;
        }
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(arrayList);
        treeSet.addAll(arrayList2);
        ArrayList arrayList3 = new ArrayList();
        arrayList3.addAll((Collection)treeSet.clone());
        return arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSecondaryCandidates() {
        ArrayList arrayList = new ArrayList();
        if (this.placeSecondariesAutomatically) {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                iterator = ((Collection)this.machineList.clone()).iterator();
            }
            while (iterator.hasNext()) {
                object = (MachineServerMap)iterator.next();
                Iterator iterator2 = ((MachineServerMap)object).getServerList().iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
            }
        } else {
            arrayList.addAll((Collection)this.preferredCandidates.clone());
            arrayList.addAll((Collection)this.remoteCandidates.clone());
            arrayList.addAll((Collection)this.localCandidates.clone());
        }
        arrayList.remove(LOCAL_HOSTID);
        return arrayList;
    }

    public synchronized void removeDeadSecondarySrvr(HostID hostID) {
        for (ClusterMemberInfo clusterMemberInfo : this.serverInfos) {
            if (!clusterMemberInfo.identity().equals(hostID)) continue;
            this.removeDeadServer(clusterMemberInfo);
            break;
        }
        if (ReplicationDebugLogger.isDebugEnabled()) {
            if (this.clusterHasSecondarySrvrs) {
                ReplicationDebugLogger.debug("Unreachable secondary server: " + hostID + " New secondary server " + this.getSecondarySrvr());
            } else {
                ReplicationDebugLogger.debug("Unreachable secondary server: " + hostID + " and there are no secondary servers currently available to replication");
            }
        }
    }

    private synchronized void addNewServer(ClusterMemberInfo clusterMemberInfo) {
        this.serverInfos.add(clusterMemberInfo);
        if (clusterMemberInfo.replicationGroup() == null || clusterMemberInfo.preferredSecondaryGroup() == null) {
            this.placeSecondariesAutomatically = true;
        }
        this.reset();
    }

    private synchronized void removeDeadServer(ClusterMemberInfo clusterMemberInfo) {
        this.serverInfos.remove(clusterMemberInfo);
        this.reset();
    }

    private void reset() {
        this.currentSecondary = null;
        if (this.placeSecondariesAutomatically) {
            this.recomputeSecondaryAutomatically((Collection)this.serverInfos.clone());
        } else {
            this.recomputeSecondary((Collection)this.serverInfos.clone());
        }
        this.clusterHasSecondarySrvrs = this.clusterHasSecondaryServers();
        if (ReplicationDetailsDebugLogger.isDebugEnabled() && this.clusterHasSecondarySrvrs) {
            HostID hostID = this.getSecondarySrvr();
            ReplicationDetailsDebugLogger.debug("Secondary server " + hostID);
        }
    }

    private boolean clusterHasSecondaryServers() {
        return this.preferredCandidates.size() > 0 || this.remoteCandidates.size() > 0 || this.localCandidates.size() > 1 || this.machineList.size() > 0 || this.localMap.getServerList().size() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeSecondaryAutomatically(Collection collection) {
        Object object;
        Object object22;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.localMap.reset();
        this.localMap.addServer(LOCAL_HOSTID);
        hashMap.put(this.machineName, this.localMap);
        for (Object object22 : collection) {
            object = (MachineServerMap)hashMap.get(object22.machineName());
            if (object == null) {
                object = new MachineServerMap(object22.machineName());
                hashMap.put(object22.machineName(), object);
            }
            ((MachineServerMap)object).addServer((HostID)object22.identity());
            if (!ReplicationDetailsDebugLogger.isDebugEnabled()) continue;
            this.printDebug((ClusterMemberInfo)object22);
        }
        object22 = new TreeSet();
        ((TreeSet)object22).addAll(hashMap.values());
        object = this;
        synchronized (object) {
            this.machineList.clear();
            this.machineList.addAll(object22);
        }
    }

    private void printDebug(ClusterMemberInfo clusterMemberInfo) {
        ReplicationDetailsDebugLogger.debug("**Processing " + clusterMemberInfo.identity() + " : " + clusterMemberInfo.serverName() + " on " + clusterMemberInfo.machineName() + " in " + clusterMemberInfo.replicationGroup() + " prefers " + clusterMemberInfo.preferredSecondaryGroup());
    }

    private void recomputeSecondary(Collection collection) {
        TreeSet<ServerIdentity> treeSet = new TreeSet<ServerIdentity>();
        TreeSet<ServerIdentity> treeSet2 = new TreeSet<ServerIdentity>();
        TreeSet<ServerIdentity> treeSet3 = new TreeSet<ServerIdentity>();
        TreeSet<Object> treeSet4 = new TreeSet<Object>();
        treeSet4.add(LOCAL_HOSTID);
        for (ClusterMemberInfo clusterMemberInfo : collection) {
            if (this.preferredSecondaryGroup.equals(clusterMemberInfo.replicationGroup())) {
                if (this.isServerOnSameMachine(clusterMemberInfo)) {
                    treeSet3.add(clusterMemberInfo.identity());
                } else {
                    treeSet.add(clusterMemberInfo.identity());
                }
            } else if (this.isServerOnSameMachine(clusterMemberInfo)) {
                treeSet4.add(clusterMemberInfo.identity());
            } else {
                treeSet2.add(clusterMemberInfo.identity());
            }
            if (!ReplicationDetailsDebugLogger.isDebugEnabled()) continue;
            this.printDebug(clusterMemberInfo);
        }
        this.preferredCandidates.clear();
        this.remoteCandidates.clear();
        this.localCandidates.clear();
        this.preferredCandidates.addAll(treeSet);
        this.preferredCandidates.addAll(treeSet3);
        this.remoteCandidates.addAll(treeSet2);
        this.localCandidates.addAll(treeSet4);
    }

    private boolean isServerOnSameMachine(ClusterMemberInfo clusterMemberInfo) {
        return this.machineName.equals(clusterMemberInfo.machineName());
    }

    private static class ChangeSecondaryInfo
    implements Runnable {
        private final Iterator iterator;
        private final HostID hostID;

        private ChangeSecondaryInfo(Iterator iterator, HostID hostID) {
            this.iterator = iterator;
            this.hostID = hostID;
        }

        public void run() {
            int n = 0;
            long l = System.currentTimeMillis();
            while (this.iterator.hasNext()) {
                WrappedRO wrappedRO = (WrappedRO)this.iterator.next();
                if (!this.hostID.equals(wrappedRO.getOtherHost())) continue;
                wrappedRO.setOtherHost(null);
                wrappedRO.setOtherHostInfo(null);
                wrappedRO.ensureStatus((byte)0);
                ++n;
            }
            long l2 = System.currentTimeMillis();
            if (n > 0 && ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug("Changed the status of " + n + " objects and it took " + (l2 - l) + " ms");
            }
        }
    }

    private static class MachineServerMap
    implements Comparable {
        private final TreeSet set = new TreeSet();
        private final String machineName;

        private MachineServerMap(String string) {
            this.machineName = string;
        }

        public synchronized void addServer(HostID hostID) {
            this.set.add(hostID);
        }

        public void reset() {
            this.set.clear();
        }

        public synchronized List getServerList() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.set);
            return arrayList;
        }

        public boolean equals(Object object) {
            if (object instanceof MachineServerMap) {
                MachineServerMap machineServerMap = (MachineServerMap)object;
                return this.machineName.equals(machineServerMap.machineName);
            }
            return false;
        }

        public int hashCode() {
            return this.machineName.hashCode();
        }

        public int compareTo(Object object) {
            try {
                MachineServerMap machineServerMap = (MachineServerMap)object;
                return this.machineName.compareTo(machineServerMap.machineName);
            }
            catch (ClassCastException classCastException) {
                throw new AssertionError((Object)("Unexpected exception" + classCastException));
            }
        }
    }

    private static class SingletonMaker {
        private static final LocalSecondarySelector singleton = new LocalSecondarySelector();

        private SingletonMaker() {
        }
    }
}

