/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import javax.naming.NamingException;
import weblogic.cluster.replication.AsyncReplicationManager;
import weblogic.cluster.replication.MANAsyncReplicationRuntime;
import weblogic.cluster.replication.RemoteClusterSecondarySelector;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.replication.ReplicationServices;
import weblogic.cluster.replication.ReplicationServicesInternal;
import weblogic.cluster.replication.SecondarySelector;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class MANAsyncReplicationManager
extends AsyncReplicationManager {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private RemoteClusterSecondarySelector remoteSelector = RemoteClusterSecondarySelector.getSecondarySelector();

    public static ReplicationManager theOne() {
        return SingletonMaker.singleton;
    }

    public static ReplicationServices services() {
        return MANAsyncReplicationManager.theOne();
    }

    public static void start() {
        try {
            ServerHelper.exportObject((Remote)MANAsyncReplicationManager.theOne());
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)("Failed to export replication system" + remoteException));
        }
    }

    public static void stop() {
        try {
            ServerHelper.unexportObject((Remote)MANAsyncReplicationManager.theOne(), (boolean)false);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)("Failed to unexport replication system" + remoteException));
        }
    }

    private MANAsyncReplicationManager() {
    }

    protected void initializeRuntime() {
        try {
            new MANAsyncReplicationRuntime(ManagementService.getRuntimeAccess(kernelId).getServerName(), this);
        }
        catch (ManagementException managementException) {
            throw new AssertionError((Object)managementException);
        }
    }

    protected SecondarySelector getSecondarySelector() {
        return this.remoteSelector;
    }

    protected ReplicationServicesInternal getRepMan(HostID hostID) throws RemoteException {
        if (hostID.isLocal()) {
            return this;
        }
        ReplicationServicesInternal replicationServicesInternal = (ReplicationServicesInternal)this.cache.get(hostID);
        if (replicationServicesInternal == null) {
            try {
                replicationServicesInternal = svcLocator.replicationServicesLookup((ServerIdentity)hostID, this.remoteSelector.getReplicationChannelFor(hostID), MANAsyncReplicationManager.class);
            }
            catch (NamingException namingException) {
                throw new RemoteException(namingException.getMessage(), namingException);
            }
            this.cache.put(hostID, replicationServicesInternal);
        }
        return replicationServicesInternal;
    }

    private static class SingletonMaker {
        private static final MANAsyncReplicationManager singleton = new MANAsyncReplicationManager();

        private SingletonMaker() {
        }
    }
}

