/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.security.AccessController;
import weblogic.cluster.replication.RemoteClusterSecondarySelector;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.MANReplicationRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class MANReplicationRuntime
extends RuntimeMBeanDelegate
implements MANReplicationRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected ReplicationManager manager;

    public MANReplicationRuntime(String string, ReplicationManager replicationManager) throws ManagementException {
        super(string);
        this.manager = replicationManager;
        this.registerRuntime();
    }

    protected void registerRuntime() {
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setMANReplicationRuntime(this);
    }

    public String[] getActiveServersInRemoteCluster() {
        return RemoteClusterSecondarySelector.getSecondarySelector().getActiveServersInRemoteCluster();
    }

    public String[] getDetailedSecondariesDistribution() {
        return this.manager.getSecondaryDistributionNames();
    }

    public long getPrimaryCount() {
        return this.manager.getPrimaryCount();
    }

    public long getSecondaryCount() {
        return this.manager.getSecondaryCount();
    }

    public boolean getRemoteClusterReachable() {
        return RemoteClusterSecondarySelector.getSecondarySelector().canReplicateToRemoteCluster();
    }

    public String getSecondaryServerDetails() {
        HostID hostID = RemoteClusterSecondarySelector.getSecondarySelector().getSecondarySrvr();
        if (hostID != null) {
            return hostID.toString();
        }
        return "";
    }

    public String getSecondaryServerName() {
        ServerIdentity serverIdentity = (ServerIdentity)RemoteClusterSecondarySelector.getSecondarySelector().getSecondarySrvr();
        if (serverIdentity != null) {
            return serverIdentity.getServerName();
        }
        return "";
    }
}

