/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import weblogic.rjvm.LocalRJVM;
import weblogic.utils.io.DataIO;

public final class ROID
implements Externalizable {
    private static final long serialVersionUID = -7737873844013713694L;
    private static final long differentiator;
    private static long numObjects;
    private static final byte[] pk;
    private static final Object NUM_OBJ_INC_LOCK;
    private long value;
    private int hashValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ROID create() {
        long l;
        Object object = NUM_OBJ_INC_LOCK;
        synchronized (object) {
            l = numObjects++;
        }
        return new ROID(differentiator + l);
    }

    private ROID(long l) {
        this.value = l;
        this.computeHash();
    }

    public ROID() {
    }

    private void computeHash() {
        this.hashValue = (int)(this.value ^ this.value >> 32);
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ROID) {
            ROID rOID = (ROID)object;
            return this.value == rOID.value;
        }
        return false;
    }

    public String toString() {
        return "" + this.value;
    }

    public int getValueAsInt() {
        return (int)this.value;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        DataIO.writeLong((OutputStream)((OutputStream)((Object)objectOutput)), (long)this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = DataIO.readLong((InputStream)((InputStream)((Object)objectInput)));
        this.computeHash();
    }

    static {
        numObjects = 0L;
        pk = LocalRJVM.getLocalRJVM().getPublicKey();
        NUM_OBJ_INC_LOCK = new Object();
        long l = 0L;
        for (int i = 0; i < pk.length; ++i) {
            l = l << 8 ^ l ^ (long)pk[i];
        }
        differentiator = l;
    }
}

