/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.RemoteClusterMemberManager;
import weblogic.cluster.RemoteClusterMembersChangeListener;
import weblogic.cluster.replication.LocalSecondarySelector;
import weblogic.cluster.replication.MANAsyncReplicationManager;
import weblogic.cluster.replication.MANReplicationManager;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.ReplicationDebugLogger;
import weblogic.cluster.replication.ReplicationDetailsDebugLogger;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.replication.ReplicationServicesInternal;
import weblogic.cluster.replication.SecondarySelector;
import weblogic.cluster.replication.WrappedRO;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class RemoteClusterSecondarySelector
implements ClusterMembersChangeListener,
RemoteClusterMembersChangeListener,
SecondarySelector {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final HostID LOCAL_HOSTID = LocalServerIdentity.getIdentity();
    private final Map hostIDToRepChannelMap = new ConcurrentHashMap(11);
    private final WorkManager workManager = WorkManagerFactory.getInstance().getSystem();
    private final HashSet remoteServerInfos = new HashSet();
    private final HashSet localServerInfos = new HashSet();
    private HostID secondaryHostID;

    public static RemoteClusterSecondarySelector getSecondarySelector() {
        return SingletonMaker.singleton;
    }

    private RemoteClusterSecondarySelector() {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean != null) {
            ClusterService clusterService = ClusterService.getClusterService();
            clusterService.addClusterMembersListener(this);
            this.localServerInfos.add(clusterService.getLocalMember());
        }
        RemoteClusterMemberManager.getInstance().addRemoteClusterMemberListener(this);
    }

    public synchronized void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        this.secondaryHostID = null;
        ServerIdentity serverIdentity = clusterMembersChangeEvent.getClusterMemberInfo().identity();
        switch (clusterMembersChangeEvent.getAction()) {
            case 0: {
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ClusterLogger.logNewServerJoinedCluster((String)serverIdentity.toString());
                }
                this.addNewLocalClusterServer(clusterMembersChangeEvent.getClusterMemberInfo());
                break;
            }
            case 2: {
                this.addNewLocalClusterServer(clusterMembersChangeEvent.getClusterMemberInfo());
                break;
            }
            case 1: {
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ClusterLogger.logRemovingServerFromCluster((String)serverIdentity.toString());
                }
                this.localServerInfos.remove(clusterMembersChangeEvent.getClusterMemberInfo());
                if (ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown()) break;
                HostID[] hostIDArray = new HostID[]{serverIdentity};
                Iterator<WrappedRO> iterator = MANReplicationManager.theOne().ids();
                this.workManager.schedule((Runnable)new ChangeSecondaryInfo(iterator, hostIDArray, MANReplicationManager.theOne()));
                Iterator<WrappedRO> iterator2 = MANAsyncReplicationManager.theOne().ids();
                this.workManager.schedule((Runnable)new ChangeSecondaryInfo(iterator2, hostIDArray, MANAsyncReplicationManager.theOne()));
            }
        }
    }

    private void addNewLocalClusterServer(ClusterMemberInfo clusterMemberInfo) {
        this.localServerInfos.add(clusterMemberInfo);
        this.hostIDToRepChannelMap.put(clusterMemberInfo.identity(), clusterMemberInfo.replicationChannel());
    }

    public synchronized void remoteClusterMembersChanged(ArrayList arrayList) {
        Object object2;
        this.secondaryHostID = null;
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug("Received new cluster list from remote cluster " + arrayList);
        }
        this.remoteServerInfos.clear();
        this.hostIDToRepChannelMap.clear();
        int n = arrayList.size();
        if (n > 0) {
            this.remoteServerInfos.addAll(arrayList);
        }
        for (int i = 0; i < n; ++i) {
            object2 = (ClusterMemberInfo)arrayList.get(i);
            this.hostIDToRepChannelMap.put(object2.identity(), object2.replicationChannel());
        }
        for (Object object2 : this.localServerInfos) {
            this.hostIDToRepChannelMap.put(object2.identity(), object2.replicationChannel());
        }
        if (!this.canReplicateToRemoteCluster()) {
            HostID[] hostIDArray;
            object2 = (HashSet)this.localServerInfos.clone();
            Iterator iterator = ((HashSet)object2).iterator();
            ArrayList<ServerIdentity> arrayList2 = new ArrayList<ServerIdentity>(((HashSet)object2).size());
            while (iterator.hasNext()) {
                hostIDArray = (HostID[])iterator.next();
                if (hostIDArray.identity().equals(LOCAL_HOSTID)) continue;
                arrayList2.add(hostIDArray.identity());
            }
            hostIDArray = new HostID[arrayList2.size()];
            arrayList2.toArray(hostIDArray);
            Iterator<WrappedRO> iterator2 = MANReplicationManager.theOne().ids();
            this.workManager.schedule((Runnable)new ChangeSecondaryInfo(iterator2, hostIDArray, MANReplicationManager.theOne()));
            Iterator<WrappedRO> iterator3 = MANAsyncReplicationManager.theOne().ids();
            this.workManager.schedule((Runnable)new ChangeSecondaryInfo(iterator3, hostIDArray, MANAsyncReplicationManager.theOne()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostID getSecondarySrvr() {
        if (this.secondaryHostID != null) {
            return this.secondaryHostID;
        }
        RemoteClusterSecondarySelector remoteClusterSecondarySelector = this;
        synchronized (remoteClusterSecondarySelector) {
            this.secondaryHostID = this.canReplicateToRemoteCluster() ? this.selectSecondaryFromRemoteCluster() : (this.canReplicateToLocalCluster() ? this.selectSecondaryBasedOnLoad() : null);
        }
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug("New Secondary server " + this.secondaryHostID);
        }
        return this.secondaryHostID;
    }

    synchronized boolean canReplicateToRemoteCluster() {
        int n = this.localServerInfos.size();
        int n2 = this.remoteServerInfos.size();
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug("RemoteClusterSecondarySelector.canReplicateToRemoteCluster(): Local: " + n + " Remote: " + n2 + " canReplicateToRemote " + (n <= 2 * n2 ? "TRUE" : "FALSE"));
        }
        return n <= 2 * n2;
    }

    synchronized String getReplicationChannelFor(HostID hostID) {
        return (String)this.hostIDToRepChannelMap.get(hostID);
    }

    private boolean canReplicateToLocalCluster() {
        int n = this.localServerInfos.size();
        int n2 = this.remoteServerInfos.size();
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug("RemoteClusterSecondarySelector.canReplicateToRemoteCluster(): Local: " + n + " Remote: " + n2 + " canReplicateToRemote " + (n + n2 >= 2 ? "TRUE" : "FALSE"));
        }
        return n + n2 >= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSecondaryCandidates() {
        Iterator iterator;
        ArrayList<ServerIdentity> arrayList = new ArrayList<ServerIdentity>();
        Object object = this;
        synchronized (object) {
            iterator = ((HashSet)this.remoteServerInfos.clone()).iterator();
        }
        while (iterator.hasNext()) {
            object = (ClusterMemberInfo)iterator.next();
            arrayList.add(object.identity());
        }
        arrayList.addAll(LocalSecondarySelector.getSecondarySelector().getSecondaryCandidates());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getActiveServersInRemoteCluster() {
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this;
        synchronized (stringArray) {
            iterator = ((HashSet)this.remoteServerInfos.clone()).iterator();
        }
        while (iterator.hasNext()) {
            stringArray = (ClusterMemberInfo)iterator.next();
            arrayList.add(stringArray.serverName());
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private HostID selectSecondaryFromRemoteCluster() {
        TreeSet<ServerIdentity> treeSet = new TreeSet<ServerIdentity>();
        TreeSet<ServerIdentity> treeSet2 = new TreeSet<ServerIdentity>();
        for (ClusterMemberInfo clusterMemberInfo : (HashSet)this.remoteServerInfos.clone()) {
            treeSet.add(clusterMemberInfo.identity());
        }
        for (ClusterMemberInfo clusterMemberInfo : (HashSet)this.localServerInfos.clone()) {
            treeSet2.add(clusterMemberInfo.identity());
        }
        int n = treeSet.size();
        ArrayList arrayList = new ArrayList(treeSet);
        ArrayList arrayList2 = new ArrayList(treeSet2);
        int n2 = arrayList2.indexOf(LOCAL_HOSTID);
        return (HostID)arrayList.get(n2 % n);
    }

    private HostID selectSecondaryBasedOnLoad() {
        TreeSet<ServerIdentity> treeSet = new TreeSet<ServerIdentity>();
        TreeSet<ServerIdentity> treeSet2 = new TreeSet<ServerIdentity>();
        for (ClusterMemberInfo clusterMemberInfo : (HashSet)this.remoteServerInfos.clone()) {
            treeSet.add(clusterMemberInfo.identity());
        }
        for (ClusterMemberInfo clusterMemberInfo : (HashSet)this.localServerInfos.clone()) {
            if (this.isServerOnSameMachine(clusterMemberInfo)) {
                treeSet2.add(clusterMemberInfo.identity());
                continue;
            }
            treeSet.add(clusterMemberInfo.identity());
        }
        int n = treeSet.size();
        int n2 = treeSet2.size();
        ArrayList arrayList = new ArrayList(treeSet);
        ArrayList arrayList2 = new ArrayList(treeSet2);
        int n3 = arrayList2.indexOf(LOCAL_HOSTID);
        if (n == 0) {
            return (HostID)arrayList2.get((n3 + 1) % n2);
        }
        return (HostID)arrayList.get(n3 % n);
    }

    private boolean isServerOnSameMachine(ClusterMemberInfo clusterMemberInfo) {
        try {
            new ServerSocket(0, 0, InetAddress.getByName(clusterMemberInfo.hostAddress()));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized void removeDeadSecondarySrvr(HostID hostID) {
        ClusterMemberInfo clusterMemberInfo;
        if (hostID.equals(this.secondaryHostID)) {
            this.secondaryHostID = null;
        }
        boolean bl = false;
        Iterator iterator = this.remoteServerInfos.iterator();
        while (iterator.hasNext()) {
            clusterMemberInfo = (ClusterMemberInfo)iterator.next();
            if (!clusterMemberInfo.identity().equals(hostID)) continue;
            iterator.remove();
            bl = true;
            break;
        }
        if (!bl) {
            iterator = this.localServerInfos.iterator();
            while (iterator.hasNext()) {
                clusterMemberInfo = (ClusterMemberInfo)iterator.next();
                if (!clusterMemberInfo.identity().equals(hostID)) continue;
                iterator.remove();
                break;
            }
        }
        this.hostIDToRepChannelMap.remove(hostID);
    }

    private static class ChangeSecondaryInfo
    implements Runnable {
        private final Iterator iterator;
        private final HostID[] hostIDs;
        private final HashMap hostIDToROIDMap;
        private final ReplicationManager mngr;

        private ChangeSecondaryInfo(Iterator iterator, HostID[] hostIDArray, ReplicationManager replicationManager) {
            this.iterator = iterator;
            this.hostIDs = hostIDArray;
            this.hostIDToROIDMap = new HashMap();
            this.mngr = replicationManager;
        }

        public void run() {
            int n = 0;
            long l = System.currentTimeMillis();
            for (int i = 0; i < this.hostIDs.length; ++i) {
                ArrayList<ROID> arrayList = (ArrayList<ROID>)this.hostIDToROIDMap.get(this.hostIDs[i]);
                if (arrayList == null) {
                    arrayList = new ArrayList<ROID>();
                    this.hostIDToROIDMap.put(this.hostIDs[i], arrayList);
                }
                while (this.iterator.hasNext()) {
                    WrappedRO wrappedRO = (WrappedRO)this.iterator.next();
                    if (!this.hostIDs[i].equals(wrappedRO.getOtherHost())) continue;
                    arrayList.add(wrappedRO.getROInfo().getROID());
                    wrappedRO.setOtherHost(null);
                    wrappedRO.setOtherHostInfo(null);
                    wrappedRO.ensureStatus((byte)0);
                    ++n;
                }
            }
            long l2 = System.currentTimeMillis();
            for (int i = 0; i < this.hostIDs.length; ++i) {
                ArrayList arrayList = (ArrayList)this.hostIDToROIDMap.get(this.hostIDs[i]);
                int n2 = arrayList.size();
                if (n2 <= 0) continue;
                try {
                    ReplicationServicesInternal replicationServicesInternal = this.mngr.getRepMan(this.hostIDs[i]);
                    ROID[] rOIDArray = new ROID[n2];
                    arrayList.toArray(rOIDArray);
                    replicationServicesInternal.remove(rOIDArray);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (n > 0 && ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("Changed the status of " + n + " objects and it took " + (l2 - l) + " ms");
            }
        }
    }

    private static class SingletonMaker {
        private static final RemoteClusterSecondarySelector singleton = new RemoteClusterSecondarySelector();

        private SingletonMaker() {
        }
    }
}

