/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.replication.ApplicationUnavailableException;
import weblogic.cluster.replication.AsyncBatch;
import weblogic.cluster.replication.LocalSecondarySelector;
import weblogic.cluster.replication.NotFoundException;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.ROInfo;
import weblogic.cluster.replication.Replicatable;
import weblogic.cluster.replication.ReplicationDebugLogger;
import weblogic.cluster.replication.ReplicationDetailsDebugLogger;
import weblogic.cluster.replication.ReplicationServiceLocator;
import weblogic.cluster.replication.ReplicationServices;
import weblogic.cluster.replication.ReplicationServicesInternal;
import weblogic.cluster.replication.SecondarySelector;
import weblogic.cluster.replication.WrappedRO;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.ServerShuttingDownException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.HostID;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.ChannelService;
import weblogic.utils.collections.NumericValueHashtable;
import weblogic.utils.collections.WeakConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationManager
implements ReplicationServices,
ReplicationServicesInternal {
    private static final boolean DELL_FLAG = false;
    protected static final HostID LOCAL_HOSTID = LocalServerIdentity.getIdentity();
    static String[] replicationChannels;
    private static final int MAX_LOG_MESSAGES = 1000;
    private static int counter;
    protected final wroManager wroMan;
    protected static SecondarySelector selector;
    protected static ReplicationServiceLocator svcLocator;
    protected final Map cache = new WeakConcurrentHashMap(11);
    protected final Map cache2 = new WeakConcurrentHashMap(11);

    public static ReplicationManager theOne() {
        return SingletonMaker.singleton;
    }

    public static void start() throws ServiceFailureException {
        try {
            if (ClusterService.getClusterService().isReplicationTimeoutEnabled()) {
                ServerHelper.exportObject((Remote)ReplicationManager.theOne(), (int)ClusterService.getClusterService().getHeartbeatTimeoutMillis());
            } else {
                ServerHelper.exportObject((Remote)ReplicationManager.theOne());
            }
            List<String> list = ChannelService.getReplicationChannelNames();
            if (list.size() > 0) {
                replicationChannels = new String[list.size()];
                replicationChannels = list.toArray(replicationChannels);
                ClusterExtensionLogger.logUsingMultipleChannelsForReplication((String)Arrays.toString(replicationChannels));
                if (ClusterService.getClusterService().useOneWayRMI()) {
                    ClusterExtensionLogger.logUsingOneWayRMIForReplication();
                }
            } else if (ClusterService.getClusterService().useOneWayRMI()) {
                ClusterExtensionLogger.logIgnoringOneWayRMIWithoutMultipleChannels();
            }
        }
        catch (RemoteException remoteException) {
            throw new ServiceFailureException(remoteException.getMessage());
        }
    }

    public static void stop() {
        try {
            ServerHelper.unexportObject((Remote)ReplicationManager.theOne(), (boolean)false);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)("Failed to unexport replication system" + remoteException));
        }
    }

    protected ReplicationManager() {
        this.wroMan = new wroManager();
        if (selector == null) {
            selector = LocalSecondarySelector.getSecondarySelector();
        }
        if (svcLocator == null) {
            svcLocator = new ReplicationServiceLocator();
        }
    }

    public static ReplicationServices services() {
        return ReplicationManager.theOne();
    }

    @Override
    public final ROInfo register(Replicatable replicatable) {
        return this.add(ROID.create(), replicatable);
    }

    @Override
    public ROInfo add(ROID rOID, Replicatable replicatable) {
        WrappedRO wrappedRO = this.wroMan.create(replicatable, rOID, (byte)0, 0);
        this.createSecondary(wrappedRO, replicatable.getKey());
        return wrappedRO.getROInfo();
    }

    @Override
    public final Replicatable lookup(ROID rOID, Object object) throws NotFoundException {
        WrappedRO wrappedRO = this.getPrimary(rOID, true, object);
        return wrappedRO.getRO(object);
    }

    @Override
    public final Replicatable invalidationLookup(ROID rOID, Object object) throws NotFoundException {
        WrappedRO wrappedRO = this.wroMan.find(rOID);
        if (wrappedRO != null) {
            return wrappedRO.getRO(object);
        }
        throw new NotFoundException("Failed to located " + rOID);
    }

    @Override
    public final Replicatable registerLocally(HostID hostID, ROID rOID, Object object) throws RemoteException {
        ROObject rOObject;
        if (ReplicationDebugLogger.isDebugEnabled()) {
            ReplicationDebugLogger.debug(rOID, "Fetching replicatable object from remote server " + hostID);
        }
        ReplicationServicesInternal replicationServicesInternal = this.getRepMan(hostID);
        try {
            rOObject = replicationServicesInternal.fetch(rOID);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        catch (ConnectException connectException) {
            return null;
        }
        ReplicationManager.resetTimeOut(hostID);
        Map map = rOObject.getROS();
        if (map.get(object) == null) {
            return null;
        }
        WrappedRO wrappedRO = this.wroMan.create((Replicatable)map.get(object), rOID, (byte)0, rOObject.getVersion(object));
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            if (k.equals(object)) continue;
            Replicatable replicatable = (Replicatable)entry.getValue();
            wrappedRO.addRO(replicatable, rOObject.getVersion(k));
        }
        this.createSecondary(wrappedRO, null);
        ReplicationManager.resetTimeOut(hostID);
        return wrappedRO.getRO(object);
    }

    @Override
    public final void removeOrphanedSecondary(ROID rOID, Object object) {
        WrappedRO wrappedRO = this.wroMan.remove(rOID, object);
        if (wrappedRO != null) {
            if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(rOID, "Removed orphaned secondary");
            }
        } else if (ReplicationDebugLogger.isDebugEnabled()) {
            ReplicationDebugLogger.debug(rOID, "Attempt to remove non-existent object");
        }
    }

    @Override
    public final Object getSecondaryInfo(ROID rOID) throws NotFoundException {
        WrappedRO wrappedRO = this.getPrimary(rOID, false, null);
        return wrappedRO.getSecondaryROInfo();
    }

    @Override
    public final void unregister(ROID rOID, Object object) {
        this.unregister(new ROID[]{rOID}, object);
    }

    @Override
    public void unregister(ROID[] rOIDArray, Object object) {
        if (replicationChannels != null) {
            this.unregisterWithMultipleChannels(rOIDArray, object);
        } else {
            this.unregisterWithoutMultipleChannels(rOIDArray, object);
        }
    }

    private void unregisterWithMultipleChannels(ROID[] rOIDArray, Object object) {
        Object object2;
        HashMap<CompositeKey, ArrayList<ROID>> hashMap = new HashMap<CompositeKey, ArrayList<ROID>>();
        for (ROID serializable : rOIDArray) {
            HostID hostID;
            object2 = this.wroMan.remove(serializable, object);
            if (object2 == null || (hostID = ((WrappedRO)object2).getOtherHost()) == null) continue;
            CompositeKey compositeKey = new CompositeKey(hostID, replicationChannels[((WrappedRO)object2).channelIndex]);
            ArrayList<ROID> arrayList = (ArrayList<ROID>)hashMap.get(compositeKey);
            if (arrayList == null) {
                arrayList = new ArrayList<ROID>();
                hashMap.put(compositeKey, arrayList);
            }
            arrayList.add(serializable);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList arrayList = (ArrayList)entry.getValue();
            ROID[] rOIDArray2 = new ROID[arrayList.size()];
            try {
                object2 = this.getRepMan(((CompositeKey)entry.getKey()).hostID, ((CompositeKey)entry.getKey()).channelName);
                if (ClusterService.getClusterService().useOneWayRMI()) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Using Multi-Channels for 1-way removeOneWay() on channel " + ((CompositeKey)entry.getKey()).channelName);
                    }
                    object2.removeOneWay(arrayList.toArray(rOIDArray2), object);
                } else {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Using Multiple-Channels for 2-way remove() on channel " + ((CompositeKey)entry.getKey()).channelName);
                    }
                    object2.remove(arrayList.toArray(rOIDArray2), object);
                }
                ReplicationManager.resetTimeOut(((CompositeKey)entry.getKey()).hostID);
            }
            catch (RemoteException remoteException) {
                if (!ReplicationDebugLogger.isDebugEnabled()) continue;
                ReplicationDebugLogger.debug("Unable to reach " + ((CompositeKey)entry.getKey()).hostID + " to remove roids: " + Arrays.asList((Object[])rOIDArray2));
            }
        }
    }

    private void unregisterWithoutMultipleChannels(ROID[] rOIDArray, Object object) {
        Object object2;
        HashMap<HostID, ArrayList<ROID>> hashMap = new HashMap<HostID, ArrayList<ROID>>();
        for (ROID serializable : rOIDArray) {
            HostID hostID;
            object2 = this.wroMan.remove(serializable, object);
            if (object2 == null || (hostID = ((WrappedRO)object2).getOtherHost()) == null) continue;
            ArrayList<ROID> arrayList = (ArrayList<ROID>)hashMap.get(hostID);
            if (arrayList == null) {
                arrayList = new ArrayList<ROID>();
                hashMap.put(hostID, arrayList);
            }
            arrayList.add(serializable);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList arrayList = (ArrayList)entry.getValue();
            ROID[] rOIDArray2 = new ROID[arrayList.size()];
            try {
                object2 = this.getRepMan((HostID)entry.getKey());
                if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                    ReplicationDetailsDebugLogger.debug("Using Single-Channel for 2-way remove()");
                }
                object2.remove(arrayList.toArray(rOIDArray2), object);
                ReplicationManager.resetTimeOut((HostID)entry.getKey());
            }
            catch (RemoteException remoteException) {
                if (!ReplicationDebugLogger.isDebugEnabled()) continue;
                ReplicationDebugLogger.debug("Unable to reach " + entry.getKey() + " to remove roids: " + Arrays.asList((Object[])rOIDArray2));
            }
        }
    }

    @Override
    public Object updateSecondary(ROID rOID, Serializable serializable, Object object) throws NotFoundException {
        if (serializable == null) {
            WrappedRO wrappedRO = this.getPrimary(rOID, true, object);
            return wrappedRO.getSecondaryROInfo();
        }
        WrappedRO wrappedRO = this.getPrimary(rOID, false, object);
        HostID hostID = wrappedRO.getOtherHost();
        if (hostID != null) {
            block12: {
                try {
                    this.sendUpdateRequestToSecondary(wrappedRO, rOID, serializable, object);
                    ReplicationManager.resetTimeOut(hostID);
                    if (ReplicationDebugLogger.isDebugEnabled()) {
                        ReplicationDebugLogger.debug(rOID, "Secondary server " + hostID);
                    }
                    return wrappedRO.getSecondaryROInfo();
                }
                catch (MarshalException marshalException) {
                    if (ReplicationDebugLogger.isDebugEnabled()) {
                        ReplicationDebugLogger.debug("MarshalException updating secondary for " + rOID + ", key " + object + ", on " + hostID, marshalException);
                    }
                    ClusterLogger.logUnableToUpdateNonSerializableObject((Exception)marshalException);
                    if (marshalException.detail instanceof NotSerializableException) {
                        wrappedRO.decrementVersion(object);
                        return wrappedRO.getSecondaryROInfo();
                    }
                }
                catch (RemoteException remoteException) {
                    if (ReplicationDebugLogger.isDebugEnabled()) {
                        ReplicationDebugLogger.debug(rOID, "Error updating secondary for " + rOID + ", key " + object + ", on " + hostID, remoteException);
                    }
                }
                catch (NotFoundException notFoundException) {
                    if (ReplicationDebugLogger.isDebugEnabled()) {
                        ReplicationDebugLogger.debug(rOID, "Error updating secondary for " + rOID + ", key " + object + ", on " + hostID + ". Re-creating secondary.", notFoundException);
                    }
                }
                catch (Exception exception) {
                    if (!ReplicationDebugLogger.isDebugEnabled()) break block12;
                    ReplicationDebugLogger.debug(rOID, "Error updating secondary for " + rOID + ", key " + object + ", on " + hostID, exception);
                }
            }
            wrappedRO.setOtherHost(null);
            wrappedRO.setOtherHostInfo(null);
        }
        this.createSecondary(wrappedRO, null);
        return wrappedRO.getSecondaryROInfo();
    }

    private void sendUpdateRequestToSecondary(WrappedRO wrappedRO, ROID rOID, Serializable serializable, Object object) throws RemoteException, NotFoundException {
        HostID hostID = wrappedRO.getOtherHost();
        int n = wrappedRO.incrementVersion(object);
        if (replicationChannels != null) {
            int n2 = wrappedRO.channelIndex;
            assert (n2 != -1);
            ReplicationServicesInternal replicationServicesInternal = this.getRepMan(hostID, replicationChannels[n2]);
            if (ClusterService.getClusterService().useOneWayRMI()) {
                if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                    ReplicationDetailsDebugLogger.debug(rOID, "Using Multi-Channels for 1-way updateOneWay() on channel " + replicationChannels[n2]);
                }
                replicationServicesInternal.updateOneWay(rOID, n, serializable, object);
            } else {
                if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                    ReplicationDetailsDebugLogger.debug(rOID, "Using Multiple-Channels for 2-way update() on channel" + replicationChannels[n2]);
                }
                replicationServicesInternal.update(rOID, n, serializable, object);
            }
        } else {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(rOID, "Using Single-Channel for 2-way update()");
            }
            ReplicationServicesInternal replicationServicesInternal = this.getRepMan(hostID);
            replicationServicesInternal.update(rOID, n, serializable, object);
        }
    }

    protected ReplicationServicesInternal getRepMan(HostID hostID, String string) throws RemoteException {
        if (string == null || string.length() == 0) {
            return this.getRepMan(hostID);
        }
        CompositeKey compositeKey = new CompositeKey(hostID, string);
        ReplicationServicesInternal replicationServicesInternal = (ReplicationServicesInternal)this.cache2.get(compositeKey);
        if (replicationServicesInternal == null) {
            replicationServicesInternal = this.getRepManWithChannelName(hostID, string);
            if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug("Created new stub for hostID " + hostID + " using channel " + string);
            }
            this.cache2.put(compositeKey, replicationServicesInternal);
        }
        return replicationServicesInternal;
    }

    protected ReplicationServicesInternal getRepManWithChannelName(HostID hostID, String string) throws RemoteException {
        ReplicationServicesInternal replicationServicesInternal;
        try {
            replicationServicesInternal = svcLocator.replicationServicesLookup((ServerIdentity)hostID, string, ReplicationManager.class);
        }
        catch (NamingException namingException) {
            throw new RemoteException(namingException.getMessage(), namingException);
        }
        return replicationServicesInternal;
    }

    protected ReplicationServicesInternal getRepMan(HostID hostID) throws RemoteException {
        if (hostID.isLocal()) {
            return this;
        }
        ReplicationServicesInternal replicationServicesInternal = (ReplicationServicesInternal)this.cache.get(hostID);
        if (replicationServicesInternal == null) {
            try {
                replicationServicesInternal = svcLocator.replicationServicesLookup((ServerIdentity)hostID, ReplicationManager.class);
            }
            catch (NamingException namingException) {
                throw new RemoteException(namingException.getMessage(), namingException);
            }
            this.cache.put(hostID, replicationServicesInternal);
        }
        return replicationServicesInternal;
    }

    protected WrappedRO getPrimary(ROID rOID, boolean bl, Object object) throws NotFoundException {
        WrappedRO wrappedRO = this.wroMan.find(rOID);
        if (wrappedRO == null || object != null && wrappedRO.getRO(object) == null) {
            String string = "Unable to find object for roid:" + rOID;
            if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(rOID, string);
            }
            throw new NotFoundException(string);
        }
        wrappedRO.ensureStatus((byte)0);
        if (bl && wrappedRO.getOtherHost() == null) {
            this.createSecondary(wrappedRO, null);
        }
        return wrappedRO;
    }

    protected void createSecondary(WrappedRO wrappedRO, Object object) {
        HostID hostID;
        block7: {
            hostID = wrappedRO.getOtherHost();
            if (hostID == null) {
                hostID = this.getSecondarySelector().getSecondarySrvr();
            }
            Object object2 = object;
            try {
                while (hostID != null) {
                    if (this.trySecondary(wrappedRO, hostID, object2)) {
                        return;
                    }
                    object2 = null;
                    hostID = this.getSecondarySelector().getSecondarySrvr();
                }
            }
            catch (ApplicationUnavailableException applicationUnavailableException) {
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ReplicationDebugLogger.debug(wrappedRO.getID(), "Failed to create secondary as secondary " + hostID + " doesn't have the " + "application ready; Will try other hosts", applicationUnavailableException);
                }
                if (!this.trySecondaryOnOtherServers(wrappedRO)) break block7;
                return;
            }
        }
        wrappedRO.setOtherHost(null);
        wrappedRO.setOtherHostInfo(null);
        if (ReplicationDebugLogger.isDebugEnabled()) {
            ReplicationDebugLogger.debug(wrappedRO.getID(), "Unable to create secondary on " + hostID);
        }
    }

    protected boolean trySecondary(WrappedRO wrappedRO, HostID hostID, Object object) {
        try {
            ReplicationServicesInternal replicationServicesInternal;
            try {
                replicationServicesInternal = this.getRepMan(hostID);
            }
            catch (RemoteException remoteException) {
                this.cleanupDeadServer(hostID);
                throw remoteException;
            }
            if (object == null) {
                Iterator iterator = wrappedRO.keys();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    int n = wrappedRO.getVersion(e);
                    wrappedRO.setOtherHostInfo(replicationServicesInternal.create(LOCAL_HOSTID, n, wrappedRO.getID(), wrappedRO.getRO(e)));
                }
            } else {
                int n = wrappedRO.getVersion(object);
                wrappedRO.setOtherHostInfo(replicationServicesInternal.create(LOCAL_HOSTID, n, wrappedRO.getID(), wrappedRO.getRO(object)));
            }
            wrappedRO.setOtherHost(hostID);
            ReplicationManager.resetTimeOut(hostID);
            if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(wrappedRO.getID(), "Created secondary on " + hostID);
            }
            return true;
        }
        catch (ConnectException connectException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "Failed to reach secondary server " + hostID + " trying to create secondary", connectException);
            } else if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(wrappedRO.getID(), "Failed to reach secondary server " + hostID + " trying to create secondary");
            }
            this.cleanupDeadServer(hostID);
            return false;
        }
        catch (ServerShuttingDownException serverShuttingDownException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "Secondary server " + hostID + " is shutting down. Failed to create secondary.", serverShuttingDownException);
            } else if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(wrappedRO.getID(), "Secondary server " + hostID + " is shutting down. Failed to create secondary");
            }
            this.cleanupDeadServer(hostID);
            return false;
        }
        catch (ConnectIOException connectIOException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "ConnectIOException while trying to connect to secondary server " + hostID + " for creating secondary", connectIOException);
            } else if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(wrappedRO.getID(), "ConnectIOException while trying to connect to secondary server " + hostID + " for creating secondary");
            }
            this.cleanupDeadServer(hostID);
            return false;
        }
        catch (MarshalException marshalException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("Marshalling error", marshalException);
            }
            ClusterLogger.logUnableToUpdateNonSerializableObject((Exception)marshalException);
            return true;
        }
        catch (PeerGoneException peerGoneException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "Error creating secondary on " + hostID, peerGoneException);
            } else if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(wrappedRO.getID(), "PeerGoneException while creating secondary on " + hostID);
            }
            return false;
        }
        catch (UnmarshalException unmarshalException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug("Unmarshalling error", unmarshalException);
            }
            ClusterLogger.logUnableToUpdateNonSerializableObject((Exception)unmarshalException);
            return true;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            ClusterExtensionLogger.logUnexpectedExceptionDuringReplication((Throwable)remoteRuntimeException.getCause());
            return true;
        }
        catch (RequestTimeoutException requestTimeoutException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "Error creating secondary on " + hostID, requestTimeoutException);
            } else if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(wrappedRO.getID(), "RequestTimeoutException while creating secondary on " + hostID);
            }
            return false;
        }
        catch (RemoteException remoteException) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "Error creating secondary on " + hostID, remoteException);
            } else if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(wrappedRO.getID(), "RemoteException while creating secondary on " + hostID);
            }
            return false;
        }
    }

    protected void cleanupDeadServer(HostID hostID) {
        this.cache.remove(hostID);
        this.getSecondarySelector().removeDeadSecondarySrvr(hostID);
    }

    private boolean trySecondaryOnOtherServers(WrappedRO wrappedRO) {
        for (HostID hostID : this.getSecondarySelector().getSecondaryCandidates()) {
            try {
                if (!this.trySecondary(wrappedRO, hostID, null)) continue;
                return true;
            }
            catch (ApplicationUnavailableException applicationUnavailableException) {
                if (!ReplicationDebugLogger.isDebugEnabled()) continue;
                ReplicationDebugLogger.debug(wrappedRO.getID(), "Failed to create secondary as secondary " + hostID + " doesn't have the application ready ", applicationUnavailableException);
            }
        }
        return false;
    }

    @Override
    public final Object create(HostID hostID, int n, ROID rOID, Replicatable replicatable) throws RemoteException {
        int n2;
        if (replicatable == null) {
            throw new RemoteException("Got a Null replicatable for id " + rOID + " version " + n + " from primary " + hostID.toString());
        }
        ReplicationManager.resetTimeOut(hostID);
        WrappedRO wrappedRO = this.wroMan.find(rOID);
        if (wrappedRO != null && (n2 = wrappedRO.getVersion(replicatable.getKey())) > n) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(rOID, "Received stale update request with new version " + n + " from primary: " + hostID + " Existing Object info" + "\n\totherhost " + (wrappedRO.getOtherHost() != null ? wrappedRO.getOtherHost() : "null") + "\n\tcurrent version " + n2);
            }
            ClusterLogger.logStaleReplicationRequest((String)rOID.toString());
            return null;
        }
        wrappedRO = this.wroMan.create(replicatable, rOID, (byte)1, n);
        wrappedRO.setOtherHost(hostID);
        Object object = wrappedRO.getSecondaryROInfo();
        return object;
    }

    @Override
    public void update(ROID rOID, int n, Serializable serializable, Object object) throws NotFoundException, RemoteException {
        this.updateInternal("update", rOID, n, serializable, object);
    }

    @Override
    public void updateOneWay(ROID rOID, int n, Serializable serializable, Object object) throws NotFoundException, RemoteException {
        this.updateInternal("updateOneWay", rOID, n, serializable, object);
    }

    private void updateInternal(String string, ROID rOID, int n, Serializable serializable, Object object) throws NotFoundException {
        int n2;
        WrappedRO wrappedRO = this.wroMan.find(rOID);
        if (wrappedRO == null) {
            throw new NotFoundException("Unable to find " + rOID);
        }
        HostID hostID = wrappedRO.getOtherHost();
        if (hostID != null) {
            ReplicationManager.resetTimeOut(hostID);
        }
        if ((n2 = wrappedRO.getVersion(object)) > n) {
            ClusterLogger.logStaleReplicationRequest((String)rOID.toString());
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(wrappedRO.getID(), "Got stale replication request for UPDATE with version " + n + " from " + wrappedRO.getOtherHost());
            }
        } else if (n2 == -1) {
            if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                ReplicationDetailsDebugLogger.debug(rOID, "RO not found for key " + object);
            }
        } else {
            int n3 = n - n2;
            if (n3 != 1) {
                if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                    ReplicationDetailsDebugLogger.debug("Missed " + n3 + " updates for " + rOID.toString() + ", key " + object + ", update version: " + n + ", current version: " + n2);
                }
                if (string.equals("update")) {
                    ClusterLogger.logReplicationVersionMismatch((int)n3, (String)(rOID + "; update version: " + n + ", current version: " + n2));
                    throw new NotFoundException("Lost " + n3 + " updates of " + rOID);
                }
                if (counter < 1000) {
                    ++counter;
                    ClusterExtensionLogger.logOutOfOrderUpdateOneWayRequest();
                }
            } else {
                wrappedRO.ensureStatus((byte)1);
                wrappedRO.incrementVersion(object);
                Replicatable replicatable = wrappedRO.getRO(object);
                if (replicatable == null) {
                    if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
                        ReplicationDetailsDebugLogger.debug("Remote object was null for key " + object + ", for version update " + n + " from " + wrappedRO.getOtherHost() + "for replication object " + rOID.toString());
                    }
                    throw new AssertionError((Object)("Found the session for " + rOID + " but not the application for " + object + ". Double-check that proxy/loadbalancers are respecting " + "session stickiness."));
                }
                replicatable.update(rOID, serializable);
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ReplicationDebugLogger.debug("Updated local secondary with version " + n + " from " + wrappedRO.getOtherHost() + "for replication object " + rOID.toString() + ", key " + object + ", ro = " + replicatable.toString());
                }
            }
        }
    }

    @Override
    public void update(AsyncBatch asyncBatch) throws RemoteException {
        throw new UnsupportedOperationException("ReplicationManager should not take batched updates");
    }

    @Override
    public final void remove(ROID[] rOIDArray, Object object) throws RemoteException {
        this.removeInternal("remove", rOIDArray, object);
    }

    @Override
    public final void removeOneWay(ROID[] rOIDArray, Object object) throws RemoteException {
        this.removeInternal("removeOneWay", rOIDArray, object);
    }

    private void removeInternal(String string, ROID[] rOIDArray, Object object) throws RemoteException {
        for (int i = 0; i < rOIDArray.length; ++i) {
            WrappedRO wrappedRO = this.wroMan.find(rOIDArray[i]);
            if (wrappedRO != null && wrappedRO.getStatus() != 0) {
                HostID hostID = wrappedRO.getOtherHost();
                if (hostID != null) {
                    ReplicationManager.resetTimeOut(hostID);
                }
                this.wroMan.remove(rOIDArray[i], object);
                if (!ReplicationDebugLogger.isDebugEnabled()) continue;
                ReplicationDebugLogger.debug("Removed secondary for roids: " + rOIDArray[i]);
                continue;
            }
            if (!ReplicationDebugLogger.isDebugEnabled()) continue;
            if (wrappedRO != null && wrappedRO.getStatus() == 0) {
                ReplicationDebugLogger.debug("Attempt to remove current primary which is old secondary: " + rOIDArray[i]);
                continue;
            }
            ReplicationDebugLogger.debug("Attempt to remove non-existent object for roids: " + rOIDArray[i]);
        }
    }

    @Override
    public final void remove(ROID[] rOIDArray) throws RemoteException {
        for (int i = 0; i < rOIDArray.length; ++i) {
            WrappedRO wrappedRO = this.wroMan.find(rOIDArray[i]);
            if (wrappedRO != null) {
                wrappedRO.ensureStatus((byte)1);
                this.wroMan.removeAll(rOIDArray[i]);
                if (!ReplicationDebugLogger.isDebugEnabled()) continue;
                ReplicationDebugLogger.debug("Removed migrated secondary for roids: " + rOIDArray[i]);
                continue;
            }
            if (!ReplicationDebugLogger.isDebugEnabled()) continue;
            ReplicationDebugLogger.debug("Attempt to remove non-existent object for roids: " + rOIDArray[i]);
        }
    }

    @Override
    public final ROObject fetch(ROID rOID) throws RemoteException, NotFoundException {
        WrappedRO wrappedRO;
        if (ReplicationDetailsDebugLogger.isDebugEnabled()) {
            ReplicationDetailsDebugLogger.debug("Fetching " + rOID);
        }
        if ((wrappedRO = this.wroMan.find(rOID)) != null) {
            return new ROObject(wrappedRO.getMap(), wrappedRO.getVersionMap(), wrappedRO.getVersion());
        }
        throw new NotFoundException("Failed to locate ROID " + rOID);
    }

    @Override
    public final Iterator<WrappedRO> ids() {
        return this.wroMan.iterator();
    }

    public final long getPrimaryCount() {
        int n = 0;
        Iterator<WrappedRO> iterator = this.wroMan.iterator();
        while (iterator.hasNext()) {
            WrappedRO wrappedRO = iterator.next();
            if (wrappedRO.getStatus() != 0) continue;
            ++n;
        }
        return n;
    }

    public final long getSecondaryCount() {
        int n = 0;
        Iterator<WrappedRO> iterator = this.wroMan.iterator();
        while (iterator.hasNext()) {
            WrappedRO wrappedRO = iterator.next();
            if (wrappedRO.getStatus() != 1) continue;
            ++n;
        }
        return n;
    }

    public final String[] getSecondaryDistributionNames() {
        String[] stringArray2;
        Object object;
        NumericValueHashtable numericValueHashtable = new NumericValueHashtable();
        Iterator<WrappedRO> iterator = this.wroMan.iterator();
        while (iterator.hasNext()) {
            HostID hostID;
            object = iterator.next();
            if (((WrappedRO)object).getStatus() != 1 || (hostID = ((WrappedRO)object).getOtherHost()) == null) continue;
            if (!numericValueHashtable.containsKey((Object)hostID)) {
                numericValueHashtable.put((Object)hostID, 1L);
                continue;
            }
            numericValueHashtable.put((Object)hostID, numericValueHashtable.get((Object)hostID) + 1L);
        }
        object = new ArrayList();
        for (String[] stringArray2 : this.getSecondarySelector().getSecondaryCandidates()) {
            long l = numericValueHashtable.get((Object)stringArray2);
            if (l <= 0L) continue;
            ((ArrayList)object).add(stringArray2.getServerName() + " : " + l);
        }
        stringArray2 = new String[((ArrayList)object).size()];
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            stringArray2[i] = (String)((ArrayList)object).get(i);
        }
        return stringArray2;
    }

    protected SecondarySelector getSecondarySelector() {
        return selector;
    }

    protected static void resetTimeOut(HostID hostID) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ROObject
    implements Externalizable {
        private static final long serialVersionUID = -5018057544806950295L;
        private int version;
        private Map ros;
        private Map<Object, Integer> roVersions;

        public ROObject() {
        }

        ROObject(Map map, Map<Object, Integer> map2, int n) {
            this.ros = map;
            this.version = n;
            this.roVersions = map2;
        }

        final int getVersion() {
            return this.version;
        }

        final int getVersion(Object object) {
            Integer n;
            if (this.roVersions != null && (n = this.roVersions.get(object)) != null) {
                return n;
            }
            return this.version;
        }

        final Map<Object, Integer> getVersions() {
            return this.roVersions;
        }

        final Map getROS() {
            return this.ros;
        }

        @Override
        public final void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.ros);
            objectOutput.writeInt(this.version);
            objectOutput.writeObject(this.roVersions);
        }

        @Override
        public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            PeerInfo peerInfo;
            this.ros = (Map)objectInput.readObject();
            this.version = objectInput.readInt();
            if (objectInput instanceof PeerInfoable && (peerInfo = ((PeerInfoable)objectInput).getPeerInfo()).compareTo((Object)PeerInfo.VERSION_1030) > 0) {
                this.roVersions = (Map)objectInput.readObject();
            }
        }
    }

    private static class CompositeKey {
        private final HostID hostID;
        private final String channelName;
        private final int hashcode;

        CompositeKey(HostID hostID, String string) {
            this.hostID = hostID;
            this.channelName = string;
            this.hashcode = hostID.hashCode() ^ string.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CompositeKey) {
                CompositeKey compositeKey = (CompositeKey)object;
                return (this.channelName == compositeKey.channelName || this.channelName != null && this.channelName.equals(compositeKey.channelName)) && (this.hostID == compositeKey.hostID || this.hostID != null && this.hostID.equals(compositeKey.hostID));
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class wroManager {
        private final Map<ROID, WrappedRO> wros = new ConcurrentHashMap<ROID, WrappedRO>(317);

        protected wroManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WrappedRO create(Replicatable replicatable, ROID rOID, byte by, int n) {
            int n2;
            WrappedRO wrappedRO;
            ROID rOID2 = rOID;
            synchronized (rOID2) {
                wrappedRO = this.wros.get(rOID);
                if (wrappedRO == null) {
                    if (ReplicationDebugLogger.isDebugEnabled()) {
                        ReplicationDebugLogger.debug(rOID, "Creating " + (by == 0 ? "primary " : "secondary ") + " for application key " + (replicatable != null ? replicatable.getKey() : "null"));
                    }
                    wrappedRO = new WrappedRO(replicatable, rOID, by, n);
                    this.wros.put(rOID, wrappedRO);
                    return wrappedRO;
                }
            }
            wrappedRO.ensureStatus(by);
            if (ReplicationDebugLogger.isDebugEnabled()) {
                ReplicationDebugLogger.debug(rOID, "Found " + (by == 0 ? "primary " : "secondary ") + " for application key " + (replicatable != null ? replicatable.getKey() : "null"));
            }
            if ((n2 = wrappedRO.getVersion(replicatable.getKey())) == -1) {
                wrappedRO.addRO(replicatable, n);
            } else {
                wrappedRO.addRO(replicatable, n2);
            }
            return wrappedRO;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WrappedRO remove(ROID rOID, Object object) {
            Replicatable replicatable;
            WrappedRO wrappedRO;
            ROID rOID2 = rOID;
            synchronized (rOID2) {
                wrappedRO = this.wros.get(rOID);
                if (wrappedRO == null) {
                    return null;
                }
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ReplicationDebugLogger.debug(wrappedRO.getID(), "Removing " + (wrappedRO.getStatus() == 0 ? "primary " : "secondary ") + " for key " + object);
                }
                replicatable = wrappedRO.getRO(object);
                if (object == null || wrappedRO.removeRO(object)) {
                    this.wros.remove(wrappedRO.getID());
                }
            }
            if (replicatable != null && wrappedRO.getStatus() == 1) {
                replicatable.becomeUnregistered(rOID);
            }
            return wrappedRO;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WrappedRO removeAll(ROID rOID) {
            ROID rOID2 = rOID;
            synchronized (rOID2) {
                WrappedRO wrappedRO = this.wros.remove(rOID);
                if (wrappedRO == null) {
                    return null;
                }
                if (ReplicationDebugLogger.isDebugEnabled()) {
                    ReplicationDebugLogger.debug(wrappedRO.getID(), "Removing " + (wrappedRO.getStatus() == 0 ? "primary " : "secondary "));
                }
                wrappedRO.removeAll();
                return wrappedRO;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WrappedRO find(ROID rOID) {
            ROID rOID2 = rOID;
            synchronized (rOID2) {
                return this.wros.get(rOID);
            }
        }

        public Iterator<WrappedRO> iterator() {
            return this.wros.values().iterator();
        }
    }

    private static class SingletonMaker {
        private static final ReplicationManager singleton = new ReplicationManager();

        private SingletonMaker() {
        }
    }
}

