/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.replication.SecureReplicationInvocationHandler;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.spi.EndPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.channels.ChannelService;
import weblogic.utils.collections.LRUCacheHashMap;
import weblogic.work.ExecuteQueueFactory;
import weblogic.work.ServerWorkManagerFactory;
import weblogic.work.WorkManager;

public class ReplicationManagerServerRef
extends BasicServerRef {
    private static final String REP_CHANNEL_NAME;
    private static ServerChannel replicationChannel;
    private static Map<ServerChannel, WorkManager> dispatchPolicyMapping;
    private static boolean USE_SSL;
    private static final String SERVER_NAME;
    private static final String CLUSTER_NAME;
    private static final int MAX_CACHE = 512;
    private static final Object PRIVILDEGED;
    private static final AuthenticatedSubject KERNEL_ID;
    private static Map<AuthenticatedSubject, Object> cache;

    public ReplicationManagerServerRef(int n, Object object) throws RemoteException {
        super(n, object);
    }

    private static void initialize(ServerMBean serverMBean) {
        List<String> list = ChannelService.getReplicationChannelNames();
        if (list.size() > 0) {
            String[] stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
            dispatchPolicyMapping = new HashMap<ServerChannel, WorkManager>();
            for (String string : stringArray) {
                ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((String)string);
                if (serverChannel == null) {
                    ClusterExtensionLogger.logNoChannelForReplicationCalls((String)CLUSTER_NAME);
                    throw new AssertionError((Object)("Can't find replication server channel '" + string + "' for " + SERVER_NAME));
                }
                WorkManager workManager = serverMBean.getUse81StyleExecuteQueues() ? ExecuteQueueFactory.createExecuteQueue(string, 1) : ServerWorkManagerFactory.createExecuteQueue(string, 1);
                dispatchPolicyMapping.put(serverChannel, workManager);
            }
        }
        if ((replicationChannel = ServerChannelManager.findLocalServerChannel((String)REP_CHANNEL_NAME)) != null) {
            USE_SSL = replicationChannel.getProtocol().isSecure();
        } else {
            replicationChannel = ServerChannelManager.findLocalServerChannel((Protocol)(USE_SSL ? ProtocolManager.getDefaultSecureProtocol() : ProtocolManager.getDefaultProtocol()));
        }
        if (replicationChannel == null) {
            ClusterExtensionLogger.logNoChannelForReplicationCalls((String)CLUSTER_NAME);
            throw new AssertionError((Object)("No replication server channel for " + SERVER_NAME));
        }
    }

    private void reqReceivedOnReplicationChannel(ServerChannel serverChannel) throws RemoteException {
        if (dispatchPolicyMapping != null && dispatchPolicyMapping.containsKey(serverChannel)) {
            return;
        }
        if (replicationChannel.equals(serverChannel)) {
            return;
        }
        ClusterLogger.logWrongChannelForReplicationCalls((String)CLUSTER_NAME, (String)serverChannel.getChannelName());
        SecurityException securityException = new SecurityException("Incorrect channel used for replication " + serverChannel);
        throw new RemoteException(securityException.getMessage(), securityException);
    }

    protected WorkManager getWorkManager(ServerChannel serverChannel, RuntimeMethodDescriptor runtimeMethodDescriptor, AuthenticatedSubject authenticatedSubject) {
        WorkManager workManager = replicationChannel.equals(serverChannel) ? super.getWorkManager(runtimeMethodDescriptor, authenticatedSubject) : dispatchPolicyMapping.get(serverChannel);
        return workManager;
    }

    protected void checkPriviledges(AuthenticatedSubject authenticatedSubject, ServerChannel serverChannel, EndPoint endPoint) throws RemoteException {
        if (serverChannel == null) {
            SecurityException securityException = new SecurityException("ServerChannel is null");
            throw new RemoteException(securityException.getMessage(), securityException);
        }
        this.reqReceivedOnReplicationChannel(serverChannel);
        if (authenticatedSubject == null) {
            SecurityException securityException = new SecurityException("AuthenticatedSubject is null");
            throw new RemoteException(securityException.getMessage(), securityException);
        }
        if (ReplicationManagerServerRef.doesCacheContains(authenticatedSubject)) {
            ReplicationManagerServerRef.getFromCache(authenticatedSubject);
            return;
        }
        ReplicationManagerServerRef.verifyAndCachePriviledgesFor(authenticatedSubject);
    }

    private static boolean doesCacheContains(AuthenticatedSubject authenticatedSubject) {
        return cache.containsKey(authenticatedSubject);
    }

    private static void getFromCache(AuthenticatedSubject authenticatedSubject) throws RemoteException {
        Object object = cache.get(authenticatedSubject);
        if (object instanceof RemoteException) {
            throw (RemoteException)object;
        }
    }

    private static void verifyAndCachePriviledgesFor(AuthenticatedSubject authenticatedSubject) throws RemoteException {
        try {
            SecureReplicationInvocationHandler.checkPriviledges(authenticatedSubject, USE_SSL);
        }
        catch (SecurityException securityException) {
            RemoteException remoteException = new RemoteException(securityException.getMessage(), securityException);
            cache.put(authenticatedSubject, remoteException);
            throw remoteException;
        }
        cache.put(authenticatedSubject, PRIVILDEGED);
    }

    static {
        PRIVILDEGED = new Object();
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        cache = Collections.synchronizedMap(new LRUCacheHashMap(512));
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer();
        SERVER_NAME = serverMBean.getName();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean == null) {
            throw new AssertionError((Object)"Can't have replication without a cluster");
        }
        CLUSTER_NAME = clusterMBean.getName();
        REP_CHANNEL_NAME = clusterMBean.getReplicationChannel();
        USE_SSL = clusterMBean.isSecureReplicationEnabled();
        ReplicationManagerServerRef.initialize(serverMBean);
    }
}

