/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.security.AccessController;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.replication.AsyncReplicationManager;
import weblogic.cluster.replication.MANAsyncReplicationManager;
import weblogic.cluster.replication.MANReplicationManager;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.servlet.cluster.WANPersistenceManager;

public class ReplicationService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean != null) {
            ReplicationManager.start();
            ClusterLogger.logStartingReplicationService((String)"async", (String)clusterMBean.getClusterAddress());
            AsyncReplicationManager.start();
            if (clusterMBean.getClusterType().equals("man")) {
                ClusterLogger.logStartingReplicationService((String)"man", (String)clusterMBean.getRemoteClusterAddress());
                MANReplicationManager.start();
                ClusterLogger.logStartingReplicationService((String)"man-async", (String)clusterMBean.getRemoteClusterAddress());
                MANAsyncReplicationManager.start();
            } else if (clusterMBean.getClusterType().equals("wan")) {
                ClusterLogger.logStartingReplicationService((String)"wan", (String)clusterMBean.getRemoteClusterAddress());
                WANPersistenceManager.getControlInstance().start();
            }
        }
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public void halt() throws ServiceFailureException {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean != null) {
            ReplicationManager.stop();
            ClusterLogger.logStoppingReplicationService((String)"async");
            AsyncReplicationManager.stop();
            if (clusterMBean.getClusterType().equals("man")) {
                ClusterLogger.logStoppingReplicationService((String)"man");
                MANReplicationManager.stop();
                ClusterLogger.logStoppingReplicationService((String)"man-async");
                MANReplicationManager.stop();
            } else if (clusterMBean.getClusterType().equals("wan")) {
                ClusterLogger.logStoppingReplicationService((String)"wan");
                WANPersistenceManager.getControlInstance().stop();
            }
        }
    }
}

